/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.util;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.Border;

public class RoundedBorder
implements Border {
    int radius;

    public RoundedBorder() {
        this(5);
    }

    public RoundedBorder(int radius) {
        this.radius = radius;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return new Insets(0, this.radius, 0, this.radius);
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        g.setColor(c.getParent().getBackground());
        g.fillRect(x, y, this.radius, height);
        g.fillRect(x + width - this.radius, y, this.radius, height);
        g.setColor(c.getBackground());
        g.fillArc(x, y, this.radius * 2, this.radius * 2, 90, 90);
        g.fillArc(x, y + height - this.radius * 2 - 1, this.radius * 2, this.radius * 2, 180, 90);
        g.fillRect(x, y + this.radius, this.radius + 1, height - 2 * this.radius);
        g.fillArc(x + width - this.radius * 2 - 1, y, this.radius * 2, this.radius * 2, 0, 90);
        g.fillArc(x + width - this.radius * 2 - 1, y + height - this.radius * 2 - 1, this.radius * 2, this.radius * 2, 270, 90);
        g.fillRect(x + width - this.radius - 1, y + this.radius, this.radius + 1, height - 2 * this.radius);
    }
}

