/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.util;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.SeparatorList;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.TextFilterator;
import ca.odell.glazedlists.matchers.MatcherEditor;
import ca.odell.glazedlists.swing.EventListModel;
import ca.odell.glazedlists.swing.TextComponentMatcherEditor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Comparator;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;
import se.streamsource.dci.value.link.LinkValue;
import se.streamsource.dci.value.link.TitledLinkValue;
import se.streamsource.streamflow.client.util.FilterLinkListCellRenderer;
import se.streamsource.streamflow.client.util.LinkComparator;
import se.streamsource.streamflow.client.util.LinkFilterator;
import se.streamsource.streamflow.client.util.SeparatorListCellRenderer;
import se.streamsource.streamflow.client.util.TitledLinkGroupingComparator;

public class GroupedFilteredList
extends JPanel
implements PropertyChangeListener {
    private JTextField filterField;
    private JList list;
    public JScrollPane pane = new JScrollPane();

    public GroupedFilteredList() {
        this.setLayout(new BorderLayout());
        this.filterField = new JTextField(20);
        FilterLinkListCellRenderer filterCellRenderer = new FilterLinkListCellRenderer();
        filterCellRenderer.addPropertyChangeListener(this);
        this.filterField.getDocument().addDocumentListener(filterCellRenderer);
        this.list = new JList();
        this.list.setCellRenderer(new SeparatorListCellRenderer(filterCellRenderer));
        this.list.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (GroupedFilteredList.this.list.getSelectedValue() instanceof SeparatorList.Separator) {
                    GroupedFilteredList.this.list.clearSelection();
                }
            }
        });
        this.pane.setViewportView(this.list);
        this.add((Component)this.filterField, "North");
        this.add((Component)this.pane, "Center");
    }

    public JTextField getFilterField() {
        return this.filterField;
    }

    public JList getList() {
        return this.list;
    }

    public JScrollPane getPane() {
        return this.pane;
    }

    public void setEventList(EventList<TitledLinkValue> eventList) {
        this.setEventList(eventList, "");
    }

    public void setEventList(EventList<TitledLinkValue> eventList, String topValue) {
        this.setEventList(eventList, topValue, true);
    }

    public void setEventList(EventList<TitledLinkValue> eventList, String topValue, final boolean selectMatchAlways) {
        SortedList sortedIssues = new SortedList(eventList, (Comparator)new LinkComparator());
        TextComponentMatcherEditor editor = new TextComponentMatcherEditor((JTextComponent)this.filterField, (TextFilterator)new LinkFilterator());
        editor.addMatcherEditorListener(new MatcherEditor.Listener(){

            public void changedMatcher(MatcherEditor.Event event) {
                for (int i = 0; i < GroupedFilteredList.this.list.getModel().getSize(); ++i) {
                    if (GroupedFilteredList.this.list.getModel().getElementAt(i) == null || !(GroupedFilteredList.this.list.getModel().getElementAt(i) instanceof LinkValue)) continue;
                    final int idx = i;
                    if (!selectMatchAlways) break;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            GroupedFilteredList.this.list.setSelectedIndex(idx);
                        }
                    });
                    break;
                }
            }
        });
        FilterList textFilteredIssues = new FilterList((EventList)sortedIssues, (MatcherEditor)editor);
        EventListModel listModel = new EventListModel((EventList)new SeparatorList((EventList)textFilteredIssues, (Comparator)new TitledLinkGroupingComparator(topValue), 1, 10000));
        this.list.setModel(listModel);
        this.filterField.setText("");
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("text")) {
            this.list.repaint();
        }
    }
}

