/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.util;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import java.awt.Component;
import javax.swing.JLabel;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;
import se.streamsource.streamflow.client.util.ActionBinder;
import se.streamsource.streamflow.client.util.ValueBinder;

public class BindingFormBuilder2 {
    private DefaultFormBuilder formBuilder;
    private ResourceMap resourceMap;
    private ActionBinder actionBinder;
    private ValueBinder valueBinder;

    public BindingFormBuilder2(DefaultFormBuilder formBuilder, ActionBinder actionBinder, ValueBinder valueBinder) {
        this(formBuilder, actionBinder, valueBinder, null);
    }

    public BindingFormBuilder2(DefaultFormBuilder formBuilder, ActionBinder actionBinder, ValueBinder valueBinder, ResourceMap resourceMap) {
        this.formBuilder = formBuilder;
        this.actionBinder = actionBinder;
        this.valueBinder = valueBinder;
        this.resourceMap = resourceMap;
    }

    public BindingFormBuilder2 appendWithLabel(Enum resourceKey, Component component, String valueBinding, String actionBinding, Object ... args) {
        String resource = this.getResource(resourceKey, args);
        JLabel label = this.formBuilder.append(resource);
        label.setFocusable(false);
        label.setLabelFor(component);
        return this.append(component, valueBinding, actionBinding);
    }

    public BindingFormBuilder2 append(Component component, String valueBinding, String actionBinding) {
        if (valueBinding != null) {
            this.valueBinder.bind(valueBinding, component);
        }
        if (actionBinding != null) {
            this.actionBinder.bind(actionBinding, component);
        }
        this.formBuilder.append(component);
        return this;
    }

    public BindingFormBuilder2 nextLine() {
        this.formBuilder.nextLine();
        return this;
    }

    public String getResource(Enum resourceKey, Object ... args) {
        String resource;
        String key = resourceKey.toString();
        String string = resource = this.resourceMap == null ? null : this.resourceMap.getString(key, args);
        if (resource == null) {
            ResourceMap map = Application.getInstance().getContext().getResourceMap(resourceKey.getClass());
            resource = map.getString(key, args);
        }
        if (resource == null) {
            resource = "#" + key;
        }
        return resource;
    }

    public void setActionBinder(ActionBinder actionBinder) {
        this.actionBinder = actionBinder;
    }

    public void setValueBinder(ValueBinder valueBinder) {
        this.valueBinder = valueBinder;
    }

    public DefaultFormBuilder getFormBuilder() {
        return this.formBuilder;
    }
}

