/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.util;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import java.awt.Component;
import java.text.DateFormat;
import java.util.Locale;
import java.util.TimeZone;
import javax.swing.Action;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import org.jdesktop.application.Application;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.swingx.JXDatePicker;
import org.qi4j.api.property.Property;
import se.streamsource.streamflow.client.ui.workspace.cases.general.forms.TextAreaFieldPanel;
import se.streamsource.streamflow.client.util.RegexPatternFormatter;
import se.streamsource.streamflow.client.util.StateBinder;
import se.streamsource.streamflow.client.util.StreamflowButton;

@Deprecated
public class BindingFormBuilder {
    private DefaultFormBuilder formBuilder;
    private ResourceMap resourceMap;
    private StateBinder stateBinder;

    public BindingFormBuilder(DefaultFormBuilder formBuilder, StateBinder stateBinder) {
        this(formBuilder, stateBinder, null);
    }

    public BindingFormBuilder(DefaultFormBuilder formBuilder, StateBinder stateBinder, ResourceMap resourceMap) {
        this.formBuilder = formBuilder;
        this.resourceMap = resourceMap;
        this.stateBinder = stateBinder;
    }

    public BindingFormBuilder appendLine(Enum resourceKey, Fields fieldType, Property property, Object ... args) {
        return this.appendLine(resourceKey, fieldType.newField(), property, this.stateBinder, args);
    }

    public BindingFormBuilder appendLine(Enum resourceKey, Component component, Property property, Object ... args) {
        return this.appendLine(resourceKey, component, property, this.stateBinder, args);
    }

    public BindingFormBuilder appendLine(Enum resourceKey, Fields fieldType, Property property, StateBinder stateBinderIn, Object ... args) {
        return this.appendLine(resourceKey, fieldType.newField(), property, stateBinderIn, args);
    }

    public BindingFormBuilder appendLine(Enum resourceKey, Component component, Property property, StateBinder stateBinderIn, Object ... args) {
        this.append(resourceKey, component, property, stateBinderIn, args);
        this.formBuilder.nextLine();
        return this;
    }

    public BindingFormBuilder append(String name, String tooltip, Component component, Property property, StateBinder stateBinderIn) {
        JLabel label = this.formBuilder.append(name);
        label.setFocusable(false);
        label.setLabelFor(component);
        label.setToolTipText(tooltip);
        this.formBuilder.nextLine();
        return this.append(component, property, stateBinderIn);
    }

    public BindingFormBuilder append(String name, Component component, Property property, StateBinder stateBinderIn) {
        JLabel label = this.formBuilder.append(name);
        label.setFocusable(false);
        label.setLabelFor(component);
        this.formBuilder.nextLine();
        return this.append(component, property, stateBinderIn);
    }

    public BindingFormBuilder append(Enum resourceKey, Component component, Property property, StateBinder stateBinderIn, Object ... args) {
        String resource = this.getResource(resourceKey, args);
        JLabel label = this.formBuilder.append(resource);
        label.setFocusable(false);
        label.setLabelFor(component);
        this.formBuilder.nextLine();
        return this.append(component, property, stateBinderIn);
    }

    public BindingFormBuilder append(Component component, Property property, StateBinder stateBinderIn) {
        stateBinderIn.bind(component, property);
        if (component instanceof TextAreaFieldPanel) {
            this.formBuilder.append(component, 2);
        } else {
            this.formBuilder.append(component);
        }
        if (component instanceof JXDatePicker) {
            ((JXDatePicker)component).setFormats(new DateFormat[]{DateFormat.getDateInstance(2, Locale.getDefault())});
        }
        return this;
    }

    public BindingFormBuilder appendButtonLine(Action buttonAction) {
        StreamflowButton button = new StreamflowButton(buttonAction);
        this.formBuilder.append((Component)button);
        this.formBuilder.nextLine();
        return this;
    }

    public BindingFormBuilder appendToggleButtonLine(Action buttonAction) {
        JToggleButton button = new JToggleButton(buttonAction);
        this.formBuilder.append((Component)button);
        this.formBuilder.nextLine();
        return this;
    }

    public BindingFormBuilder append(Component component) {
        this.formBuilder.append(component);
        return this;
    }

    public BindingFormBuilder append(Component component, int columnSpan) {
        this.formBuilder.append(component, columnSpan);
        return this;
    }

    public BindingFormBuilder appendLine(Component component) {
        this.formBuilder.append(component);
        this.formBuilder.nextLine();
        return this;
    }

    public BindingFormBuilder appendSeparator(Enum resourceKey) {
        this.formBuilder.appendSeparator(this.getResource(resourceKey, new Object[0]));
        return this;
    }

    public BindingFormBuilder appendFormattedTextField(Enum resourceKey, Enum resourceKeyPattern, Property property, StateBinder stateBinderIn, Object ... args) {
        String resource = this.getResource(resourceKey, args);
        String pattern = this.getResource(resourceKeyPattern, args);
        JLabel label = this.formBuilder.append(resource);
        this.formBuilder.nextLine();
        JFormattedTextField component = new JFormattedTextField(new RegexPatternFormatter(pattern));
        stateBinderIn.bind(component, property);
        this.formBuilder.append((Component)component);
        label.setLabelFor(component);
        this.formBuilder.nextLine();
        return this;
    }

    public String getResource(Enum resourceKey, Object ... args) {
        String resource;
        String key = resourceKey.toString();
        String string = resource = this.resourceMap == null ? null : this.resourceMap.getString(key, args);
        if (resource == null) {
            ResourceMap map = Application.getInstance().getContext().getResourceMap(resourceKey.getClass());
            resource = map.getString(key, args);
        }
        if (resource == null) {
            resource = "#" + key;
        }
        return resource;
    }

    public static enum Fields {
        LABEL{

            @Override
            public Component newField() {
                JLabel jLabel = new JLabel();
                jLabel.setFocusable(false);
                return jLabel;
            }
        }
        ,
        TEXTFIELD{

            @Override
            public Component newField() {
                return new JTextField(30);
            }
        }
        ,
        FORMATTEDTEXTFIELD{

            @Override
            public Component newField() {
                return new JFormattedTextField((Object)30);
            }
        }
        ,
        PASSWORD{

            @Override
            public Component newField() {
                return new JPasswordField(15);
            }
        }
        ,
        TEXTAREA{

            @Override
            public Component newField() {
                JTextArea text = new JTextArea(10, 30);
                text.setLineWrap(true);
                text.setWrapStyleWord(true);
                return new JScrollPane(text);
            }
        }
        ,
        CHECKBOX{

            @Override
            public Component newField() {
                return new JCheckBox();
            }
        }
        ,
        RADIOBUTTON{

            @Override
            public Component newField() {
                return new JRadioButton();
            }
        }
        ,
        COMBOBOX{

            @Override
            public Component newField() {
                return new JComboBox();
            }
        }
        ,
        DATEPICKER{

            @Override
            public Component newField() {
                JXDatePicker jxDatePicker = new JXDatePicker(Locale.getDefault());
                jxDatePicker.setTimeZone(TimeZone.getTimeZone("UTC"));
                jxDatePicker.getMonthView().setFirstDayOfWeek(2);
                return jxDatePicker;
            }
        };


        public abstract Component newField();
    }
}

