/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.util;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputVerifier;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.JXDialog;
import org.jdesktop.swingx.util.WindowUtils;
import org.qi4j.api.constraint.ConstraintViolationException;
import org.qi4j.api.injection.scope.Uses;
import se.streamsource.streamflow.client.ui.administration.AdministrationResources;
import se.streamsource.streamflow.client.ui.workspace.cases.general.RemovableLabel;
import se.streamsource.streamflow.client.util.StreamflowJXColorSelectionButton;
import se.streamsource.streamflow.client.util.i18n;

public class ActionBinder {
    ResourceBundle errorMessages;
    List<Binder> binders = new ArrayList<Binder>();
    private final ActionMap actionMap;

    public ActionBinder(@Uses ActionMap actionMap) {
        this.actionMap = actionMap;
        DefaultBinder defaultBinder = new DefaultBinder();
        this.registerBinder(defaultBinder);
        this.errorMessages = ResourceBundle.getBundle(this.getClass().getName());
    }

    public void setResourceMap(final ResourceMap resourceMap) {
        this.errorMessages = new ResourceBundle(){

            @Override
            protected Object handleGetObject(String key) {
                return resourceMap.getString(key, new Object[0]);
            }

            @Override
            public Enumeration<String> getKeys() {
                return Collections.enumeration(resourceMap.keySet());
            }
        };
    }

    public void registerBinder(Binder binder) {
        this.binders.add(binder);
    }

    public <T extends Component> T bind(String name, T component) {
        Action action;
        Object boundComponent = component;
        if (boundComponent instanceof JScrollPane) {
            boundComponent = ((JScrollPane)boundComponent).getViewport().getView();
        }
        if ((action = this.actionMap.get(name)) == null) {
            throw new IllegalArgumentException("No action named '" + name + "' in action map");
        }
        for (Binder binder : this.binders) {
            if (!binder.bind((Component)boundComponent, action)) continue;
            return component;
        }
        throw new IllegalArgumentException("No binder registered for component type:" + component.getClass().getSimpleName());
    }

    class ActionInputVerifier
    extends InputVerifier {
        private final Action action;
        Exception exception;

        ActionInputVerifier(Action action) {
            this.action = action;
        }

        @Override
        public boolean verify(JComponent input) {
            try {
                this.action.actionPerformed(new ActionEvent(input, 1001, this.action.getValue("Name").toString()));
                return true;
            }
            catch (Exception e) {
                this.exception = e;
                return false;
            }
        }

        @Override
        public boolean shouldYieldFocus(JComponent input) {
            boolean result = super.shouldYieldFocus(input);
            if (!result) {
                Window window = WindowUtils.findWindow((Component)input);
                StringBuilder message = new StringBuilder(i18n.text(AdministrationResources.invalid_value, new Object[0]));
                if (this.exception instanceof ConstraintViolationException) {
                    ConstraintViolationException ex = (ConstraintViolationException)((Object)this.exception);
                    String[] messages = ex.getLocalizedMessages(ActionBinder.this.errorMessages);
                    message = new StringBuilder("<html>");
                    for (String s : messages) {
                        message.append("<p>").append(s).append("</p>");
                    }
                    message.append("</html>");
                } else {
                    message.append(this.exception.getMessage());
                }
                JLabel main = new JLabel(message.toString());
                JXDialog dialog = window instanceof Frame ? new JXDialog((Frame)window, (JComponent)main) : new JXDialog((Dialog)window, (JComponent)main);
                dialog.setModal(true);
                dialog.pack();
                dialog.setLocationRelativeTo((Component)SwingUtilities.windowForComponent(input));
                dialog.setVisible(true);
            }
            return result;
        }
    }

    private class DefaultBinder
    implements Binder {
        @Override
        public boolean bind(Component component, final Action action) {
            if (component instanceof JPasswordField) {
                JPasswordField passwordField = (JPasswordField)component;
                passwordField.setInputVerifier(new ActionInputVerifier(action));
            } else if (component instanceof JTextField) {
                JTextField textField = (JTextField)component;
                textField.setInputVerifier(new ActionInputVerifier(action));
            } else if (component instanceof JTextComponent) {
                JTextComponent textComponent = (JTextComponent)component;
                textComponent.setInputVerifier(new ActionInputVerifier(action));
            } else if (component instanceof AbstractButton) {
                final AbstractButton button = (AbstractButton)component;
                if (component instanceof StreamflowJXColorSelectionButton) {
                    button.addPropertyChangeListener("background", new PropertyChangeListener(){

                        @Override
                        public void propertyChange(PropertyChangeEvent e) {
                            action.actionPerformed(new ActionEvent(button, 1001, action.getValue("Name").toString()));
                        }
                    });
                } else {
                    button.addActionListener(action);
                }
            } else if (component instanceof JXDatePicker) {
                final JXDatePicker datePicker = (JXDatePicker)component;
                datePicker.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent e) {
                        if ("date".equals(e.getPropertyName())) {
                            action.actionPerformed(new ActionEvent(datePicker, 1001, action.getValue("Name").toString()));
                        }
                    }
                });
            } else if (component instanceof JComboBox) {
                JComboBox comboBox = (JComboBox)component;
                comboBox.addActionListener(action);
            } else if (component instanceof RemovableLabel) {
                RemovableLabel removableLabel = (RemovableLabel)component;
                removableLabel.getButton().addActionListener(action);
            } else {
                return false;
            }
            return true;
        }
    }

    public static interface Binder {
        public boolean bind(Component var1, Action var2);
    }
}

