/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.workspace.table;

import java.util.Date;
import org.joda.time.DateMidnight;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.qi4j.api.common.Optional;
import org.qi4j.api.injection.scope.Uses;
import se.streamsource.streamflow.client.ui.workspace.table.Period;

public class PerspectivePeriodModel {
    private Date date;
    private Period period;

    public void PerspectiveModel(@Uses @Optional Date date, @Uses Period period) {
        this.date = date;
        this.period = period;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public Period getPeriod() {
        return this.period;
    }

    public void setPeriod(Period period) {
        this.period = period;
    }

    public String getSearchValue(String datePattern, String separator) {
        if (!this.period.equals((Object)Period.none)) {
            if (this.date == null) {
                return this.getSearchPeriod(new Date(), -1, this.getPeriod().name(), datePattern, separator);
            }
            return this.getSearchPeriod(this.date, 1, this.getPeriod().name(), datePattern, separator);
        }
        return "";
    }

    private String getSearchPeriod(Date fromDate, int direction, String periodName, String datePattern, String separator) {
        DateMidnight from = new DateMidnight((Object)fromDate);
        DateMidnight to = null;
        DateTimeFormatter format = DateTimeFormat.forPattern((String)datePattern);
        switch (Period.valueOf(periodName)) {
            case one_day: {
                return format.print((ReadableInstant)from);
            }
            case three_days: {
                to = direction == 1 ? from.plusDays(2) : from.minusDays(2);
                break;
            }
            case one_week: {
                to = direction == 1 ? from.plusWeeks(1).minusDays(1) : from.minusWeeks(1).plusDays(1);
                break;
            }
            case two_weeks: {
                to = direction == 1 ? from.plusWeeks(2).minusDays(1) : from.minusWeeks(2).plusDays(1);
                break;
            }
            case one_month: {
                to = direction == 1 ? from.plusMonths(1).minusDays(1) : from.minusMonths(1).plusDays(1);
                break;
            }
            case six_months: {
                to = direction == 1 ? from.plusMonths(6).minusDays(1) : from.minusMonths(6).plusDays(1);
                break;
            }
            case one_year: {
                to = direction == 1 ? from.plusYears(1).minusDays(1) : from.minusYears(1).plusDays(1);
            }
        }
        return direction == 1 ? format.print((ReadableInstant)from) + separator + format.print((ReadableInstant)to) : format.print((ReadableInstant)to) + separator + format.print((ReadableInstant)from);
    }
}

