/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.workspace.table;

import ca.odell.glazedlists.SeparatorList;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.net.URL;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.swingx.JXTable;
import org.qi4j.api.common.Optional;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.structure.Module;
import se.streamsource.streamflow.client.Icons;
import se.streamsource.streamflow.client.OperationException;
import se.streamsource.streamflow.client.ui.workspace.WorkspaceResources;
import se.streamsource.streamflow.client.ui.workspace.cases.CaseDetailView;
import se.streamsource.streamflow.client.ui.workspace.cases.CaseResources;
import se.streamsource.streamflow.client.ui.workspace.cases.CasesModel;
import se.streamsource.streamflow.client.ui.workspace.table.CasesDetailView;
import se.streamsource.streamflow.client.ui.workspace.table.CasesTableView;
import se.streamsource.streamflow.client.util.HtmlPanel;
import se.streamsource.streamflow.client.util.i18n;

public class CasesView
extends JPanel {
    private CasesTableView casesTableView;
    private CasesDetailView detailsView;
    private JSplitPane splitPane;
    private CardLayout cardLayout = new CardLayout();
    private JComponent blank;
    private CasesModel casesModel;
    private JTextField searchField;
    private JPanel topPanel;

    public CasesView(@Structure Module module, @Service ApplicationContext context, @Uses CasesModel casesModel, @Optional @Uses JTextField searchField) {
        this.casesModel = casesModel;
        this.searchField = searchField;
        this.setActionMap((ActionMap)context.getActionMap((Object)this));
        this.setLayout(this.cardLayout);
        this.detailsView = (CasesDetailView)module.objectBuilderFactory().newObjectBuilder(CasesDetailView.class).use(new Object[]{casesModel}).newInstance();
        this.splitPane = new JSplitPane(0);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setTopComponent(new JPanel());
        this.splitPane.setBottomComponent(this.detailsView);
        this.splitPane.setResizeWeight(0.27);
        this.splitPane.setDividerLocation(1.0);
        this.splitPane.setBorder(BorderFactory.createEmptyBorder());
        this.topPanel = new JPanel(new BorderLayout());
        this.topPanel.add((Component)this.splitPane, "Center");
        this.blank = this.createBlankPanel();
        this.add((Component)this.blank, "blank");
        this.add((Component)this.topPanel, "cases");
        this.cardLayout.show(this, "blank");
    }

    protected JPanel createBlankPanel() {
        JPanel blankPanel = new JPanel(new BorderLayout());
        URL logoURL = this.getClass().getResource(i18n.text(Icons.sf_logo, new Object[0]));
        HtmlPanel blankPane = new HtmlPanel(i18n.text(WorkspaceResources.welcome, logoURL.toExternalForm()));
        blankPanel.add((Component)blankPane, "Center");
        return blankPanel;
    }

    public void showTable(final CasesTableView casesTableView) {
        this.cardLayout.show(this, "cases");
        this.casesTableView = casesTableView;
        this.casesTableView.getCaseTable().getSelectionModel().addListSelectionListener(new CaseSelectionListener());
        this.splitPane.setTopComponent(casesTableView);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CasesView.this.detailsView.selectCaseInTable((JTable)casesTableView.getCaseTable());
            }
        });
    }

    public void clearTable() {
        this.cardLayout.show(this, "blank");
        this.casesTableView = null;
        this.splitPane.setTopComponent(new JPanel());
        this.clearCase();
    }

    public void clearCase() {
        this.detailsView.clear();
    }

    public CasesTableView getCaseTableView() {
        return this.casesTableView;
    }

    public CaseDetailView getCurrentCaseView() {
        return this.detailsView.getCurrentCaseView();
    }

    public void refresh() {
        if (this.casesTableView != null) {
            this.casesTableView.getModel().refresh();
        }
        this.detailsView.refresh();
    }

    public void setBlankPanel(JComponent blankPanel) {
        this.remove(this.blank);
        this.blank = blankPanel;
        this.add((Component)this.blank, "blank");
    }

    class CaseSelectionListener
    implements ListSelectionListener {
        CaseSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                JXTable caseTable = CasesView.this.getCaseTableView().getCaseTable();
                SwingUtilities.invokeLater(new Runnable((JTable)caseTable){
                    final /* synthetic */ JTable val$caseTable;
                    {
                        this.val$caseTable = jTable;
                    }

                    @Override
                    public void run() {
                        try {
                            if (!this.val$caseTable.getSelectionModel().isSelectionEmpty()) {
                                int selectedRow = this.val$caseTable.getSelectedRow();
                                Object selectedValue = this.val$caseTable.getModel().getValueAt(this.val$caseTable.convertRowIndexToModel(selectedRow), 10);
                                if (selectedRow != -1 && !(selectedValue instanceof SeparatorList.Separator)) {
                                    String href = (String)selectedValue;
                                    CasesView.this.detailsView.show(CasesView.this.casesModel.newCaseModel(href));
                                }
                            } else {
                                CasesView.this.detailsView.selectCaseInTable(this.val$caseTable);
                            }
                        }
                        catch (Exception e1) {
                            throw new OperationException(CaseResources.could_not_view_details, (Throwable)e1);
                        }
                    }
                });
            }
        }
    }
}

