/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.workspace.context;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jdesktop.application.Application;
import org.jdesktop.application.Task;
import org.qi4j.api.injection.scope.Uses;
import org.restlet.data.Reference;
import se.streamsource.dci.restlet.client.CommandQueryClient;
import se.streamsource.dci.value.link.LinkValue;
import se.streamsource.dci.value.link.LinksValue;
import se.streamsource.streamflow.client.ui.ContextItem;
import se.streamsource.streamflow.client.ui.workspace.WorkspaceResources;
import se.streamsource.streamflow.client.util.EventListSynch;
import se.streamsource.streamflow.client.util.Refreshable;
import se.streamsource.streamflow.client.util.i18n;

public class WorkspaceContextModel
implements Refreshable {
    EventList<ContextItem> items = new BasicEventList();
    @Uses
    CommandQueryClient client;
    LinksValue caseCounts;

    public EventList<ContextItem> getItems() {
        return this.items;
    }

    @Override
    public void refresh() {
        new Task<LinksValue, Object>(Application.getInstance()){

            protected LinksValue doInBackground() throws Exception {
                return (LinksValue)WorkspaceContextModel.this.client.query("casecounts", LinksValue.class);
            }

            protected void succeeded(LinksValue linksValue) {
                WorkspaceContextModel.this.caseCounts = linksValue;
                WorkspaceContextModel.this.applyCounts();
            }
        }.execute();
        ArrayList<ContextItem> list = new ArrayList<ContextItem>();
        LinksValue projects = (LinksValue)this.client.query("index", LinksValue.class);
        for (LinkValue contextLink : (List)projects.links().get()) {
            if (((String)contextLink.rel().get()).equals("drafts")) {
                list.add(new ContextItem("", i18n.text(WorkspaceResources.drafts_node, new Object[0]), "draft", -1L, this.client.getClient(contextLink)));
                continue;
            }
            if (((String)contextLink.rel().get()).equals("search")) {
                list.add(new ContextItem("", i18n.text(WorkspaceResources.search_node, new Object[0]), "search", -1L, this.client.getClient(contextLink)));
                continue;
            }
            if (((String)contextLink.rel().get()).equals("perspective")) {
                list.add(new ContextItem("", (String)contextLink.text().get(), (String)contextLink.rel().get(), -1L, this.client.getClient(contextLink)));
                continue;
            }
            if (((String)contextLink.rel().get()).equals("inbox")) {
                list.add(new ContextItem((String)contextLink.text().get(), i18n.text(WorkspaceResources.inboxes_node, new Object[0]), "inbox", -1L, this.client.getClient(contextLink)));
                continue;
            }
            if (!((String)contextLink.rel().get()).equals("assignments")) continue;
            list.add(new ContextItem((String)contextLink.text().get(), i18n.text(WorkspaceResources.assignments_node, new Object[0]), "assign", -1L, this.client.getClient(contextLink)));
        }
        EventListSynch.synchronize(Collections.emptyList(), this.items);
        EventListSynch.synchronize(list, this.items);
        this.applyCounts();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void applyCounts() {
        if (this.caseCounts != null) {
            block3: for (LinkValue linkValue : (List)this.caseCounts.links().get()) {
                this.items.getReadWriteLock().writeLock().lock();
                try {
                    for (int i = 0; i < this.items.size(); ++i) {
                        ContextItem item = (ContextItem)this.items.get(i);
                        Reference reference = item.getClient().getReference();
                        String ref = reference.getPath();
                        ref = ref.endsWith("user/drafts/") ? "user/drafts" : ref.substring(0, ref.length() - 1);
                        if (!ref.endsWith((String)linkValue.id().get())) continue;
                        item.setCount(Long.valueOf((String)linkValue.text().get()));
                        this.items.set(i, (Object)item);
                        continue block3;
                    }
                }
                finally {
                    this.items.getReadWriteLock().writeLock().unlock();
                }
            }
        }
    }
}

