/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.workspace.cases.general.forms.geo;

import java.util.ArrayList;
import java.util.List;
import org.jxmapviewer.viewer.GeoPosition;
import se.streamsource.streamflow.client.ui.workspace.cases.general.forms.geo.GeoMarker;

class PolygonMarker
extends GeoMarker {
    private List<GeoPosition> points = new ArrayList<GeoPosition>();

    public PolygonMarker(Iterable<GeoPosition> points) {
        for (GeoPosition p : points) {
            this.points.add(p);
        }
    }

    @Override
    public List<GeoPosition> getPoints() {
        return this.points;
    }

    @Override
    public String stringify() {
        StringBuilder sb = new StringBuilder();
        boolean firstElement = true;
        for (GeoPosition p : this.points) {
            if (firstElement) {
                firstElement = false;
            } else {
                sb.append(',');
            }
            sb.append('(');
            sb.append(PolygonMarker.stringify(p));
            sb.append(')');
        }
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.points == null ? 0 : this.points.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PolygonMarker other = (PolygonMarker)obj;
        return !(this.points == null ? other.points != null : !this.points.equals(other.points));
    }
}

