/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.workspace.cases.general.forms.geo;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.HashSet;
import javax.swing.ActionMap;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import org.apache.commons.lang.StringUtils;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationContext;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.OSMTileFactoryInfo;
import org.jxmapviewer.VirtualEarthTileFactoryInfo;
import org.jxmapviewer.viewer.DefaultTileFactory;
import org.jxmapviewer.viewer.GeoPosition;
import org.jxmapviewer.viewer.TileFactory;
import org.jxmapviewer.viewer.TileFactoryInfo;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.object.ObjectBuilder;
import org.qi4j.api.value.ValueBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.streamsource.streamflow.api.administration.form.GeoLocationFieldValue;
import se.streamsource.streamflow.api.administration.form.LocationDTO;
import se.streamsource.streamflow.api.workspace.cases.general.FieldSubmissionDTO;
import se.streamsource.streamflow.api.workspace.cases.general.FormDraftSettingsDTO;
import se.streamsource.streamflow.client.ui.workspace.cases.general.forms.AbstractFieldPanel;
import se.streamsource.streamflow.client.ui.workspace.cases.general.forms.FormSubmissionWizardPageModel;
import se.streamsource.streamflow.client.ui.workspace.cases.general.forms.geo.AreaSelectionInteractionMode;
import se.streamsource.streamflow.client.ui.workspace.cases.general.forms.geo.GeoLocationFieldPanelResources;
import se.streamsource.streamflow.client.ui.workspace.cases.general.forms.geo.GeoMarker;
import se.streamsource.streamflow.client.ui.workspace.cases.general.forms.geo.GeoMarkerHolder;
import se.streamsource.streamflow.client.ui.workspace.cases.general.forms.geo.LineSelectionInteractionMode;
import se.streamsource.streamflow.client.ui.workspace.cases.general.forms.geo.MapInteractionMode;
import se.streamsource.streamflow.client.ui.workspace.cases.general.forms.geo.PanZoomInteractionMode;
import se.streamsource.streamflow.client.ui.workspace.cases.general.forms.geo.PointMarker;
import se.streamsource.streamflow.client.ui.workspace.cases.general.forms.geo.PointSelectionInteractionMode;
import se.streamsource.streamflow.client.util.StateBinder;
import se.streamsource.streamflow.client.util.StreamflowToggleButton;
import se.streamsource.streamflow.client.util.i18n;
import se.streamsource.streamflow.client.util.mapquest.MapquestAddress;
import se.streamsource.streamflow.client.util.mapquest.MapquestNominatimService;
import se.streamsource.streamflow.client.util.mapquest.MapquestQueryResult;

public class GeoLocationFieldPanel
extends AbstractFieldPanel
implements GeoMarkerHolder {
    private static final Logger logger = LoggerFactory.getLogger(GeoLocationFieldPanel.class);
    private StateBinder.Binding binding;
    private JXMapViewer mapViewer;
    private MapInteractionMode currentInteractionMode;
    private String currentValue;
    private GeoLocationFieldValue fieldValue;
    @Uses
    ObjectBuilder<MapquestNominatimService> geoLookupServiceBuilder;
    private FormSubmissionWizardPageModel model;
    private FormDraftSettingsDTO formDraftSettings;
    private ButtonGroup modeButtonGroup;
    private JLabel addressInfoLabel;
    private JLabel helpHintLabel;

    public GeoLocationFieldPanel(@Service ApplicationContext appContext, @Uses FieldSubmissionDTO field, @Uses GeoLocationFieldValue fieldValue, @Uses FormSubmissionWizardPageModel model) {
        super(field);
        this.model = model;
        this.fieldValue = fieldValue;
        this.formDraftSettings = model.getFormDraftModel().settings();
        this.setActionMap((ActionMap)appContext.getActionMap((Object)this));
        this.mapViewer = this.createMapViewer();
        this.setMapType(MapType.ROAD_MAP);
        JPanel controlPanel = this.createControlPanel();
        FormLayout layout = new FormLayout("1dlu, 20dlu:grow, 4dlu, pref", "260dlu");
        this.setLayout((LayoutManager)layout);
        this.add((Component)this.mapViewer, new CellConstraints(2, 1, CellConstraints.FILL, CellConstraints.FILL));
        this.add((Component)controlPanel, new CellConstraints(4, 1, CellConstraints.DEFAULT, CellConstraints.FILL));
    }

    private JXMapViewer createMapViewer() {
        JXMapViewer mapViewer = new JXMapViewer();
        mapViewer.setZoom(7);
        mapViewer.setBorder((Border)new LineBorder(Color.GRAY));
        mapViewer.addComponentListener((ComponentListener)new InitialMapScrollHandler());
        return mapViewer;
    }

    private JPanel createControlPanel() {
        JComboBox<MapType> mapTypeSelector = this.createMapTypeSelector();
        JPanel modeButtonPanel = this.createModeButtonPanel();
        this.addressInfoLabel = new JLabel();
        this.helpHintLabel = new JLabel();
        FormLayout layout = new FormLayout("60dlu", "pref, 4dlu, pref, 4dlu, pref, 4dlu, pref:grow");
        JPanel controlPanel = new JPanel((LayoutManager)layout);
        controlPanel.add(mapTypeSelector, new CellConstraints(1, 1));
        controlPanel.add((Component)modeButtonPanel, new CellConstraints(1, 3, CellConstraints.FILL, CellConstraints.DEFAULT));
        controlPanel.add((Component)this.addressInfoLabel, new CellConstraints(1, 5));
        controlPanel.add((Component)this.helpHintLabel, new CellConstraints(1, 7, CellConstraints.DEFAULT, CellConstraints.BOTTOM));
        return controlPanel;
    }

    private JComboBox<MapType> createMapTypeSelector() {
        final JComboBox<MapType> mapTypeSelector = new JComboBox<MapType>(MapType.values());
        mapTypeSelector.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                GeoLocationFieldPanel.this.setMapType((MapType)((Object)mapTypeSelector.getSelectedItem()));
            }
        });
        return mapTypeSelector;
    }

    private JPanel createModeButtonPanel() {
        this.modeButtonGroup = new ButtonGroup();
        FormLayout layout = new FormLayout("pref:grow", "pref, pref, pref");
        PanelBuilder builder = new PanelBuilder(layout);
        if (((Boolean)this.fieldValue.point().get()).booleanValue()) {
            StreamflowToggleButton selectPointButton = new StreamflowToggleButton(this.getActionMap().get("startPointSelection"));
            this.modeButtonGroup.add(selectPointButton);
            builder.add((Component)selectPointButton);
            builder.nextRow();
        }
        if (((Boolean)this.fieldValue.polyline().get()).booleanValue()) {
            StreamflowToggleButton selectLineButton = new StreamflowToggleButton(this.getActionMap().get("startLineSelection"));
            this.modeButtonGroup.add(selectLineButton);
            builder.add((Component)selectLineButton);
            builder.nextRow();
        }
        if (((Boolean)this.fieldValue.polygon().get()).booleanValue()) {
            StreamflowToggleButton selectPolygonButton = new StreamflowToggleButton(this.getActionMap().get("startAreaSelection"));
            this.modeButtonGroup.add(selectPolygonButton);
            builder.add((Component)selectPolygonButton);
            builder.nextRow();
        }
        return builder.getPanel();
    }

    private void setMapType(MapType mapType) {
        if (this.mapViewer.getTileFactory() != null) {
            this.mapViewer.getTileFactory().dispose();
        }
        switch (mapType) {
            case ROAD_MAP: {
                OSMTileFactoryInfo info = new OSMTileFactoryInfo();
                DefaultTileFactory tileFactory = new DefaultTileFactory((TileFactoryInfo)info);
                this.mapViewer.setTileFactory((TileFactory)tileFactory);
                break;
            }
            case SATELLITE: {
                VirtualEarthTileFactoryInfo info = new VirtualEarthTileFactoryInfo(VirtualEarthTileFactoryInfo.SATELLITE);
                DefaultTileFactory tileFactory = new DefaultTileFactory((TileFactoryInfo)info);
                this.mapViewer.setTileFactory((TileFactory)tileFactory);
                break;
            }
            default: {
                this.mapViewer.setTileFactory(null);
            }
        }
    }

    @Override
    public String getValue() {
        return this.currentValue;
    }

    @Override
    public void setValue(String newValue) {
        this.currentValue = newValue;
        this.addressInfoLabel.setText(GeoLocationFieldPanel.formatAddressInfo(this.getCurrentLocationData()));
        this.switchInteractionMode(new PanZoomInteractionMode());
        this.scrollMarkerIntoView(this.getCurrentGeoMarker());
    }

    private static String formatAddressInfo(LocationDTO locationDTO) {
        ArrayList<Object> elements = new ArrayList<Object>();
        if (!StringUtils.isBlank((String)((String)locationDTO.street().get()))) {
            elements.add(locationDTO.street().get());
        }
        if (!StringUtils.isBlank((String)((String)locationDTO.zipcode().get()))) {
            elements.add(locationDTO.zipcode().get());
        }
        if (!StringUtils.isBlank((String)((String)locationDTO.city().get()))) {
            elements.add(locationDTO.city().get());
        }
        if (!StringUtils.isBlank((String)((String)locationDTO.country().get()))) {
            elements.add(locationDTO.country().get());
        }
        return "<html>" + StringUtils.join(elements, (String)", ") + "</html>";
    }

    public LocationDTO getCurrentLocationData() {
        return (LocationDTO)this.module.valueBuilderFactory().newValueFromJSON(LocationDTO.class, "".equals(this.currentValue) ? "{}" : this.currentValue);
    }

    @Override
    public GeoMarker getCurrentGeoMarker() {
        return GeoMarker.parseGeoMarker((String)this.getCurrentLocationData().location().get());
    }

    @Override
    public void updateGeoMarker(GeoMarker marker) {
        LocationDTO locationData = this.locationDataForMarker(marker);
        this.currentValue = locationData.toJSON();
        this.addressInfoLabel.setText(GeoLocationFieldPanel.formatAddressInfo(locationData));
        this.binding.updateProperty(this.getValue());
        this.switchInteractionMode(new PanZoomInteractionMode());
        this.initiateGetAddressInfo(marker);
    }

    private void initiateGetAddressInfo(GeoMarker marker) {
        final GeoPosition firstPoint = marker.getPoints().get(0);
        new SwingWorker<MapquestQueryResult, Object>(){

            @Override
            protected MapquestQueryResult doInBackground() throws Exception {
                String urlPattern = (String)GeoLocationFieldPanel.this.formDraftSettings.mapquestReverseLookupUrlPattern().get();
                MapquestNominatimService geoLookupService = (MapquestNominatimService)GeoLocationFieldPanel.this.geoLookupServiceBuilder.use(new Object[]{urlPattern}).newInstance();
                return geoLookupService.reverseLookup(firstPoint.getLatitude(), firstPoint.getLongitude());
            }

            @Override
            protected void done() {
                try {
                    GeoLocationFieldPanel.this.updateAddressInfo((MapquestQueryResult)this.get());
                }
                catch (Exception e) {
                    logger.warn("Failed to get address info", (Throwable)e);
                }
            }
        }.execute();
    }

    private void updateAddressInfo(MapquestQueryResult mapquestQueryResult) {
        LocationDTO updatedLocationData = this.locationDataWithAddressInfo(this.getCurrentLocationData(), mapquestQueryResult);
        this.currentValue = updatedLocationData.toJSON();
        this.addressInfoLabel.setText(GeoLocationFieldPanel.formatAddressInfo(updatedLocationData));
        this.binding.updateProperty(this.getValue());
    }

    private LocationDTO locationDataForMarker(GeoMarker marker) {
        ValueBuilder builder = this.module.valueBuilderFactory().newValueBuilder(LocationDTO.class);
        LocationDTO prototype = (LocationDTO)builder.prototype();
        prototype.location().set((Object)marker.stringify());
        return (LocationDTO)builder.newInstance();
    }

    private LocationDTO locationDataWithAddressInfo(LocationDTO locationData, MapquestQueryResult mapquestQueryResult) {
        ValueBuilder builder = this.module.valueBuilderFactory().newValueBuilder(LocationDTO.class).withPrototype((Object)locationData);
        LocationDTO prototype = (LocationDTO)builder.prototype();
        MapquestAddress address = mapquestQueryResult.getAddress();
        String street = this.firstNonNull(address.getRoad(), address.getPedestrian(), "");
        if (address.getHouse_number() != null) {
            street = street + " " + address.getHouse_number();
        }
        prototype.street().set((Object)street);
        prototype.zipcode().set((Object)this.firstNonNull(address.getPostcode(), ""));
        prototype.city().set((Object)this.firstNonNull(address.getTown(), address.getCity(), address.getCounty(), ""));
        prototype.country().set((Object)this.firstNonNull(address.getCountry(), ""));
        return (LocationDTO)builder.newInstance();
    }

    private <T> T firstNonNull(T ... args) {
        for (T t : args) {
            if (t == null) continue;
            return t;
        }
        return null;
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.mapViewer.getTileFactory().dispose();
    }

    private void scrollMarkerIntoView(GeoMarker marker) {
        if (marker == null) {
            GeoPosition defaultPosition = ((PointMarker)GeoMarker.parseGeoMarker((String)this.formDraftSettings.location().get())).getPosition();
            this.mapViewer.setAddressLocation(defaultPosition);
            this.mapViewer.setZoom(this.formDraftSettings.zoomLevel().get() != null ? (Integer)this.formDraftSettings.zoomLevel().get() : 6);
        } else if (marker instanceof PointMarker) {
            this.mapViewer.setAddressLocation(((PointMarker)marker).getPosition());
            this.mapViewer.setZoom(this.formDraftSettings.zoomLevel().get() != null ? (Integer)this.formDraftSettings.zoomLevel().get() : 6);
        } else {
            HashSet<GeoPosition> positionsForMarker = new HashSet<GeoPosition>(marker.getPoints());
            this.mapViewer.zoomToBestFit(positionsForMarker, 0.5);
        }
    }

    @Action
    public void startPointSelection() {
        this.switchInteractionMode(new PointSelectionInteractionMode());
    }

    @Action
    public void startLineSelection() {
        this.switchInteractionMode(new LineSelectionInteractionMode());
    }

    @Action
    public void startAreaSelection() {
        this.switchInteractionMode(new AreaSelectionInteractionMode());
    }

    private void switchInteractionMode(MapInteractionMode newMode) {
        if (this.currentInteractionMode != null) {
            this.currentInteractionMode.leaveMode(this.mapViewer);
        }
        if (newMode instanceof PanZoomInteractionMode) {
            this.modeButtonGroup.clearSelection();
        }
        newMode.enterMode(this.mapViewer, this);
        this.helpHintLabel.setText("<html>" + newMode.getHelpHint() + "</html>");
        this.currentInteractionMode = newMode;
    }

    @Override
    public void setBinding(StateBinder.Binding binding) {
        this.binding = binding;
    }

    class InitialMapScrollHandler
    extends ComponentAdapter {
        InitialMapScrollHandler() {
        }

        @Override
        public void componentShown(ComponentEvent e) {
            GeoLocationFieldPanel.this.scrollMarkerIntoView(GeoLocationFieldPanel.this.getCurrentGeoMarker());
        }

        @Override
        public void componentResized(ComponentEvent e) {
            GeoLocationFieldPanel.this.scrollMarkerIntoView(GeoLocationFieldPanel.this.getCurrentGeoMarker());
        }
    }

    static enum MapType {
        ROAD_MAP(i18n.text(GeoLocationFieldPanelResources.map_type_road_map, new Object[0])),
        SATELLITE(i18n.text(GeoLocationFieldPanelResources.map_type_satellite, new Object[0]));

        String name;

        private MapType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

