/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.workspace.cases.general.forms;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.text.ParseException;
import javax.swing.ActionMap;
import javax.swing.BoxLayout;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.JTextComponent;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationContext;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Uses;
import se.streamsource.dci.value.link.LinkValue;
import se.streamsource.streamflow.api.administration.form.FieldDefinitionValue;
import se.streamsource.streamflow.api.administration.form.TextFieldValue;
import se.streamsource.streamflow.api.workspace.cases.contact.StreetSearchDTO;
import se.streamsource.streamflow.api.workspace.cases.general.FieldSubmissionDTO;
import se.streamsource.streamflow.api.workspace.cases.general.FieldSubmissionPluginDTO;
import se.streamsource.streamflow.client.ui.workspace.cases.CaseResources;
import se.streamsource.streamflow.client.ui.workspace.cases.general.forms.AbstractFieldPanel;
import se.streamsource.streamflow.client.ui.workspace.cases.general.forms.FormStreetAddressSuggestModel;
import se.streamsource.streamflow.client.ui.workspace.cases.general.forms.FormSubmissionWizardPageModel;
import se.streamsource.streamflow.client.util.RegexPatternFormatter;
import se.streamsource.streamflow.client.util.StateBinder;
import se.streamsource.streamflow.client.util.StreamflowButton;
import se.streamsource.streamflow.client.util.SuggestTextField;
import se.streamsource.streamflow.client.util.TextTransferHandler;
import se.streamsource.streamflow.client.util.dialog.DialogService;
import se.streamsource.streamflow.client.util.i18n;
import se.streamsource.streamflow.util.Strings;

public class TextFieldPanel
extends AbstractFieldPanel {
    private JTextField textField;
    private TextFieldValue fieldValue;
    private StreamflowButton openMapButton;
    private StreamflowButton pasteMapCoordinatesButton;
    @Service
    DialogService dialogs;
    private FormSubmissionWizardPageModel model;

    public TextFieldPanel(@Service ApplicationContext appContext, @Uses FieldSubmissionDTO field, @Uses TextFieldValue fieldValue, @Uses FormSubmissionWizardPageModel model) {
        super(field);
        this.model = model;
        this.setLayout(new BoxLayout(this, 0));
        this.fieldValue = fieldValue;
        if ("http://www.w3.org/2006/vcard/ns#street-address".equals(((FieldDefinitionValue)field.field().get()).datatypeUrl().get()) && model.getFormDraftModel().isStreetLookupEnabled()) {
            FormStreetAddressSuggestModel suggestModel = new FormStreetAddressSuggestModel();
            suggestModel.setFormDraftModel(model.getFormDraftModel());
            SuggestTextField<StreetSearchDTO> suggestTextField = new SuggestTextField<StreetSearchDTO>(suggestModel);
            this.textField = suggestTextField.getTextField();
            this.add(suggestTextField);
        } else {
            this.textField = new JTextField();
            this.add(this.textField);
        }
        this.textField.setColumns((Integer)fieldValue.width().get());
        this.setActionMap((ActionMap)appContext.getActionMap((Object)this));
        ActionMap am = this.getActionMap();
        if ("http://www.w3.org/2006/vcard/ns#geo".equals(((FieldDefinitionValue)field.field().get()).datatypeUrl().get()) && field instanceof FieldSubmissionPluginDTO && ((FieldSubmissionPluginDTO)field).plugin().get() != null) {
            TextTransferHandler th = new TextTransferHandler();
            this.textField.setTransferHandler(th);
            javax.swing.Action openMapAction = am.get("openMap");
            this.openMapButton = new StreamflowButton(openMapAction);
            this.add(this.openMapButton);
            javax.swing.Action pasteMapCoordinatesAction = am.get("pasteMapCoordinates");
            this.pasteMapCoordinatesButton = new StreamflowButton(pasteMapCoordinatesAction);
            this.add(this.pasteMapCoordinatesButton);
        }
    }

    @Action
    public void pasteMapCoordinates(final ActionEvent event) {
        this.textField.requestFocusInWindow();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TextFieldPanel.this.textField.setText("");
                DefaultEditorKit.PasteAction pasteAction = new DefaultEditorKit.PasteAction();
                pasteAction.actionPerformed(event);
                String formattedValue = TextFieldPanel.this.textField.getText().trim().replace(",", ".").replace(";", ",");
                TextFieldPanel.this.textField.setText(formattedValue);
            }
        });
    }

    @Action
    public void openMap() {
        Runtime rt = Runtime.getRuntime();
        try {
            String kartagoclientexe = this.model.kartagoclientexe((LinkValue)((FieldSubmissionPluginDTO)this.getField()).plugin().get());
            if (!Strings.empty((String)this.textField.getText())) {
                kartagoclientexe = kartagoclientexe + " xy=" + this.textField.getText();
            }
            rt.exec(kartagoclientexe);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public String getValue() {
        return this.textField.getText();
    }

    @Override
    public void setValue(String newValue) {
        this.textField.setText(newValue);
    }

    @Override
    public void setBinding(final StateBinder.Binding binding) {
        final TextFieldPanel panel = this;
        this.textField.setInputVerifier(new InputVerifier(){

            @Override
            public boolean verify(JComponent input) {
                if (!Strings.empty((String)((String)TextFieldPanel.this.fieldValue.regularExpression().get())) && !Strings.empty((String)((JTextComponent)input).getText())) {
                    try {
                        new RegexPatternFormatter((String)TextFieldPanel.this.fieldValue.regularExpression().get()).stringToValue(((JTextComponent)input).getText());
                    }
                    catch (ParseException e) {
                        TextFieldPanel.this.dialogs.showMessageDialog(panel, i18n.text(CaseResources.regular_expression_does_not_validate, new Object[0]), "");
                        return false;
                    }
                }
                binding.updateProperty(((JTextComponent)input).getText());
                return true;
            }
        });
    }

    @Override
    protected String componentName() {
        StringBuilder componentName = new StringBuilder("<html>");
        componentName.append(this.title());
        if (!Strings.empty((String)((String)this.fieldValue.hint().get()))) {
            componentName.append(" <font color='#778899'>(").append((String)this.fieldValue.hint().get()).append(")</font>");
        }
        if (this.mandatory()) {
            componentName.append(" <font color='red'>*</font>");
        }
        componentName.append("</html>");
        return componentName.toString();
    }
}

