/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.workspace.cases.general.forms;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JFormattedTextField;
import javax.swing.text.DefaultFormatterFactory;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.calendar.DatePickerFormatter;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.util.DateFunctions;
import se.streamsource.streamflow.api.workspace.cases.general.FieldSubmissionDTO;
import se.streamsource.streamflow.client.ui.workspace.WorkspaceResources;
import se.streamsource.streamflow.client.ui.workspace.cases.general.forms.AbstractFieldPanel;
import se.streamsource.streamflow.client.util.StateBinder;
import se.streamsource.streamflow.client.util.dialog.DialogService;
import se.streamsource.streamflow.client.util.i18n;

public class DatePanel
extends AbstractFieldPanel {
    @Service
    DialogService dialogs;
    private JXDatePicker datePicker;

    public DatePanel(@Uses FieldSubmissionDTO field) {
        super(field);
        this.setLayout(new BorderLayout());
        this.datePicker = new JXDatePicker();
        final DateFormat dateFormat = DateFormat.getDateInstance(3);
        this.datePicker.getEditor().setFormatterFactory(new DefaultFormatterFactory((JFormattedTextField.AbstractFormatter)new DatePickerFormatter(new DateFormat[]{dateFormat}){

            public Object stringToValue(String text) throws ParseException {
                Object result;
                try {
                    result = super.stringToValue(text);
                }
                catch (ParseException pe) {
                    DatePanel.this.dialogs.showMessageDialog(DatePanel.this, i18n.text(WorkspaceResources.wrong_format_msg, new Object[0]) + " " + ((SimpleDateFormat)dateFormat).toPattern(), i18n.text(WorkspaceResources.wrong_format_title, new Object[0]));
                    throw pe;
                }
                return result;
            }
        }));
        this.add((Component)this.datePicker, "West");
    }

    @Override
    public String getValue() {
        Date date = this.datePicker.getDate();
        return date == null ? "" : DateFunctions.toUtcString((Date)date);
    }

    @Override
    public void setValue(String newValue) {
        if (!newValue.isEmpty()) {
            this.datePicker.setDate(DateFunctions.fromString((String)newValue));
        }
    }

    @Override
    public void setBinding(final StateBinder.Binding binding) {
        this.datePicker.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if ("date".equals(e.getPropertyName())) {
                    binding.updateProperty(DatePanel.this.getValue());
                }
            }
        });
    }
}

