/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.workspace.cases.general.forms;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import org.qi4j.api.injection.scope.Uses;
import se.streamsource.streamflow.api.administration.form.CheckboxesFieldValue;
import se.streamsource.streamflow.api.workspace.cases.general.FieldSubmissionDTO;
import se.streamsource.streamflow.client.ui.workspace.cases.general.forms.AbstractFieldPanel;
import se.streamsource.streamflow.client.util.StateBinder;
import se.streamsource.streamflow.util.MultiFieldHelper;

public class CheckboxesPanel
extends AbstractFieldPanel {
    Map<String, JCheckBox> checkBoxMap;

    public CheckboxesPanel(@Uses FieldSubmissionDTO field, @Uses CheckboxesFieldValue fieldValue) {
        super(field);
        JPanel panel = new JPanel(new BorderLayout());
        FormLayout formLayout = new FormLayout("200dlu", "");
        DefaultFormBuilder formBuilder = new DefaultFormBuilder(formLayout, panel);
        this.checkBoxMap = new HashMap<String, JCheckBox>();
        for (String element : (List)fieldValue.values().get()) {
            JCheckBox checkBox = new JCheckBox(element);
            this.checkBoxMap.put(element, checkBox);
            formBuilder.append((Component)checkBox);
            formBuilder.nextLine();
        }
        this.add((Component)panel, "West");
    }

    @Override
    public void setValue(String newValue) {
        if (newValue == null || newValue.equals("")) {
            return;
        }
        for (String box : MultiFieldHelper.options((String)newValue)) {
            this.checkBoxMap.get(box).setSelected(true);
        }
    }

    @Override
    public String getValue() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (JCheckBox checkBox : this.checkBoxMap.values()) {
            String text;
            if (!checkBox.isSelected()) continue;
            if (!first) {
                sb.append(", ");
            }
            if ((text = checkBox.getText()).contains(",")) {
                sb.append("[").append(text).append("]");
            } else {
                sb.append(text);
            }
            first = false;
        }
        return sb.toString();
    }

    @Override
    public void setBinding(final StateBinder.Binding binding) {
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                binding.updateProperty(CheckboxesPanel.this.getValue());
            }
        };
        for (JCheckBox box : this.checkBoxMap.values()) {
            box.addActionListener(listener);
        }
    }
}

