/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.workspace.cases.general;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.swing.EventComboBoxModel;
import java.util.Collection;
import java.util.Date;
import java.util.Observable;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.specification.Specification;
import org.qi4j.api.structure.Module;
import org.qi4j.api.util.DateFunctions;
import org.qi4j.api.util.Iterables;
import org.qi4j.api.value.ValueComposite;
import org.restlet.data.Form;
import org.restlet.resource.ResourceException;
import se.streamsource.dci.restlet.client.CommandQueryClient;
import se.streamsource.dci.value.EntityValue;
import se.streamsource.dci.value.ResourceValue;
import se.streamsource.dci.value.link.LinkValue;
import se.streamsource.dci.value.link.Links;
import se.streamsource.dci.value.link.LinksValue;
import se.streamsource.streamflow.api.administration.priority.PriorityValue;
import se.streamsource.streamflow.api.workspace.cases.CaseStates;
import se.streamsource.streamflow.api.workspace.cases.general.CaseGeneralDTO;
import se.streamsource.streamflow.client.OperationException;
import se.streamsource.streamflow.client.ui.workspace.WorkspaceResources;
import se.streamsource.streamflow.client.ui.workspace.cases.general.CaseLabelsModel;
import se.streamsource.streamflow.client.ui.workspace.cases.general.forms.PossibleFormsModel;
import se.streamsource.streamflow.client.ui.workspace.cases.note.CaseNoteModel;
import se.streamsource.streamflow.client.util.EventListSynch;
import se.streamsource.streamflow.client.util.Refreshable;

public class CaseGeneralModel
extends Observable
implements Refreshable {
    @Structure
    private Module module;
    private CommandQueryClient client;
    private CaseGeneralDTO general;
    private ResourceValue resourceValue;

    public CaseGeneralModel(@Uses CommandQueryClient client) {
        this.client = client;
    }

    public CaseGeneralDTO getGeneral() {
        if (this.general == null) {
            this.module.valueBuilderFactory().newValue(CaseGeneralDTO.class);
        }
        return this.general;
    }

    public void changeDescription(String newDescription) {
        if (newDescription.equals(this.general.description().get())) {
            return;
        }
        this.general.description().set((Object)newDescription);
        Form form = new Form();
        form.set("description", newDescription);
        this.client.postCommand("changedescription", (Object)form);
    }

    public void changeDueOn(Date newDueOn) {
        if (newDueOn.equals(this.general.dueOn().get())) {
            return;
        }
        Form form = new Form();
        form.set("date", DateFunctions.toUtcString((Date)newDueOn));
        this.client.putCommand("changedueon", (Object)form.getWebRepresentation());
        this.general.dueOn().set((Object)newDueOn);
    }

    public EventList<LinkValue> getPossibleCaseTypes() {
        try {
            BasicEventList list = new BasicEventList();
            LinksValue listValue = (LinksValue)this.client.query("possiblecasetypes", LinksValue.class);
            list.addAll((Collection)listValue.links().get());
            return list;
        }
        catch (ResourceException e) {
            throw new OperationException(WorkspaceResources.could_not_refresh, (Throwable)e);
        }
    }

    @Override
    public void refresh() {
        this.resourceValue = this.client.query();
        this.general = (CaseGeneralDTO)((ValueComposite)this.resourceValue.index().get()).buildWith().prototype();
        this.setChanged();
        this.notifyObservers(this.resourceValue);
    }

    public void changeCaseType(LinkValue selected) {
        this.client.postLink(selected);
    }

    public void removeCaseType() {
        this.client.postCommand("casetype", this.module.valueBuilderFactory().newValue(EntityValue.class));
    }

    public boolean getCommandEnabled(String commandName) {
        return Iterables.matchesAny((Specification)Links.withRel((String)commandName), (Iterable)((Iterable)this.resourceValue.commands().get()));
    }

    public CaseStates getCaseStatus() {
        return (CaseStates)this.general.status().get();
    }

    public CaseLabelsModel newLabelsModel() {
        return (CaseLabelsModel)this.module.objectBuilderFactory().newObjectBuilder(CaseLabelsModel.class).use(new Object[]{this.client.getSubClient("labels")}).newInstance();
    }

    public PossibleFormsModel newPossibleFormsModel() {
        return (PossibleFormsModel)this.module.objectBuilderFactory().newObjectBuilder(PossibleFormsModel.class).use(new Object[]{this.client.getClient("../possibleforms/")}).newInstance();
    }

    public CaseNoteModel newCaseNoteModel() {
        return (CaseNoteModel)this.module.objectBuilderFactory().newObjectBuilder(CaseNoteModel.class).use(new Object[]{this.client.getClient("../note/")}).newInstance();
    }

    public EventComboBoxModel<PriorityValue> getCasePriorities() {
        try {
            BasicEventList list = new BasicEventList();
            LinksValue listValue = (LinksValue)this.client.query("priorities", LinksValue.class);
            EventListSynch.synchronize((Collection)listValue.links().get(), list);
            return new EventComboBoxModel((EventList)list);
        }
        catch (ResourceException e) {
            throw new OperationException(WorkspaceResources.could_not_refresh, (Throwable)e);
        }
    }

    public void changePriority(String id) {
        Form form = new Form();
        form.set("id", "-1".equals(id) ? "" : id);
        this.client.postCommand("changepriority", (Object)form);
    }
}

