/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.workspace.cases.forms;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.ActionMap;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.Task;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.qi4j.api.entity.EntityReference;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.specification.Specification;
import org.qi4j.api.structure.Module;
import org.qi4j.api.util.DateFunctions;
import se.streamsource.streamflow.api.administration.form.AttachmentFieldValue;
import se.streamsource.streamflow.api.administration.form.CheckboxesFieldValue;
import se.streamsource.streamflow.api.administration.form.DateFieldValue;
import se.streamsource.streamflow.api.administration.form.GeoLocationFieldValue;
import se.streamsource.streamflow.api.administration.form.ListBoxFieldValue;
import se.streamsource.streamflow.api.administration.form.TextAreaFieldValue;
import se.streamsource.streamflow.api.workspace.cases.form.AttachmentFieldSubmission;
import se.streamsource.streamflow.api.workspace.cases.form.FieldDTO;
import se.streamsource.streamflow.api.workspace.cases.form.SubmittedFormDTO;
import se.streamsource.streamflow.api.workspace.cases.form.SubmittedPageDTO;
import se.streamsource.streamflow.api.workspace.cases.general.FormSignatureDTO;
import se.streamsource.streamflow.api.workspace.cases.general.SecondSigneeInfoValue;
import se.streamsource.streamflow.client.ui.DateFormats;
import se.streamsource.streamflow.client.ui.workspace.WorkspaceResources;
import se.streamsource.streamflow.client.ui.workspace.cases.forms.CaseSubmittedFormModel;
import se.streamsource.streamflow.client.util.CommandTask;
import se.streamsource.streamflow.client.util.OpenAttachmentTask;
import se.streamsource.streamflow.client.util.RefreshWhenShowing;
import se.streamsource.streamflow.client.util.Refreshable;
import se.streamsource.streamflow.client.util.StreamflowButton;
import se.streamsource.streamflow.client.util.StreamflowSelectableLabel;
import se.streamsource.streamflow.client.util.dialog.DialogService;
import se.streamsource.streamflow.client.util.i18n;
import se.streamsource.streamflow.infrastructure.event.domain.TransactionDomainEvents;
import se.streamsource.streamflow.infrastructure.event.domain.source.TransactionListener;
import se.streamsource.streamflow.infrastructure.event.domain.source.helper.Events;
import se.streamsource.streamflow.util.Strings;

public class CaseSubmittedFormView
extends JScrollPane
implements TransactionListener,
Refreshable {
    @Service
    DialogService dialogs;
    @Structure
    Module module;
    @Service
    ApplicationContext context;
    private JPanel panel;
    private CaseSubmittedFormModel model;
    private Map<StreamflowButton, AttachmentFieldSubmission> buttons = new HashMap<StreamflowButton, AttachmentFieldSubmission>();
    private SimpleDateFormat formatter = new SimpleDateFormat(i18n.text(WorkspaceResources.date_format, new Object[0]));

    public CaseSubmittedFormView(@Service ApplicationContext context, @Uses CaseSubmittedFormModel model) {
        this.panel = new JPanel();
        this.panel.setLayout(new BoxLayout(this.panel, 1));
        this.setViewportView(this.panel);
        this.getViewport().setScrollMode(0);
        this.setMinimumSize(new Dimension(150, 0));
        this.model = model;
        this.setActionMap((ActionMap)context.getActionMap((Object)this));
        new RefreshWhenShowing(this, this);
    }

    @Override
    public void refresh() {
        this.model.refresh();
        this.panel().removeAll();
        DefaultFormBuilder builder = this.builder(this.panel());
        SubmittedFormDTO form = this.model.getForm();
        StreamflowSelectableLabel title = new StreamflowSelectableLabel((String)form.form().get() + " (" + (String)form.submitter().get() + ", " + DateTimeFormat.forPattern((String)i18n.text(WorkspaceResources.date_time_format, new Object[0])).print((ReadableInstant)new DateTime(form.submissionDate().get())) + "):");
        builder.append((Component)title);
        builder.nextLine();
        if (!((List)form.signatures().get()).isEmpty()) {
            builder.appendSeparator(i18n.text(WorkspaceResources.signatures, new Object[0]));
            for (FormSignatureDTO signatureDTO : (List)form.signatures().get()) {
                builder.append((Component)new StreamflowSelectableLabel((String)signatureDTO.name().get() + ": " + (String)signatureDTO.signerName().get() + "(" + signatureDTO.signerId() + ")"));
                builder.nextLine();
            }
        }
        if (form.secondSignee().get() != null) {
            JPanel panel;
            SecondSigneeInfoValue secondSignee = (SecondSigneeInfoValue)form.secondSignee().get();
            builder.appendSeparator(i18n.text(WorkspaceResources.second_signee, new Object[0]));
            if (!Strings.empty((String)((String)secondSignee.name().get()))) {
                builder.append((Component)new StreamflowSelectableLabel(i18n.text(WorkspaceResources.name_label, new Object[0]) + ": " + (String)secondSignee.name().get()));
                builder.nextLine();
            }
            if (!Strings.empty((String)((String)secondSignee.phonenumber().get()))) {
                builder.append((Component)new StreamflowSelectableLabel(i18n.text(WorkspaceResources.phone_label, new Object[0]) + ": " + (String)secondSignee.phonenumber().get()));
                builder.nextLine();
            }
            if (!Strings.empty((String)((String)secondSignee.socialsecuritynumber().get()))) {
                builder.append((Component)new StreamflowSelectableLabel(i18n.text(WorkspaceResources.contact_id_label, new Object[0]) + ": " + (String)secondSignee.socialsecuritynumber().get()));
                builder.nextLine();
            }
            if (!Strings.empty((String)((String)secondSignee.email().get()))) {
                builder.append((Component)new StreamflowSelectableLabel(i18n.text(WorkspaceResources.email_label, new Object[0]) + ": " + (String)secondSignee.email().get()));
                builder.nextLine();
            }
            if (!Strings.empty((String)((String)secondSignee.secondsigneetaskref().get()))) {
                panel = new JPanel(new FlowLayout(0));
                StreamflowButton button = new StreamflowButton(this.context.getActionMap((Object)this).get((Object)"resenddoublesignemail"));
                DateTime date = (DateTime)secondSignee.lastReminderSent().get();
                JLabel lastReminderSent = new JLabel(i18n.text(WorkspaceResources.last_reminder_sent, new Object[0]) + ": " + (date != null ? DateFormats.getProgressiveDateTimeValue(date, Locale.getDefault()) : ""));
                panel.add(button);
                panel.add(lastReminderSent);
                builder.append((Component)panel);
                builder.nextLine();
            }
            if (!Strings.empty((String)((String)secondSignee.secondDraftUrl().get()))) {
                panel = new JPanel(new FlowLayout(0));
                panel.add(new JLabel(i18n.text(WorkspaceResources.second_draft_url, new Object[0]) + ": "));
                panel.add(new StreamflowSelectableLabel((String)secondSignee.secondDraftUrl().get()));
                builder.append((Component)panel);
                builder.nextLine();
            }
        }
        for (SubmittedPageDTO page : (List)form.pages().get()) {
            builder.appendSeparator((String)page.name().get());
            for (FieldDTO field : (List)page.fields().get()) {
                JLabel label = new JLabel((String)field.field().get() + (((String)field.field().get()).trim().endsWith(":") ? "" : ":"), 2);
                label.setForeground(Color.gray);
                JComponent component = this.getComponent((String)field.value().get(), (String)field.fieldType().get());
                builder.append((Component)label);
                builder.nextLine();
                builder.append((Component)component);
                builder.nextLine();
            }
        }
    }

    @Action(block=Task.BlockingScope.APPLICATION)
    public Task open(ActionEvent event) {
        return this.openAttachment(event);
    }

    @Action
    public Task resenddoublesignemail() {
        return new CommandTask(){

            @Override
            protected void command() throws Exception {
                CaseSubmittedFormView.this.model.resenddoublesignemail();
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     */
    public JComponent getComponent(String fieldValue, String fieldType) {
        StreamflowSelectableLabel selectableLabel = new StreamflowSelectableLabel();
        selectableLabel.setContentType("text/html");
        JLabel fontSource = new JLabel();
        final Desktop desktop = Desktop.getDesktop();
        selectableLabel.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent hle) {
                if (HyperlinkEvent.EventType.ACTIVATED.equals(hle.getEventType())) {
                    try {
                        try {
                            desktop.browse(new URI(hle.getURL().toString()));
                        }
                        catch (URISyntaxException ex) {
                            System.out.println(ex.getMessage());
                        }
                    }
                    catch (IOException ex) {
                        System.out.println(ex.getMessage());
                    }
                }
            }
        });
        String text = "<html> <font size='3' face='" + fontSource.getFont().getFontName() + "'>";
        if (fieldType.equals(DateFieldValue.class.getName())) {
            text = text + (Strings.empty((String)fieldValue) ? " " : this.formatter.format(DateFunctions.fromString((String)fieldValue)));
        } else if (fieldType.equals(TextAreaFieldValue.class.getName())) {
            text = text + fieldValue.replace("\n", "<br/>");
        } else if (fieldType.equals(AttachmentFieldValue.class.getName())) {
            if (!Strings.empty((String)fieldValue)) {
                AttachmentFieldSubmission attachment = (AttachmentFieldSubmission)this.module.valueBuilderFactory().newValueFromJSON(AttachmentFieldSubmission.class, fieldValue);
                JPanel panel = new JPanel(new FlowLayout(0));
                StreamflowSelectableLabel onPanel = new StreamflowSelectableLabel();
                onPanel.setContentType("text/html");
                onPanel.setText(text + (String)attachment.name().get() + "</font></html>");
                panel.add(onPanel);
                StreamflowButton button = new StreamflowButton(this.context.getActionMap((Object)this).get((Object)"open"));
                this.buttons.put(button, attachment);
                panel.add(button);
                return panel;
            }
            text = text + fieldValue;
        } else if (fieldType.equals(CheckboxesFieldValue.class.getName()) || fieldType.equals(ListBoxFieldValue.class.getName())) {
            fieldValue = fieldValue.replaceAll("\\[", "\"");
            fieldValue = fieldValue.replaceAll("\\]", "\"");
            text = text + fieldValue;
        } else {
            text = fieldType.equals(GeoLocationFieldValue.class.getName()) ? text + fieldValue : text + fieldValue;
        }
        text = text + "</font></html>";
        selectableLabel.setText(text);
        return selectableLabel;
    }

    public Task openAttachment(ActionEvent event) {
        AttachmentFieldSubmission selectedDocument = this.buttons.get(event.getSource());
        return new OpenAttachmentTask((String)selectedDocument.name().get(), ((EntityReference)selectedDocument.attachment().get()).identity(), this, this.model, this.dialogs);
    }

    public void notifyTransactions(Iterable<TransactionDomainEvents> transactions) {
        if (Events.matches((Specification)Events.withNames((String[])new String[]{"submittedForm", "updatedLastReminderSent"}), transactions)) {
            this.refresh();
        }
    }

    protected JPanel panel() {
        return this.panel;
    }

    protected DefaultFormBuilder builder(JPanel aPanel) {
        FormLayout formLayout = new FormLayout("150dlu:grow", "");
        return new DefaultFormBuilder(formLayout, aPanel);
    }

    public void read() {
        new CommandTask(){

            @Override
            protected void command() throws Exception {
                CaseSubmittedFormView.this.model.read();
            }
        }.execute();
    }
}

