/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.workspace.cases.conversations;

import ca.odell.glazedlists.gui.TableFormat;
import ca.odell.glazedlists.swing.EventJXTableModel;
import ca.odell.glazedlists.swing.EventTableModel;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.KeyboardFocusManager;
import java.awt.font.TextAttribute;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import javax.swing.ActionMap;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationAction;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.Task;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import org.jdesktop.swingx.renderer.DefaultTableRenderer;
import org.jdesktop.swingx.renderer.StringValue;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.specification.Specification;
import org.qi4j.api.structure.Module;
import se.streamsource.streamflow.api.workspace.cases.conversation.MessageDTO;
import se.streamsource.streamflow.client.Icons;
import se.streamsource.streamflow.client.MacOsUIWrapper;
import se.streamsource.streamflow.client.StreamflowResources;
import se.streamsource.streamflow.client.ui.DateFormats;
import se.streamsource.streamflow.client.ui.workspace.WorkspaceResources;
import se.streamsource.streamflow.client.ui.workspace.cases.conversations.MessageDraftView;
import se.streamsource.streamflow.client.ui.workspace.cases.conversations.MessageView;
import se.streamsource.streamflow.client.ui.workspace.cases.conversations.MessagesModel;
import se.streamsource.streamflow.client.util.CommandTask;
import se.streamsource.streamflow.client.util.RefreshComponents;
import se.streamsource.streamflow.client.util.RefreshWhenShowing;
import se.streamsource.streamflow.client.util.StreamflowButton;
import se.streamsource.streamflow.client.util.dialog.ConfirmationDialog;
import se.streamsource.streamflow.client.util.dialog.DialogService;
import se.streamsource.streamflow.client.util.i18n;
import se.streamsource.streamflow.infrastructure.event.domain.TransactionDomainEvents;
import se.streamsource.streamflow.infrastructure.event.domain.source.TransactionListener;
import se.streamsource.streamflow.infrastructure.event.domain.source.helper.Events;

public class MessagesView
extends JPanel
implements TransactionListener {
    private static final long serialVersionUID = -4508473068931275932L;
    @Structure
    Module module;
    @Service
    DialogService dialogs;
    private MessagesModel model;
    private JXTable messageTable;
    private JPanel detailMessagePanel;
    private JPanel sendPanel = new JPanel(new BorderLayout());
    private JPanel messageViewPanel = new JPanel(new BorderLayout());
    private MessageView messageView;
    private MessageDraftView messageDraftView;
    private StreamflowButton writeMessage;
    private javax.swing.Action createMessage;

    public MessagesView(@Service ApplicationContext context, @Uses MessagesModel model) {
        this.setActionMap((ActionMap)context.getActionMap((Object)this));
        MacOsUIWrapper.convertAccelerators(this.getActionMap());
        this.setLayout(new BorderLayout());
        this.model = model;
        ApplicationAction closeMessageDetailsAction = (ApplicationAction)this.getActionMap().get("closeMessageDetails");
        javax.swing.Action closeMessageDetails = context.getActionMap().get((Object)"closeMessageDetails");
        closeMessageDetails.putValue("proxy", closeMessageDetailsAction);
        ApplicationAction createMessageAction = (ApplicationAction)this.getActionMap().get("createMessage");
        this.createMessage = context.getActionMap().get((Object)"createMessage");
        this.createMessage.putValue("proxy", createMessageAction);
        ApplicationAction cancelNewMessageAction = (ApplicationAction)this.getActionMap().get("cancelNewMessage");
        javax.swing.Action cancelNewMessage = context.getActionMap().get((Object)"cancelNewMessage");
        cancelNewMessage.putValue("proxy", cancelNewMessageAction);
        this.messageTable = new JXTable((TableModel)new EventJXTableModel(model.messages(), (TableFormat)new TableFormat<MessageDTO>(){
            String[] columnNames = new String[]{"", i18n.text(WorkspaceResources.sender_column_header, new Object[0]), i18n.text(WorkspaceResources.message_column_header, new Object[0]), i18n.text(WorkspaceResources.created_column_header, new Object[0]), ""};

            public int getColumnCount() {
                return this.columnNames.length;
            }

            public String getColumnName(int i) {
                return this.columnNames[i];
            }

            public Object getColumnValue(MessageDTO o, int i) {
                switch (i) {
                    case 0: {
                        return o.hasAttachments().get();
                    }
                    case 1: {
                        return o.sender().get();
                    }
                    case 2: {
                        return o.text().get();
                    }
                    case 3: {
                        return o.createdOn().get();
                    }
                    case 4: {
                        return o.id().get();
                    }
                }
                return null;
            }
        })){

            public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
                Component c = super.prepareRenderer(renderer, row, column);
                EventTableModel model = (EventTableModel)this.getModel();
                if (model.getElementAt(row) instanceof MessageDTO) {
                    Map<TextAttribute, ?> attributes = c.getFont().getAttributes();
                    if (((Boolean)((MessageDTO)model.getElementAt(row)).unread().get()).booleanValue()) {
                        attributes.put(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
                    }
                    c.setFont(new Font(attributes));
                }
                return c;
            }
        };
        this.messageTable.getColumnExt(this.messageTable.getColumnCount() - 1).setVisible(false);
        this.messageTable.setSelectionMode(0);
        this.messageTable.setFocusTraversalKeys(0, KeyboardFocusManager.getCurrentKeyboardFocusManager().getDefaultFocusTraversalKeys(0));
        this.messageTable.setFocusTraversalKeys(1, KeyboardFocusManager.getCurrentKeyboardFocusManager().getDefaultFocusTraversalKeys(1));
        this.messageTable.getColumn(3).setCellRenderer((TableCellRenderer)new DefaultTableRenderer(new StringValue(){
            private static final long serialVersionUID = -6677363096055906298L;

            public String getString(Object value) {
                return DateFormats.getProgressiveDateTimeValue((Date)value, Locale.getDefault());
            }
        }));
        this.messageTable.getColumn(0).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                ImageIcon icon = i18n.icon(Icons.attachments, 11);
                JLabel iconLabel = (Boolean)value != false ? new JLabel(icon) : new JLabel(" ");
                iconLabel.setOpaque(true);
                if (isSelected) {
                    iconLabel.setBackground(MessagesView.this.messageTable.getSelectionBackground());
                }
                return iconLabel;
            }
        });
        ListSelectionModel selectionModel = this.messageTable.getSelectionModel();
        selectionModel.addListSelectionListener(new MessageListSelectionHandler());
        this.messageTable.addHighlighter(HighlighterFactory.createAlternateStriping());
        this.messageTable.getColumn(0).setPreferredWidth(20);
        this.messageTable.getColumn(0).setWidth(20);
        this.messageTable.getColumn(0).setMaxWidth(20);
        this.messageTable.getColumn(0).setResizable(false);
        this.messageTable.getColumn(1).setPreferredWidth(250);
        this.messageTable.getColumn(1).setMaxWidth(250);
        this.messageTable.getColumn(2).setPreferredWidth(300);
        this.messageTable.getColumn(3).setPreferredWidth(60);
        this.messageTable.getColumn(3).setMaxWidth(100);
        this.detailMessagePanel = new JPanel(new CardLayout());
        JPanel createPanel = new JPanel(new FlowLayout(2));
        javax.swing.Action writeMessageAction = this.getActionMap().get("writeMessage");
        this.writeMessage = new StreamflowButton(writeMessageAction);
        this.writeMessage.registerKeyboardAction(writeMessageAction, (KeyStroke)writeMessageAction.getValue("AcceleratorKey"), 2);
        createPanel.add(this.writeMessage);
        this.detailMessagePanel.add((Component)createPanel, "INITIAL");
        this.detailMessagePanel.add((Component)this.sendPanel, "NEW_MESSAGE");
        this.detailMessagePanel.add((Component)this.messageViewPanel, "SHOW_MESSAGE");
        ((CardLayout)this.detailMessagePanel.getLayout()).show(this.detailMessagePanel, "INITIAL");
        JScrollPane scrollMessages = new JScrollPane((Component)this.messageTable);
        this.add((Component)scrollMessages, "Center");
        this.add((Component)this.detailMessagePanel, "South");
        model.addObserver(new RefreshComponents().visibleOn("createmessagefromdraft", this.writeMessage));
        new RefreshWhenShowing(this, model);
    }

    @Action
    public void writeMessage() {
        this.sendPanel.removeAll();
        this.messageDraftView = (MessageDraftView)this.module.objectBuilderFactory().newObjectBuilder(MessageDraftView.class).use(new Object[]{this.model.newMessageDraftModel()}).newInstance();
        this.sendPanel.add((Component)this.messageDraftView, "Center");
        ((CardLayout)this.detailMessagePanel.getLayout()).show(this.detailMessagePanel, "NEW_MESSAGE");
        this.messageDraftView.requestFocusInWindow();
    }

    @Action
    public Task createMessage() {
        ConfirmationDialog dialog = (ConfirmationDialog)this.module.objectBuilderFactory().newObject(ConfirmationDialog.class);
        this.dialogs.showOkCancelHelpDialog(this, dialog, i18n.text(StreamflowResources.confirmation, new Object[0]));
        if (dialog.isConfirmed()) {
            this.sendPanel.removeAll();
            ((CardLayout)this.detailMessagePanel.getLayout()).show(this.detailMessagePanel, "INITIAL");
            return new CommandTask(){

                @Override
                public void command() throws Exception {
                    MessagesView.this.model.createMessageFromDraft();
                }
            };
        }
        return null;
    }

    @Action
    public void cancelNewMessage() {
        this.sendPanel.removeAll();
        ((CardLayout)this.detailMessagePanel.getLayout()).show(this.detailMessagePanel, "INITIAL");
    }

    @Action
    public void closeMessageDetails() {
        this.messageTable.getSelectionModel().clearSelection();
        this.messageViewPanel.removeAll();
        ((CardLayout)this.detailMessagePanel.getLayout()).show(this.detailMessagePanel, "INITIAL");
    }

    public void notifyTransactions(Iterable<TransactionDomainEvents> transactions) {
        if (Events.matches((Specification)Events.withNames((String[])new String[]{"createdMessage", "createdMessageFromDraft", "setUnread"}), transactions) || Events.matches((Specification)Events.withUsecases((String[])new String[]{"resolve", "reopen"}), transactions)) {
            this.model.refresh();
        }
    }

    class MessageListSelectionHandler
    implements ListSelectionListener {
        MessageListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int index;
            if (!e.getValueIsAdjusting() && (index = MessagesView.this.messageTable.getSelectedRow()) >= 0) {
                Object selectedValue = MessagesView.this.messageTable.getModel().getValueAt(MessagesView.this.messageTable.convertRowIndexToModel(index), MessagesView.this.messageTable.getColumnCount());
                String href = (String)selectedValue;
                ((CardLayout)MessagesView.this.detailMessagePanel.getLayout()).show(MessagesView.this.detailMessagePanel, "INITIAL");
                MessagesView.this.messageViewPanel.removeAll();
                MessagesView.this.messageView = (MessageView)MessagesView.this.module.objectBuilderFactory().newObjectBuilder(MessageView.class).use(new Object[]{MessagesView.this.model.newMessageModel(href)}).newInstance();
                EventTableModel model = (EventTableModel)MessagesView.this.messageTable.getModel();
                MessageDTO messageDTO = (MessageDTO)model.getElementAt(index);
                if (((Boolean)messageDTO.unread().get()).booleanValue()) {
                    MessagesView.this.messageView.read();
                }
                MessagesView.this.messageViewPanel.add((Component)MessagesView.this.messageView, "Center");
                ((CardLayout)MessagesView.this.detailMessagePanel.getLayout()).show(MessagesView.this.detailMessagePanel, "SHOW_MESSAGE");
            }
        }
    }
}

