/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.workspace.cases.conversations;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import java.util.Collection;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.specification.Specification;
import org.qi4j.api.structure.Module;
import se.streamsource.dci.restlet.client.CommandQueryClient;
import se.streamsource.dci.value.link.LinksValue;
import se.streamsource.streamflow.api.workspace.cases.conversation.MessageDTO;
import se.streamsource.streamflow.client.ResourceModel;
import se.streamsource.streamflow.client.ui.workspace.cases.conversations.MessageDraftModel;
import se.streamsource.streamflow.client.ui.workspace.cases.conversations.MessageModel;
import se.streamsource.streamflow.client.util.EventListSynch;
import se.streamsource.streamflow.client.util.Refreshable;
import se.streamsource.streamflow.infrastructure.event.domain.TransactionDomainEvents;
import se.streamsource.streamflow.infrastructure.event.domain.source.TransactionListener;
import se.streamsource.streamflow.infrastructure.event.domain.source.helper.Events;

public class MessagesModel
extends ResourceModel<LinksValue>
implements Refreshable,
TransactionListener {
    @Uses
    CommandQueryClient client;
    @Structure
    Module module;
    BasicEventList<MessageDTO> messages = new BasicEventList();

    @Override
    public void refresh() {
        super.refresh();
        EventListSynch.synchronize((Collection)((LinksValue)this.getIndex()).links().get(), this.messages);
    }

    public EventList<MessageDTO> messages() {
        return this.messages;
    }

    public void createMessageFromDraft() {
        this.client.postCommand("createmessagefromdraft");
    }

    public void notifyTransactions(Iterable<TransactionDomainEvents> transactions) {
        if (Events.matches((Specification)Events.onEntities((String[])new String[]{this.client.getReference().getParentRef().getLastSegment()}), transactions)) {
            this.refresh();
        }
    }

    public MessageModel newMessageModel(String href) {
        return (MessageModel)this.module.objectBuilderFactory().newObjectBuilder(MessageModel.class).use(new Object[]{this.client.getSubClient(href)}).newInstance();
    }

    public MessageDraftModel newMessageDraftModel() {
        return (MessageDraftModel)this.module.objectBuilderFactory().newObjectBuilder(MessageDraftModel.class).use(new Object[]{this.client.getSubClient("messagedraft")}).newInstance();
    }
}

