/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.workspace.cases.conversations;

import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.Task;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.specification.Specification;
import org.qi4j.api.structure.Module;
import se.streamsource.dci.value.link.LinkValue;
import se.streamsource.streamflow.client.ui.workspace.cases.CaseResources;
import se.streamsource.streamflow.client.ui.workspace.cases.conversations.ConversationParticipantsModel;
import se.streamsource.streamflow.client.ui.workspace.cases.conversations.CreateExternalMailUserDialog;
import se.streamsource.streamflow.client.ui.workspace.cases.general.RemovableLabel;
import se.streamsource.streamflow.client.util.CommandTask;
import se.streamsource.streamflow.client.util.RefreshComponents;
import se.streamsource.streamflow.client.util.RefreshWhenShowing;
import se.streamsource.streamflow.client.util.StreamflowButton;
import se.streamsource.streamflow.client.util.dialog.DialogService;
import se.streamsource.streamflow.client.util.dialog.SelectLinkDialog;
import se.streamsource.streamflow.client.util.i18n;
import se.streamsource.streamflow.infrastructure.event.domain.TransactionDomainEvents;
import se.streamsource.streamflow.infrastructure.event.domain.source.TransactionListener;
import se.streamsource.streamflow.infrastructure.event.domain.source.helper.Events;
import se.streamsource.streamflow.util.Strings;

public class ConversationParticipantsView
extends JPanel
implements ListEventListener,
TransactionListener {
    @Service
    DialogService dialogs;
    @Structure
    Module module;
    ConversationParticipantsModel model;
    private JPanel participants;
    private RefreshComponents removableLabelRefresher;

    public ConversationParticipantsView(@Service ApplicationContext context, @Uses ConversationParticipantsModel model) {
        super(new BorderLayout());
        this.setActionMap((ActionMap)context.getActionMap((Object)this));
        this.model = model;
        model.participants().addListEventListener((ListEventListener)this);
        this.participants = new JPanel(new FlowLayout(0));
        this.participants.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.add((Component)this.participants, "Center");
        javax.swing.Action addParticipantsAction = this.getActionMap().get("addParticipants");
        StreamflowButton addParticipants = new StreamflowButton(addParticipantsAction);
        addParticipants.registerKeyboardAction(addParticipantsAction, (KeyStroke)addParticipantsAction.getValue("AcceleratorKey"), 2);
        javax.swing.Action addExternalParticipantAction = this.getActionMap().get("addExternalParticipant");
        StreamflowButton addExternalParticipant = new StreamflowButton(addExternalParticipantAction);
        addExternalParticipant.registerKeyboardAction(addExternalParticipantAction, (KeyStroke)addExternalParticipantAction.getValue("AcceleratorKey"), 2);
        JPanel addParticipantButtons = new JPanel();
        addParticipantButtons.add(addParticipants);
        addParticipantButtons.add(addExternalParticipant);
        this.add((Component)addParticipantButtons, "East");
        model.addObserver(new RefreshComponents().enabledOn("addparticipant", addParticipants).enabledOn("addexternalparticipant", addExternalParticipant));
        this.removableLabelRefresher = new RefreshComponents().enabledOn("addparticipant", this.participants.getComponents());
        model.addObserver(this.removableLabelRefresher);
        new RefreshWhenShowing(this, model);
    }

    private void initComponents() {
        this.model.deleteObserver(this.removableLabelRefresher);
        this.participants.removeAll();
        for (int i = 0; i < this.model.participants().size(); ++i) {
            LinkValue link = (LinkValue)this.model.participants().get(i);
            RemovableLabel label = new RemovableLabel(link, null);
            label.getButton().addActionListener(this.getActionMap().get("removeParticipant"));
            this.participants.add(label);
        }
        this.participants.revalidate();
        this.participants.repaint();
        this.removableLabelRefresher = new RefreshComponents().enabledOn("addparticipant", this.participants.getComponents());
        this.model.addObserver(this.removableLabelRefresher);
    }

    public void listChanged(ListEvent listEvent) {
        this.initComponents();
    }

    @Action
    public Task addParticipants() {
        final SelectLinkDialog dialog = (SelectLinkDialog)this.module.objectBuilderFactory().newObjectBuilder(SelectLinkDialog.class).use(new Object[]{this.model.possibleParticipants()}).newInstance();
        dialog.setSelectionMode(2);
        this.dialogs.showOkCancelHelpDialog(this, dialog, i18n.text(CaseResources.choose_participant, new Object[0]));
        return new CommandTask(){

            @Override
            public void command() throws Exception {
                for (LinkValue participant : dialog.getSelectedLinks()) {
                    ConversationParticipantsView.this.model.addParticipant(participant);
                }
            }
        };
    }

    @Action
    public void addExternalParticipant() {
        final CreateExternalMailUserDialog dialog = (CreateExternalMailUserDialog)this.module.objectBuilderFactory().newObjectBuilder(CreateExternalMailUserDialog.class).newInstance();
        this.dialogs.showOkCancelHelpDialog(this, dialog, i18n.text(CaseResources.choose_external_participant, new Object[0]));
        if (!Strings.empty((String)dialog.email())) {
            new CommandTask(){

                @Override
                public void command() throws Exception {
                    ConversationParticipantsView.this.model.addExternalParticipant(dialog.email());
                }
            }.execute();
        }
    }

    @Action
    public Task removeParticipant(final ActionEvent e) {
        return new CommandTask(){

            @Override
            public void command() throws Exception {
                Component component = (Component)e.getSource();
                RemovableLabel label = (RemovableLabel)component.getParent();
                ConversationParticipantsView.this.model.removeParticipant(label.getRemoveLink());
            }
        };
    }

    public void notifyTransactions(Iterable<TransactionDomainEvents> transactions) {
        if (Events.matches((Specification)Events.withNames((String[])new String[]{"addedParticipant", "removedParticipant"}), transactions) || Events.matches((Specification)Events.withUsecases((String[])new String[]{"resolve", "reopen"}), transactions)) {
            this.model.refresh();
        }
    }
}

