/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.workspace.cases.conversations;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.TransactionList;
import java.util.Collection;
import java.util.Observable;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.value.ValueBuilder;
import org.qi4j.api.value.ValueBuilderFactory;
import org.restlet.resource.ResourceException;
import se.streamsource.dci.restlet.client.CommandQueryClient;
import se.streamsource.dci.value.ResourceValue;
import se.streamsource.dci.value.link.LinkValue;
import se.streamsource.dci.value.link.LinksValue;
import se.streamsource.streamflow.api.workspace.cases.conversation.ExternalEmailValue;
import se.streamsource.streamflow.client.OperationException;
import se.streamsource.streamflow.client.ui.workspace.WorkspaceResources;
import se.streamsource.streamflow.client.util.EventListSynch;
import se.streamsource.streamflow.client.util.Refreshable;

public class ConversationParticipantsModel
extends Observable
implements Refreshable {
    @Uses
    CommandQueryClient client;
    @Structure
    ValueBuilderFactory vbf;
    EventList<LinkValue> participants = new TransactionList((EventList)new BasicEventList());

    public EventList<LinkValue> participants() {
        return this.participants;
    }

    public EventList<LinkValue> possibleParticipants() {
        try {
            BasicEventList list = new BasicEventList();
            LinksValue listValue = (LinksValue)this.client.query("possibleparticipants", LinksValue.class);
            list.addAll((Collection)listValue.links().get());
            return list;
        }
        catch (ResourceException e) {
            throw new OperationException(WorkspaceResources.could_not_refresh, (Throwable)e);
        }
    }

    public void addParticipant(LinkValue participant) {
        this.client.postLink(participant);
    }

    public void addExternalParticipant(String emailAddress) {
        ValueBuilder builder = this.vbf.newValueBuilder(ExternalEmailValue.class);
        ((ExternalEmailValue)builder.prototype()).emailAddress().set((Object)emailAddress);
        this.client.postCommand("addexternalparticipant", builder.newInstance());
    }

    public void removeParticipant(LinkValue link) {
        this.client.getSubClient((String)link.id().get()).delete();
    }

    @Override
    public void refresh() {
        ResourceValue resource = this.client.query();
        LinksValue participants = (LinksValue)resource.index().get();
        EventListSynch.synchronize((Collection)participants.links().get(), this.participants);
        this.setChanged();
        this.notifyObservers(resource);
    }
}

