/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.workspace.cases.contacts;

import java.util.List;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.specification.Specification;
import org.qi4j.api.structure.Module;
import org.qi4j.api.util.Iterables;
import org.qi4j.api.value.ValueBuilder;
import org.restlet.data.Form;
import org.restlet.resource.ResourceException;
import se.streamsource.dci.restlet.client.CommandQueryClient;
import se.streamsource.dci.value.ResourceValue;
import se.streamsource.dci.value.link.Links;
import se.streamsource.streamflow.api.workspace.cases.contact.ContactAddressDTO;
import se.streamsource.streamflow.api.workspace.cases.contact.ContactDTO;
import se.streamsource.streamflow.api.workspace.cases.contact.ContactEmailDTO;
import se.streamsource.streamflow.api.workspace.cases.contact.ContactPhoneDTO;
import se.streamsource.streamflow.api.workspace.cases.contact.ContactPreference;
import se.streamsource.streamflow.api.workspace.cases.contact.ContactsDTO;
import se.streamsource.streamflow.api.workspace.cases.contact.StreetSearchDTO;
import se.streamsource.streamflow.api.workspace.cases.contact.StreetsDTO;

public class ContactModel {
    @Uses
    private ContactDTO contact;
    @Uses
    CommandQueryClient client;
    @Structure
    Module module;

    public ContactDTO getContact() {
        return this.contact;
    }

    public void setContact(ContactDTO contact) {
        this.contact = contact;
    }

    public ContactPhoneDTO getPhoneNumber() {
        return (ContactPhoneDTO)((List)this.contact.phoneNumbers().get()).get(0);
    }

    public ContactAddressDTO getAddress() {
        return (ContactAddressDTO)((List)this.contact.addresses().get()).get(0);
    }

    public ContactEmailDTO getEmailAddress() {
        return (ContactEmailDTO)((List)this.contact.emailAddresses().get()).get(0);
    }

    public void changeName(String newName) throws ResourceException {
        Form form = new Form();
        form.set("name", newName);
        this.client.putCommand("update", (Object)form.getWebRepresentation());
    }

    public void changeNote(String newNote) throws ResourceException {
        Form form = new Form();
        form.set("note", newNote);
        this.client.putCommand("update", (Object)form.getWebRepresentation());
    }

    public void changeContactId(String newId) throws ResourceException {
        Form form = new Form();
        form.set("contactId", newId);
        this.client.putCommand("update", (Object)form.getWebRepresentation());
    }

    public void changeCompany(String newCompany) throws ResourceException {
        Form form = new Form();
        form.set("company", newCompany);
        this.client.putCommand("update", (Object)form.getWebRepresentation());
    }

    public void changePhoneNumber(String newPhone) throws ResourceException {
        Form form = new Form();
        form.set("phone", newPhone);
        this.client.putCommand("update", (Object)form.getWebRepresentation());
    }

    public void changeAddress(String newAddress) throws ResourceException {
        Form form = new Form();
        form.set("address", newAddress);
        this.client.putCommand("update", (Object)form.getWebRepresentation());
    }

    public void changeZipCode(String newZipCode) {
        Form form = new Form();
        form.set("zipCode", newZipCode);
        this.client.putCommand("update", (Object)form.getWebRepresentation());
    }

    public void changeCity(String newCity) {
        Form form = new Form();
        form.set("city", newCity);
        this.client.putCommand("update", (Object)form.getWebRepresentation());
    }

    public void changeRegion(String newRegion) {
        Form form = new Form();
        form.set("region", newRegion);
        this.client.putCommand("update", (Object)form.getWebRepresentation());
    }

    public void changeCountry(String newCountry) {
        Form form = new Form();
        form.set("country", newCountry);
        this.client.putCommand("update", (Object)form.getWebRepresentation());
    }

    public void changeEmailAddress(String newEmailAddress) throws ResourceException {
        Form form = new Form();
        form.set("email", newEmailAddress);
        this.client.putCommand("update", (Object)form.getWebRepresentation());
    }

    public void changeAddressAndCity(String newAddress, String newCity) {
        Form form = new Form();
        form.set("address", newAddress);
        form.set("city", newCity);
        this.client.putCommand("update", (Object)form.getWebRepresentation());
    }

    public boolean isContactLookupEnabled() {
        ResourceValue resource = this.client.query();
        return Iterables.matchesAny((Specification)Links.withRel((String)"searchcontacts"), (Iterable)((Iterable)resource.queries().get()));
    }

    public void initMissingValues() {
    }

    public ContactsDTO searchContacts(ContactDTO query) throws ResourceException {
        return (ContactsDTO)this.client.query("searchcontacts", ContactsDTO.class, (Object)query);
    }

    public boolean isStreetLookupEnabled() {
        ResourceValue resource = this.client.query();
        return Iterables.matchesAny((Specification)Links.withRel((String)"searchstreets"), (Iterable)((Iterable)resource.queries().get()));
    }

    public StreetsDTO searchStreets(String query) throws ResourceException {
        ValueBuilder builder = this.module.valueBuilderFactory().newValueBuilder(StreetSearchDTO.class);
        ((StreetSearchDTO)builder.prototype()).address().set((Object)query);
        return (StreetsDTO)this.client.query("searchstreets", StreetsDTO.class, builder.newInstance());
    }

    public void changeContactPreference(ContactPreference preference) {
        Form form = new Form();
        if (preference == null) {
            form.set("contactpreference", "");
        } else {
            form.set("contactpreference", preference.name());
        }
        this.client.putCommand("update", (Object)form.getWebRepresentation());
    }
}

