/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.workspace.cases.caselog;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.TransactionList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Observable;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.specification.Specification;
import org.qi4j.api.structure.Module;
import org.qi4j.api.util.Iterables;
import org.qi4j.api.value.ValueBuilder;
import se.streamsource.dci.restlet.client.CommandQueryClient;
import se.streamsource.dci.value.ResourceValue;
import se.streamsource.dci.value.StringValue;
import se.streamsource.dci.value.link.LinkValue;
import se.streamsource.dci.value.link.Links;
import se.streamsource.dci.value.link.LinksValue;
import se.streamsource.streamflow.api.workspace.cases.caselog.CaseLogEntryDTO;
import se.streamsource.streamflow.api.workspace.cases.caselog.CaseLogEntryTypes;
import se.streamsource.streamflow.api.workspace.cases.caselog.CaseLogFilterValue;
import se.streamsource.streamflow.client.util.EventListSynch;
import se.streamsource.streamflow.client.util.Refreshable;
import se.streamsource.streamflow.util.Strings;

public class CaseLogModel
extends Observable
implements Refreshable {
    @Structure
    private Module module;
    private final CommandQueryClient client;
    private ResourceValue resourceValue;
    private List<String> selectedFilters = new ArrayList<String>();
    TransactionList<CaseLogEntryDTO> caselogs = new TransactionList((EventList)new BasicEventList());

    public CaseLogModel(@Uses CommandQueryClient client) {
        this.client = client;
        CaseLogFilterValue defaultFilters = (CaseLogFilterValue)client.query("defaultfilters", CaseLogFilterValue.class);
        if (((Boolean)defaultFilters.attachment().get()).booleanValue()) {
            this.selectedFilters.add(CaseLogEntryTypes.attachment.name());
        }
        if (((Boolean)defaultFilters.contact().get()).booleanValue()) {
            this.selectedFilters.add(CaseLogEntryTypes.contact.name());
        }
        if (((Boolean)defaultFilters.conversation().get()).booleanValue()) {
            this.selectedFilters.add(CaseLogEntryTypes.conversation.name());
        }
        if (((Boolean)defaultFilters.custom().get()).booleanValue()) {
            this.selectedFilters.add(CaseLogEntryTypes.custom.name());
        }
        if (((Boolean)defaultFilters.form().get()).booleanValue()) {
            this.selectedFilters.add(CaseLogEntryTypes.form.name());
        }
        if (((Boolean)defaultFilters.system().get()).booleanValue()) {
            this.selectedFilters.add(CaseLogEntryTypes.system.name());
        }
        if (((Boolean)defaultFilters.systemTrace().get()).booleanValue()) {
            this.selectedFilters.add(CaseLogEntryTypes.system_trace.name());
        }
    }

    @Override
    public void refresh() {
        this.resourceValue = this.client.query();
        LinksValue newCaseLogs = (LinksValue)this.client.query("list", LinksValue.class, (Object)this.createFilter());
        EventListSynch.synchronize((Collection)newCaseLogs.links().get(), this.caselogs);
        this.setChanged();
        this.notifyObservers(this.resourceValue);
    }

    private CaseLogFilterValue createFilter() {
        ValueBuilder builder = this.module.valueBuilderFactory().newValueBuilder(CaseLogFilterValue.class);
        ((CaseLogFilterValue)builder.prototype()).attachment().set((Object)this.selectedFilters.contains(CaseLogEntryTypes.attachment.name()));
        ((CaseLogFilterValue)builder.prototype()).contact().set((Object)this.selectedFilters.contains(CaseLogEntryTypes.contact.name()));
        ((CaseLogFilterValue)builder.prototype()).conversation().set((Object)this.selectedFilters.contains(CaseLogEntryTypes.conversation.name()));
        ((CaseLogFilterValue)builder.prototype()).custom().set((Object)this.selectedFilters.contains(CaseLogEntryTypes.custom.name()));
        ((CaseLogFilterValue)builder.prototype()).form().set((Object)this.selectedFilters.contains(CaseLogEntryTypes.form.name()));
        ((CaseLogFilterValue)builder.prototype()).system().set((Object)this.selectedFilters.contains(CaseLogEntryTypes.system.name()));
        ((CaseLogFilterValue)builder.prototype()).systemTrace().set((Object)this.selectedFilters.contains(CaseLogEntryTypes.system_trace.name()));
        return (CaseLogFilterValue)builder.newInstance();
    }

    public EventList<CaseLogEntryDTO> caselogs() {
        return this.caselogs;
    }

    public void addMessage(String newMessage) {
        if (Strings.empty((String)newMessage)) {
            return;
        }
        ValueBuilder builder = this.module.valueBuilderFactory().newValueBuilder(StringValue.class);
        ((StringValue)builder.prototype()).string().set((Object)newMessage);
        this.client.postCommand("addmessage", builder.newInstance());
    }

    public List<String> getSelectedFilters() {
        return this.selectedFilters;
    }

    public void togglepublish(LinkValue link) {
        this.client.postLink(link);
    }

    public boolean getCommandEnabled(String commandName) {
        return Iterables.matchesAny((Specification)Links.withRel((String)commandName), (Iterable)((Iterable)this.resourceValue.commands().get()));
    }
}

