/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.workspace.cases;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import javax.swing.ActionMap;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.Task;
import org.jdesktop.swingx.util.WindowUtils;
import org.netbeans.api.wizard.WizardDisplayer;
import org.netbeans.spi.wizard.Wizard;
import org.netbeans.spi.wizard.WizardException;
import org.netbeans.spi.wizard.WizardPage;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.specification.Specification;
import org.qi4j.api.structure.Module;
import org.qi4j.api.util.Iterables;
import se.streamsource.dci.restlet.client.CommandQueryClient;
import se.streamsource.dci.value.StringValue;
import se.streamsource.dci.value.link.LinkValue;
import se.streamsource.streamflow.api.workspace.cases.CaseOutputConfigDTO;
import se.streamsource.streamflow.api.workspace.cases.general.FormDraftDTO;
import se.streamsource.streamflow.api.workspace.cases.general.PageSubmissionDTO;
import se.streamsource.streamflow.client.MacOsUIWrapper;
import se.streamsource.streamflow.client.StreamflowApplication;
import se.streamsource.streamflow.client.StreamflowResources;
import se.streamsource.streamflow.client.ui.administration.AdministrationResources;
import se.streamsource.streamflow.client.ui.workspace.WorkspaceResources;
import se.streamsource.streamflow.client.ui.workspace.cases.CaseModel;
import se.streamsource.streamflow.client.ui.workspace.cases.PdfPrintingDialog;
import se.streamsource.streamflow.client.ui.workspace.cases.general.forms.FormDraftModel;
import se.streamsource.streamflow.client.ui.workspace.cases.general.forms.FormSubmissionWizardPageView;
import se.streamsource.streamflow.client.util.CommandTask;
import se.streamsource.streamflow.client.util.StreamflowButton;
import se.streamsource.streamflow.client.util.dialog.ConfirmationDialog;
import se.streamsource.streamflow.client.util.dialog.DialogService;
import se.streamsource.streamflow.client.util.dialog.SelectLinkDialog;
import se.streamsource.streamflow.client.util.i18n;
import se.streamsource.streamflow.infrastructure.event.domain.TransactionDomainEvents;
import se.streamsource.streamflow.infrastructure.event.domain.source.TransactionListener;
import se.streamsource.streamflow.infrastructure.event.domain.source.helper.Events;

public class CaseActionsView
extends JPanel
implements TransactionListener,
Observer {
    @Service
    DialogService dialogs;
    @Structure
    Module module;
    @Service
    StreamflowApplication main;
    private CaseModel model;
    private JPanel actionsPanel = new JPanel();
    private ApplicationContext context;

    public CaseActionsView(@Service ApplicationContext context, @Uses CaseModel model) {
        this.model = model;
        this.context = context;
        model.addObserver(this);
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.actionsPanel.setLayout(new GridLayout(0, 1, 5, 5));
        this.add((Component)this.actionsPanel, "North");
        this.setActionMap((ActionMap)context.getActionMap((Object)this));
        MacOsUIWrapper.convertAccelerators((ActionMap)context.getActionMap(CaseActionsView.class, (Object)this));
    }

    @Action(block=Task.BlockingScope.COMPONENT)
    public Task open() {
        return new CommandTask(){

            @Override
            public void command() throws Exception {
                CaseActionsView.this.model.open();
            }
        };
    }

    @Action(block=Task.BlockingScope.COMPONENT)
    public Task assign() {
        return new CommandTask(){

            @Override
            public void command() throws Exception {
                CaseActionsView.this.model.assignToMe();
            }
        };
    }

    @Action(block=Task.BlockingScope.COMPONENT)
    public Task assignto() {
        final SelectLinkDialog dialog = (SelectLinkDialog)this.module.objectBuilderFactory().newObjectBuilder(SelectLinkDialog.class).use(new Object[]{this.model.getPossibleAssignTo()}).newInstance();
        this.dialogs.showOkCancelHelpDialog(this, dialog, i18n.text(WorkspaceResources.choose_assignee_title, new Object[0]));
        if (dialog.getSelectedLink() != null) {
            return new CommandTask(){

                @Override
                public void command() throws Exception {
                    CaseActionsView.this.model.assignTo(dialog.getSelectedLink());
                }
            };
        }
        return null;
    }

    @Action(block=Task.BlockingScope.COMPONENT)
    public Task close() {
        Component focusOwner = WindowUtils.findWindow((Component)this).getFocusOwner();
        if (focusOwner != null) {
            focusOwner.transferFocus();
        }
        return new CommandTask(){

            @Override
            public void command() throws Exception {
                CaseActionsView.this.model.close();
            }
        };
    }

    @Action(block=Task.BlockingScope.COMPONENT)
    public Task resolve() {
        Component focusOwner = WindowUtils.findWindow((Component)this).getFocusOwner();
        if (focusOwner != null) {
            focusOwner.transferFocus();
        }
        final SelectLinkDialog dialog = (SelectLinkDialog)this.module.objectBuilderFactory().newObjectBuilder(SelectLinkDialog.class).use(new Object[]{this.model.getPossibleResolutions()}).newInstance();
        this.dialogs.showOkCancelHelpDialog(WindowUtils.findWindow((Component)this), dialog, i18n.text(AdministrationResources.resolve, new Object[0]));
        if (dialog.getSelectedLink() != null) {
            return new CommandTask(){

                @Override
                public void command() throws Exception {
                    CaseActionsView.this.model.resolve(dialog.getSelectedLink());
                }
            };
        }
        return null;
    }

    @Action(block=Task.BlockingScope.COMPONENT)
    public Task formonclose() {
        Component focusOwner = WindowUtils.findWindow((Component)this).getFocusOwner();
        if (focusOwner != null) {
            focusOwner.transferFocus();
        }
        CommandQueryClient formOnCloseClient = this.model.getClient().getClient("submitformonclose/");
        formOnCloseClient.postCommand("create");
        LinkValue formDraftLink = (LinkValue)formOnCloseClient.query("formdraft", LinkValue.class);
        if (this.formWizard(formDraftLink)) {
            return new CommandTask(){

                @Override
                protected void command() throws Exception {
                    CaseActionsView.this.model.formOnClose();
                }
            };
        }
        return null;
    }

    @Action(block=Task.BlockingScope.COMPONENT)
    public Task formondelete() {
        Component focusOwner = WindowUtils.findWindow((Component)this).getFocusOwner();
        if (focusOwner != null) {
            focusOwner.transferFocus();
        }
        StringValue name = (StringValue)this.model.getClient().query("formondeletename", StringValue.class);
        ConfirmationDialog dialog = (ConfirmationDialog)this.module.objectBuilderFactory().newObject(ConfirmationDialog.class);
        dialog.setCustomMessage(i18n.text(WorkspaceResources.formondelete_confirmation, name.string().get()));
        this.dialogs.showOkCancelHelpDialog(this, dialog, i18n.text(StreamflowResources.confirmation, new Object[0]));
        if (dialog.isConfirmed()) {
            CommandQueryClient formOnRemoveClient = this.model.getClient().getClient("submitformondelete/");
            formOnRemoveClient.postCommand("create");
            LinkValue formDraftLink = (LinkValue)formOnRemoveClient.query("formdraft", LinkValue.class);
            if (this.formWizard(formDraftLink)) {
                return new CommandTask(){

                    @Override
                    protected void command() throws Exception {
                        CaseActionsView.this.model.formOnRemove();
                    }
                };
            }
            return null;
        }
        return null;
    }

    @Action(block=Task.BlockingScope.COMPONENT)
    public Task delete() {
        ConfirmationDialog dialog = (ConfirmationDialog)this.module.objectBuilderFactory().newObject(ConfirmationDialog.class);
        dialog.setRemovalMessage(i18n.text(WorkspaceResources.caze, new Object[0]));
        this.dialogs.showOkCancelHelpDialog(this, dialog, i18n.text(StreamflowResources.confirmation, new Object[0]));
        if (dialog.isConfirmed()) {
            return new CommandTask(){

                @Override
                public void command() throws Exception {
                    CaseActionsView.this.model.delete();
                }
            };
        }
        return null;
    }

    @Action(block=Task.BlockingScope.COMPONENT)
    public Task sendto() {
        final SelectLinkDialog dialog = (SelectLinkDialog)this.module.objectBuilderFactory().newObjectBuilder(SelectLinkDialog.class).use(new Object[]{this.model.getPossibleSendTo()}).newInstance();
        this.dialogs.showOkCancelHelpDialog(this, dialog, i18n.text(WorkspaceResources.choose_owner_title, new Object[0]));
        if (dialog.getSelectedLink() != null) {
            return new CommandTask(){

                @Override
                public void command() throws Exception {
                    CaseActionsView.this.model.sendTo(dialog.getSelectedLink());
                }
            };
        }
        return null;
    }

    @Action(block=Task.BlockingScope.COMPONENT)
    public Task onhold(ActionEvent event) {
        return new CommandTask(){

            @Override
            public void command() throws Exception {
                CaseActionsView.this.model.onHold();
            }
        };
    }

    @Action(block=Task.BlockingScope.COMPONENT)
    public Task reopen() {
        return new CommandTask(){

            @Override
            public void command() throws Exception {
                CaseActionsView.this.model.reopen();
            }
        };
    }

    @Action(block=Task.BlockingScope.COMPONENT)
    public Task resume() {
        return new CommandTask(){

            @Override
            public void command() throws Exception {
                CaseActionsView.this.model.resume();
            }
        };
    }

    @Action(block=Task.BlockingScope.COMPONENT)
    public Task unassign() {
        return new CommandTask(){

            @Override
            public void command() throws Exception {
                CaseActionsView.this.model.unassign();
            }
        };
    }

    @Action(block=Task.BlockingScope.COMPONENT)
    public void exportpdf() {
        PdfPrintingDialog dialog = (PdfPrintingDialog)this.module.objectBuilderFactory().newObjectBuilder(PdfPrintingDialog.class).use(new Object[]{this.context}).newInstance();
        this.dialogs.showOkCancelHelpDialog((StreamflowButton)this.getActionMap().get("exportpdf").getValue("sourceButton"), dialog, i18n.text(WorkspaceResources.printing_configuration, new Object[0]), DialogService.Orientation.right);
        if (dialog.getCaseOutputConfig() != null) {
            new PrintCaseTask(dialog.getCaseOutputConfig()).execute();
        }
    }

    @Action(block=Task.BlockingScope.COMPONENT)
    public Task reinstate() {
        ConfirmationDialog dialog = (ConfirmationDialog)this.module.objectBuilderFactory().newObject(ConfirmationDialog.class);
        dialog.setCustomMessage(i18n.text(WorkspaceResources.caze_reinstate, new Object[0]));
        this.dialogs.showOkCancelHelpDialog(this, dialog, i18n.text(StreamflowResources.confirmation, new Object[0]));
        if (dialog.isConfirmed()) {
            return new CommandTask(){

                @Override
                public void command() throws Exception {
                    CaseActionsView.this.model.reinstate();
                }
            };
        }
        return null;
    }

    @Action(block=Task.BlockingScope.COMPONENT)
    public Task restrict() {
        return new CommandTask(){

            @Override
            protected void command() throws Exception {
                CaseActionsView.this.model.restrict();
            }
        };
    }

    @Action(block=Task.BlockingScope.COMPONENT)
    public Task unrestrict() {
        ConfirmationDialog dialog = (ConfirmationDialog)this.module.objectBuilderFactory().newObject(ConfirmationDialog.class);
        dialog.setCustomMessage(i18n.text(WorkspaceResources.unrestrict_case, new Object[0]));
        this.dialogs.showOkCancelHelpDialog(this, dialog, i18n.text(StreamflowResources.confirmation, new Object[0]));
        if (dialog.isConfirmed()) {
            return new CommandTask(){

                @Override
                protected void command() throws Exception {
                    CaseActionsView.this.model.unrestrict();
                }
            };
        }
        return null;
    }

    @Action(block=Task.BlockingScope.COMPONENT)
    public Task markunread(ActionEvent event) {
        return new CommandTask(){

            @Override
            public void command() throws Exception {
                CaseActionsView.this.model.markunread();
            }
        };
    }

    @Action(block=Task.BlockingScope.COMPONENT)
    public Task markread(ActionEvent event) {
        return new CommandTask(){

            @Override
            public void command() throws Exception {
                CaseActionsView.this.model.markread();
            }
        };
    }

    @Action(block=Task.BlockingScope.COMPONENT)
    public Task requirecasetype() {
        ConfirmationDialog dialog = (ConfirmationDialog)this.module.objectBuilderFactory().newObject(ConfirmationDialog.class);
        dialog.setCustomMessage(i18n.text(WorkspaceResources.caze_requirescasetype, new Object[0]));
        this.dialogs.showOkCancelHelpDialog(this, dialog, i18n.text(StreamflowResources.confirmation, new Object[0]));
        if (dialog.isConfirmed()) {
            return new CommandTask(){

                @Override
                public void command() throws Exception {
                    CaseActionsView.this.model.requirecasetype();
                }
            };
        }
        return null;
    }

    public void notifyTransactions(Iterable<TransactionDomainEvents> transactions) {
        if (Events.matches((Specification)Events.withUsecases((String[])new String[]{"sendto", "open", "assign", "close", "onhold", "reopen", "resume", "unassign", "resolved", "formonclose", "formondelete", "reinstate", "restrict", "unrestrict", "read"}), transactions) || Events.matches((Specification)Events.withNames((String[])new String[]{"changedCaseType"}), transactions)) {
            this.model.refresh();
        }
    }

    @Override
    public void update(Observable o, Object arg) {
        this.actionsPanel.removeAll();
        ActionMap am = this.getActionMap();
        for (CaseActionButtonTemplate buttonOrder : CaseActionButtonTemplate.values()) {
            for (LinkValue commandLink : Iterables.flatten((Iterable[])new Iterable[]{this.model.getCommands(), this.model.getQueries()})) {
                javax.swing.Action action1;
                if (!buttonOrder.toString().equals(commandLink.rel().get()) || (action1 = am.get(commandLink.rel().get())) == null) continue;
                StreamflowButton button = new StreamflowButton(action1);
                button.registerKeyboardAction(action1, (KeyStroke)action1.getValue("AcceleratorKey"), 2);
                button.setHorizontalAlignment(2);
                this.actionsPanel.add(button);
                action1.putValue("sourceButton", button);
            }
        }
        this.revalidate();
        this.repaint();
    }

    private boolean formWizard(LinkValue formDraftLink) {
        Point onScreen;
        CommandQueryClient formDraftClient = this.model.getClient().getClient(formDraftLink);
        final FormDraftModel formDraftModel = (FormDraftModel)this.module.objectBuilderFactory().newObjectBuilder(FormDraftModel.class).use(new Object[]{formDraftClient}).newInstance();
        FormDraftDTO formDraftDTO = (FormDraftDTO)formDraftModel.getFormDraftDTO().buildWith().prototype();
        final WizardPage[] wizardPages = new WizardPage[((List)formDraftDTO.pages().get()).size()];
        for (int i = 0; i < ((List)formDraftDTO.pages().get()).size(); ++i) {
            PageSubmissionDTO page = (PageSubmissionDTO)((List)formDraftDTO.pages().get()).get(i);
            if (page.fields().get() == null || ((List)page.fields().get()).size() <= 0) continue;
            wizardPages[i] = (WizardPage)this.module.objectBuilderFactory().newObjectBuilder(FormSubmissionWizardPageView.class).use(new Object[]{formDraftModel, page}).newInstance();
        }
        HashMap initialProperties = new HashMap();
        Wizard wizard = WizardPage.createWizard((String)((String)formDraftDTO.description().get()), (WizardPage[])wizardPages, (WizardPage.WizardResultProducer)new WizardPage.WizardResultProducer(){

            public Object finish(Map map) throws WizardException {
                Component focusOwner = WindowUtils.findWindow((Component)wizardPages[wizardPages.length - 1]).getFocusOwner();
                if (focusOwner != null) {
                    focusOwner.transferFocus();
                    formDraftModel.submit();
                    map.put("success", true);
                }
                return map;
            }

            public boolean cancel(Map map) {
                formDraftModel.delete();
                return true;
            }
        });
        Map result = (Map)WizardDisplayer.showWizard((Wizard)wizard, (Rectangle)new Rectangle(onScreen = this.main.getMainFrame().getLocationOnScreen(), new Dimension(800, 600)), null, initialProperties);
        return result == null || result.get("success") == null ? false : (Boolean)result.get("success");
    }

    public boolean open(File file) {
        if (this.openSystemSpecific(file.getPath())) {
            return true;
        }
        return this.openDESKTOP(file);
    }

    public boolean edit(File file) {
        if (this.openSystemSpecific(file.getPath())) {
            return true;
        }
        return this.editDESKTOP(file);
    }

    private boolean openSystemSpecific(String what) {
        EnumOS os = CaseActionsView.getOs();
        if (os.isLinux()) {
            if (this.runCommand("kde-open", "%s", what)) {
                return true;
            }
            if (this.runCommand("gnome-open", "%s", what)) {
                return true;
            }
            if (this.runCommand("xdg-open", "%s", what)) {
                return true;
            }
        }
        if (os.isMac() && this.runCommand("open", "%s", what)) {
            return true;
        }
        return os.isWindows() && this.runCommand("explorer", "%s", what);
    }

    private boolean openDESKTOP(File file) {
        CaseActionsView.logOut("Trying to use Desktop.getDesktop().open() with " + file.toString());
        try {
            if (!Desktop.isDesktopSupported()) {
                CaseActionsView.logErr("Platform is not supported.");
                return false;
            }
            if (!Desktop.getDesktop().isSupported(Desktop.Action.OPEN)) {
                CaseActionsView.logErr("OPEN is not supported.");
                return false;
            }
            Desktop.getDesktop().open(file);
            return true;
        }
        catch (Throwable t) {
            CaseActionsView.logErr("Error using desktop open.", t);
            return false;
        }
    }

    private boolean editDESKTOP(File file) {
        CaseActionsView.logOut("Trying to use Desktop.getDesktop().edit() with " + file);
        try {
            if (!Desktop.isDesktopSupported()) {
                CaseActionsView.logErr("Platform is not supported.");
                return false;
            }
            if (!Desktop.getDesktop().isSupported(Desktop.Action.EDIT)) {
                CaseActionsView.logErr("EDIT is not supported.");
                return false;
            }
            Desktop.getDesktop().edit(file);
            return true;
        }
        catch (Throwable t) {
            CaseActionsView.logErr("Error using desktop edit.", t);
            return false;
        }
    }

    private boolean runCommand(String command, String args, String file) {
        CaseActionsView.logOut("Trying to exec:\n   cmd = " + command + "\n   args = " + args + "\n   %s = " + file);
        String[] parts = this.prepareCommand(command, args, file);
        try {
            Process p = Runtime.getRuntime().exec(parts);
            if (p == null) {
                return false;
            }
            try {
                int retval = p.exitValue();
                if (retval == 0) {
                    CaseActionsView.logErr("Process ended immediately.");
                    return false;
                }
                CaseActionsView.logErr("Process crashed.");
                return false;
            }
            catch (IllegalThreadStateException itse) {
                CaseActionsView.logErr("Process is running.");
                return true;
            }
        }
        catch (IOException e) {
            CaseActionsView.logErr("Error running command.", e);
            return false;
        }
    }

    private String[] prepareCommand(String command, String args, String file) {
        ArrayList<String> parts = new ArrayList<String>();
        parts.add(command);
        if (args != null) {
            for (String s : args.split(" ")) {
                s = String.format(s, file);
                parts.add(s.trim());
            }
        }
        return parts.toArray(new String[parts.size()]);
    }

    private static void logErr(String msg, Throwable t) {
        System.err.println(msg);
        t.printStackTrace();
    }

    private static void logErr(String msg) {
        System.err.println(msg);
    }

    private static void logOut(String msg) {
        System.out.println(msg);
    }

    public static EnumOS getOs() {
        String s = System.getProperty("os.name").toLowerCase();
        if (s.contains("win")) {
            return EnumOS.windows;
        }
        if (s.contains("mac")) {
            return EnumOS.macos;
        }
        if (s.contains("solaris")) {
            return EnumOS.solaris;
        }
        if (s.contains("sunos")) {
            return EnumOS.solaris;
        }
        if (s.contains("linux")) {
            return EnumOS.linux;
        }
        if (s.contains("unix")) {
            return EnumOS.linux;
        }
        return EnumOS.unknown;
    }

    public static enum EnumOS {
        linux,
        macos,
        solaris,
        unknown,
        windows;


        public boolean isLinux() {
            return this == linux || this == solaris;
        }

        public boolean isMac() {
            return this == macos;
        }

        public boolean isWindows() {
            return this == windows;
        }
    }

    private class PrintCaseTask
    extends Task<File, Void> {
        private CaseOutputConfigDTO config;

        public PrintCaseTask(CaseOutputConfigDTO config) {
            super(Application.getInstance());
            this.config = config;
            this.setUserCanCancel(false);
        }

        protected File doInBackground() throws Exception {
            this.setMessage(this.getResourceMap().getString("description", new Object[0]));
            File file = CaseActionsView.this.model.export(this.config);
            return file;
        }

        protected void succeeded(File file) {
            Desktop desktop = Desktop.getDesktop();
            try {
                CaseActionsView.this.edit(file);
            }
            catch (Exception e) {
                try {
                    CaseActionsView.this.open(file);
                }
                catch (Exception e1) {
                    CaseActionsView.this.dialogs.showMessageDialog(CaseActionsView.this, i18n.text(WorkspaceResources.could_not_print, new Object[0]), "");
                }
            }
        }
    }

    private static enum CaseActionButtonTemplate {
        open,
        sendto,
        assign,
        assignto,
        unassign,
        onhold,
        resume,
        formondelete,
        reopen,
        delete,
        exportpdf,
        reinstate,
        restrict,
        unrestrict,
        markunread,
        markread,
        requirecasetype,
        resolve,
        formonclose,
        close;

    }
}

