/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.workspace;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.application.Application;
import org.jdesktop.application.FrameView;
import org.jdesktop.swingx.JXFrame;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.structure.Module;
import se.streamsource.streamflow.client.ui.account.AccountModel;
import se.streamsource.streamflow.client.ui.account.AccountSelectionView;
import se.streamsource.streamflow.client.ui.account.AccountSelector;
import se.streamsource.streamflow.client.ui.menu.WorkspaceMenuBar;
import se.streamsource.streamflow.client.ui.workspace.WorkspaceResources;
import se.streamsource.streamflow.client.ui.workspace.WorkspaceView;
import se.streamsource.streamflow.client.util.JavaHelp;
import se.streamsource.streamflow.client.util.i18n;

public class WorkspaceWindow
extends FrameView {
    public CardLayout cardLayout;
    private WorkspaceView currentWorkspace;

    public WorkspaceWindow(@Service Application application, @Service JavaHelp javaHelp, @Uses WorkspaceMenuBar menu, @Uses AccountSelectionView view, final @Uses AccountSelector accountSelector, final @Structure Module module) {
        super(application);
        final JXFrame frame = new JXFrame(i18n.text(WorkspaceResources.window_name, new Object[0]));
        frame.setLocationByPlatform(true);
        this.cardLayout = new CardLayout();
        frame.getContentPane().setLayout(this.cardLayout);
        frame.getContentPane().add((Component)view, "selector");
        frame.getContentPane().add((Component)new JPanel(), "workspace");
        frame.getRootPane().setOpaque(true);
        this.setFrame((JFrame)frame);
        this.setMenuBar(menu);
        frame.setPreferredSize(new Dimension(1300, 800));
        frame.pack();
        frame.setExtendedState(frame.getExtendedState() | 6);
        ListSelectionListener workspaceListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    if (accountSelector.isSelectionEmpty()) {
                        WorkspaceWindow.this.cardLayout.show(frame.getContentPane(), "selector");
                    } else {
                        final AccountModel accountModel = accountSelector.getSelectedAccount();
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (WorkspaceWindow.this.currentWorkspace != null) {
                                    WorkspaceWindow.this.currentWorkspace.killPopup();
                                }
                                WorkspaceWindow.this.currentWorkspace = (WorkspaceView)module.objectBuilderFactory().newObjectBuilder(WorkspaceView.class).use(new Object[]{accountModel.newWorkspaceModel()}).newInstance();
                                frame.getContentPane().add((Component)WorkspaceWindow.this.currentWorkspace, "workspace");
                                WorkspaceWindow.this.cardLayout.show(frame.getContentPane(), "workspace");
                            }
                        });
                    }
                }
            }
        };
        accountSelector.addListSelectionListener(workspaceListener);
    }

    public WorkspaceView getCurrentWorkspace() {
        return this.currentWorkspace;
    }
}

