/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.menu;

import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.ResourceMap;
import org.qi4j.api.injection.scope.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMenu
extends JMenu {
    final Logger logger = LoggerFactory.getLogger((String)"menu");
    private ApplicationContext context;

    public void init(@Service ApplicationContext context) {
        this.setActionMap((ActionMap)context.getActionMap());
        this.context = context;
        this.init();
    }

    protected abstract void init();

    protected void menu(String menuName, String ... menuItems) {
        ActionMap am = this.getActionMap();
        ResourceMap resourceMap = this.context.getResourceMap(this.getClass(), AbstractMenu.class);
        String menuTitle = resourceMap.getString(menuName, new Object[0]);
        this.setText(menuTitle);
        this.setMnemonic(menuTitle.charAt(0));
        for (String menuItem : menuItems) {
            if (menuItem.equals("---")) {
                this.add(new JSeparator());
                continue;
            }
            String actionName = menuItem.startsWith("*") ? menuItem.substring(1) : menuItem;
            Action menuItemAction = am.get(actionName);
            if (menuItemAction == null) {
                this.logger.warn("Could not find menu action:" + actionName);
                continue;
            }
            JMenuItem item = menuItem.startsWith("*") ? new JCheckBoxMenuItem() : new JMenuItem();
            item.setAction(menuItemAction);
            item.setIcon(null);
            this.add(item);
        }
    }
}

