/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.administration.users;

import ca.odell.glazedlists.swing.EventListModel;
import java.awt.Color;
import java.awt.Component;
import javax.swing.ActionMap;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.Task;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.structure.Module;
import se.streamsource.dci.value.ResourceValue;
import se.streamsource.dci.value.link.LinkValue;
import se.streamsource.streamflow.api.administration.UserEntityDTO;
import se.streamsource.streamflow.client.ui.administration.AdministrationResources;
import se.streamsource.streamflow.client.ui.administration.users.CreateUserDialog;
import se.streamsource.streamflow.client.ui.administration.users.UserAdministrationDetailView;
import se.streamsource.streamflow.client.ui.administration.users.UsersAdministrationListModel;
import se.streamsource.streamflow.client.util.CommandTask;
import se.streamsource.streamflow.client.util.FileNameExtensionFilter;
import se.streamsource.streamflow.client.util.ListDetailView;
import se.streamsource.streamflow.client.util.RefreshWhenShowing;
import se.streamsource.streamflow.client.util.ResourceActionEnabler;
import se.streamsource.streamflow.client.util.SelectionActionEnabler;
import se.streamsource.streamflow.client.util.dialog.DialogService;
import se.streamsource.streamflow.client.util.i18n;
import se.streamsource.streamflow.infrastructure.event.domain.TransactionDomainEvents;

public class UsersAdministrationListView
extends ListDetailView {
    UsersAdministrationListModel model;
    @Service
    DialogService dialogs;
    @Structure
    Module module;

    public UsersAdministrationListView(@Service ApplicationContext context, final @Uses UsersAdministrationListModel model) {
        this.model = model;
        ApplicationActionMap am = context.getActionMap((Object)this);
        this.setActionMap((ActionMap)am);
        this.initMaster((EventListModel<LinkValue>)new EventListModel(model.getList()), am.get("createuser"), new SelectionActionEnabler(new javax.swing.Action[]{am.get("importusers")}){

            @Override
            public boolean isSelectedValueValid(javax.swing.Action action) {
                return action.isEnabled();
            }
        }, new ListDetailView.DetailFactory(){

            @Override
            public Component createDetail(LinkValue detailLink) {
                return (Component)UsersAdministrationListView.this.module.objectBuilderFactory().newObjectBuilder(UserAdministrationDetailView.class).use(new Object[]{model.newResourceModel(detailLink)}).newInstance();
            }
        }, new ListCellRenderer(){
            private DefaultListCellRenderer defaultRenderer = new DefaultListCellRenderer();

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                UserEntityDTO user = (UserEntityDTO)value;
                StringBuilder sb = new StringBuilder();
                if (!((Boolean)user.joined().get()).booleanValue()) {
                    sb.append("<html><s>").append((String)user.text().get()).append("</s></html>");
                } else {
                    sb.append("<html>").append((String)user.text().get()).append("</html>");
                }
                JLabel label = (JLabel)this.defaultRenderer.getListCellRendererComponent((JList<?>)list, sb.toString(), index, isSelected, cellHasFocus);
                if (((Boolean)user.disabled().get()).booleanValue()) {
                    label.setForeground(Color.GRAY);
                }
                return label;
            }
        });
        ResourceActionEnabler resourceActionEnabler = new ResourceActionEnabler(new javax.swing.Action[]{am.get("createuser"), am.get("importusers")}){

            @Override
            protected ResourceValue getResource() {
                model.refresh();
                return model.getResourceValue();
            }
        };
        new RefreshWhenShowing(this, resourceActionEnabler);
    }

    @Action
    public Task createuser() {
        final CreateUserDialog dialog = (CreateUserDialog)this.module.objectBuilderFactory().newObject(CreateUserDialog.class);
        this.dialogs.showOkCancelHelpDialog(this, dialog, i18n.text(AdministrationResources.create_user_title, new Object[0]));
        if (dialog.userCommand() != null) {
            return new CommandTask(){

                @Override
                public void command() throws Exception {
                    UsersAdministrationListView.this.model.createUser(dialog.userCommand());
                }
            };
        }
        return null;
    }

    @Action
    public Task importusers() {
        final JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(2);
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.addChoosableFileFilter(new FileNameExtensionFilter(i18n.text(AdministrationResources.import_files, new Object[0]), true, "xls", "csv", "txt"));
        fileChooser.setDialogTitle(i18n.text(AdministrationResources.import_users, new Object[0]));
        int returnVal = fileChooser.showOpenDialog(this);
        if (returnVal != 0) {
            return null;
        }
        return new CommandTask(){

            @Override
            public void command() throws Exception {
                UsersAdministrationListView.this.model.importUsers(fileChooser.getSelectedFile().getAbsoluteFile());
            }
        };
    }

    @Override
    public void notifyTransactions(Iterable<TransactionDomainEvents> transactions) {
        this.model.notifyTransactions(transactions);
        super.notifyTransactions(transactions);
    }
}

