/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.administration.users;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.ActionMap;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.swingx.util.WindowUtils;
import org.qi4j.api.constraint.ConstraintViolationException;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.structure.Module;
import org.qi4j.api.value.ValueBuilder;
import se.streamsource.streamflow.api.ErrorResources;
import se.streamsource.streamflow.api.administration.NewUserDTO;
import se.streamsource.streamflow.client.ui.administration.AdministrationResources;
import se.streamsource.streamflow.client.util.dialog.DialogService;
import se.streamsource.streamflow.client.util.i18n;

public class CreateUserDialog
extends JPanel {
    public JTextField usernameField;
    public JPasswordField passwordField;
    public JPasswordField confirmPasswordField;
    @Uses
    DialogService dialogs;
    @Structure
    Module module;
    private NewUserDTO DTO;

    public CreateUserDialog(@Service ApplicationContext context) {
        super(new BorderLayout());
        this.setActionMap((ActionMap)context.getActionMap((Object)this));
        this.getActionMap().put("close", this.getActionMap().get("cancel"));
        FormLayout layout = new FormLayout("60dlu, 5dlu, 120dlu:grow", "pref, pref, pref, pref, 10dlu, pref, pref, pref, pref");
        JPanel form = new JPanel((LayoutManager)layout);
        form.setFocusable(false);
        DefaultFormBuilder builder = new DefaultFormBuilder(layout, form);
        this.usernameField = new JTextField();
        this.passwordField = new JPasswordField();
        this.confirmPasswordField = new JPasswordField();
        builder.add((Component)new JLabel(i18n.text(AdministrationResources.username_label, new Object[0])));
        builder.nextColumn(2);
        builder.add((Component)this.usernameField);
        builder.nextLine();
        builder.add((Component)new JLabel(i18n.text(AdministrationResources.password_label, new Object[0])));
        builder.nextColumn(2);
        builder.add((Component)this.passwordField);
        builder.nextLine();
        builder.add((Component)new JLabel(i18n.text(AdministrationResources.confirm_password_label, new Object[0])));
        builder.nextColumn(2);
        builder.add((Component)this.confirmPasswordField);
        builder.nextLine(2);
        this.add((Component)form, "Center");
    }

    public NewUserDTO userCommand() {
        return this.DTO;
    }

    @Action
    public void execute() {
        if (!String.valueOf(this.passwordField.getPassword()).equals(String.valueOf(this.confirmPasswordField.getPassword()))) {
            this.passwordField.setText("");
            this.confirmPasswordField.setText("");
            this.dialogs.showOkCancelHelpDialog(WindowUtils.findWindow((Component)this), new JLabel(i18n.text(AdministrationResources.passwords_dont_match, new Object[0])));
            return;
        }
        ValueBuilder builder = this.module.valueBuilderFactory().newValueBuilder(NewUserDTO.class);
        try {
            ((NewUserDTO)builder.prototype()).username().set((Object)this.usernameField.getText());
            ((NewUserDTO)builder.prototype()).password().set((Object)String.valueOf(this.passwordField.getPassword()));
            this.DTO = (NewUserDTO)builder.newInstance();
        }
        catch (ConstraintViolationException e) {
            this.dialogs.showOkCancelHelpDialog(WindowUtils.findWindow((Component)this), new JLabel(i18n.text((Enum)ErrorResources.username_password_violation, new Object[0])));
            return;
        }
        WindowUtils.findWindow((Component)this).dispose();
    }

    @Action
    public void cancel() {
        WindowUtils.findWindow((Component)this).dispose();
    }
}

