/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.administration.templates;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.ConstantSize;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.Sizes;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Observable;
import java.util.Observer;
import javax.swing.ActionMap;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.Task;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.property.Property;
import org.qi4j.api.specification.Specification;
import org.qi4j.api.structure.Module;
import se.streamsource.dci.value.link.LinkValue;
import se.streamsource.streamflow.api.administration.surface.SelectedTemplatesDTO;
import se.streamsource.streamflow.client.MacOsUIWrapper;
import se.streamsource.streamflow.client.ui.administration.templates.SelectedTemplatesModel;
import se.streamsource.streamflow.client.ui.workspace.WorkspaceResources;
import se.streamsource.streamflow.client.ui.workspace.cases.general.RemovableLabel;
import se.streamsource.streamflow.client.util.CommandTask;
import se.streamsource.streamflow.client.util.RefreshWhenShowing;
import se.streamsource.streamflow.client.util.StateBinder;
import se.streamsource.streamflow.client.util.StreamflowButton;
import se.streamsource.streamflow.client.util.dialog.DialogService;
import se.streamsource.streamflow.client.util.dialog.SelectLinkDialog;
import se.streamsource.streamflow.client.util.i18n;
import se.streamsource.streamflow.infrastructure.event.domain.TransactionDomainEvents;
import se.streamsource.streamflow.infrastructure.event.domain.source.TransactionListener;
import se.streamsource.streamflow.infrastructure.event.domain.source.helper.Events;

public class SelectedTemplatesView
extends JPanel
implements Observer,
TransactionListener {
    @Service
    DialogService dialogs;
    @Structure
    Module module;
    private StateBinder selectedTemplatesBinder;
    StreamflowButton defaultTemplateButton;
    StreamflowButton formTemplateButton;
    StreamflowButton caseTemplateButton;
    RemovableLabel defaultTemplate = new RemovableLabel();
    RemovableLabel formTemplate = new RemovableLabel();
    RemovableLabel caseTemplate = new RemovableLabel();
    private SelectedTemplatesModel model;

    public SelectedTemplatesView(@Service ApplicationContext appContext, @Uses SelectedTemplatesModel model, @Structure Module module) {
        this.model = model;
        model.addObserver(this);
        this.selectedTemplatesBinder = (StateBinder)module.objectBuilderFactory().newObject(StateBinder.class);
        this.selectedTemplatesBinder.addObserver(this);
        this.selectedTemplatesBinder.addConverter(new StateBinder.Converter(){

            @Override
            public Object toComponent(Object value) {
                if (value instanceof LinkValue) {
                    return ((LinkValue)value).text().get();
                }
                return value;
            }

            @Override
            public Object fromComponent(Object value) {
                return value;
            }
        });
        this.selectedTemplatesBinder.setResourceMap(appContext.getResourceMap(this.getClass()));
        SelectedTemplatesDTO template = this.selectedTemplatesBinder.bindingTemplate(SelectedTemplatesDTO.class);
        this.defaultTemplate.getLabel().setFont(this.defaultTemplate.getLabel().getFont().deriveFont(1));
        this.defaultTemplate.setPreferredSize(new Dimension(150, 25));
        this.formTemplate.getLabel().setFont(this.formTemplate.getLabel().getFont().deriveFont(1));
        this.formTemplate.setPreferredSize(new Dimension(150, 25));
        this.caseTemplate.getLabel().setFont(this.caseTemplate.getLabel().getFont().deriveFont(1));
        this.caseTemplate.setPreferredSize(new Dimension(150, 25));
        FormLayout layout = new FormLayout("80dlu, 5dlu, 150:grow", "pref, 2dlu, pref, 2dlu, pref, 2dlu, pref:grow");
        JPanel panel = new JPanel((LayoutManager)layout);
        DefaultFormBuilder builder = new DefaultFormBuilder(layout, panel);
        builder.setBorder(Borders.createEmptyBorder((ConstantSize)Sizes.DLUY8, (ConstantSize)Sizes.DLUX4, (ConstantSize)Sizes.DLUY2, (ConstantSize)Sizes.DLUX8));
        CellConstraints cc = new CellConstraints();
        this.setActionMap((ActionMap)appContext.getActionMap((Object)this));
        MacOsUIWrapper.convertAccelerators((ActionMap)appContext.getActionMap(SelectedTemplatesView.class, (Object)this));
        ActionMap am = this.getActionMap();
        javax.swing.Action defaultTemplateAction = am.get("defaultTemplate");
        this.defaultTemplateButton = new StreamflowButton(defaultTemplateAction);
        this.defaultTemplateButton.registerKeyboardAction(defaultTemplateAction, (KeyStroke)defaultTemplateAction.getValue("AcceleratorKey"), 2);
        this.defaultTemplateButton.setHorizontalAlignment(2);
        builder.add((Component)this.defaultTemplateButton, cc.xy(1, 3, CellConstraints.FILL, CellConstraints.TOP));
        builder.add((Component)this.selectedTemplatesBinder.bind(this.defaultTemplate, template.defaultPdfTemplate()), new CellConstraints(3, 3, 1, 1, CellConstraints.LEFT, CellConstraints.TOP, new Insets(3, 0, 0, 0)));
        javax.swing.Action formTemplateAction = am.get("formTemplate");
        this.formTemplateButton = new StreamflowButton(formTemplateAction);
        this.formTemplateButton.registerKeyboardAction(formTemplateAction, (KeyStroke)formTemplateAction.getValue("AcceleratorKey"), 2);
        this.formTemplateButton.setHorizontalAlignment(2);
        builder.add((Component)this.formTemplateButton, cc.xy(1, 5, CellConstraints.FILL, CellConstraints.TOP));
        builder.add((Component)this.selectedTemplatesBinder.bind(this.formTemplate, template.formPdfTemplate()), new CellConstraints(3, 5, 1, 1, CellConstraints.LEFT, CellConstraints.TOP, new Insets(3, 0, 0, 0)));
        javax.swing.Action caseTemplateAction = am.get("caseTemplate");
        this.caseTemplateButton = new StreamflowButton(caseTemplateAction);
        this.caseTemplateButton.registerKeyboardAction(caseTemplateAction, (KeyStroke)caseTemplateAction.getValue("AcceleratorKey"), 2);
        this.caseTemplateButton.setHorizontalAlignment(2);
        builder.add((Component)this.caseTemplateButton, cc.xy(1, 7, CellConstraints.FILL, CellConstraints.TOP));
        builder.add((Component)this.selectedTemplatesBinder.bind(this.caseTemplate, template.casePdfTemplate()), new CellConstraints(3, 7, 1, 1, CellConstraints.LEFT, CellConstraints.TOP, new Insets(3, 0, 0, 0)));
        this.add((Component)panel, "Center");
        this.selectedTemplatesBinder.updateWith(model.getSelectedTemplatesValue());
        new RefreshWhenShowing(this, model);
    }

    @Action
    public Task defaultTemplate() {
        return new CommandTask(){

            @Override
            public void command() throws Exception {
                SelectLinkDialog dialog = (SelectLinkDialog)SelectedTemplatesView.this.module.objectBuilderFactory().newObjectBuilder(SelectLinkDialog.class).use(new Object[]{i18n.text(WorkspaceResources.choose_template, new Object[0]), SelectedTemplatesView.this.model.getPossibleTemplates("possibledefaulttemplates")}).newInstance();
                SelectedTemplatesView.this.dialogs.showOkCancelHelpDialog(SelectedTemplatesView.this.defaultTemplateButton, dialog);
                if (dialog.getSelectedLink() != null) {
                    SelectedTemplatesView.this.model.setTemplate(dialog.getSelectedLink());
                }
            }
        };
    }

    @Action
    public Task formTemplate() {
        return new CommandTask(){

            @Override
            public void command() throws Exception {
                SelectLinkDialog dialog = (SelectLinkDialog)SelectedTemplatesView.this.module.objectBuilderFactory().newObjectBuilder(SelectLinkDialog.class).use(new Object[]{i18n.text(WorkspaceResources.choose_template, new Object[0]), SelectedTemplatesView.this.model.getPossibleTemplates("possibleformtemplates")}).newInstance();
                SelectedTemplatesView.this.dialogs.showOkCancelHelpDialog(SelectedTemplatesView.this.formTemplateButton, dialog);
                if (dialog.getSelectedLink() != null) {
                    SelectedTemplatesView.this.model.setTemplate(dialog.getSelectedLink());
                }
            }
        };
    }

    @Action
    public Task caseTemplate() {
        return new CommandTask(){

            @Override
            public void command() throws Exception {
                SelectLinkDialog dialog = (SelectLinkDialog)SelectedTemplatesView.this.module.objectBuilderFactory().newObjectBuilder(SelectLinkDialog.class).use(new Object[]{i18n.text(WorkspaceResources.choose_template, new Object[0]), SelectedTemplatesView.this.model.getPossibleTemplates("possiblecasetemplates")}).newInstance();
                SelectedTemplatesView.this.dialogs.showOkCancelHelpDialog(SelectedTemplatesView.this.defaultTemplateButton, dialog);
                if (dialog.getSelectedLink() != null) {
                    SelectedTemplatesView.this.model.setTemplate(dialog.getSelectedLink());
                }
            }
        };
    }

    @Override
    public void update(Observable o, Object arg) {
        if (o == this.selectedTemplatesBinder) {
            Property property = (Property)arg;
            if (property.qualifiedName().name().equals("defaultPdfTemplate")) {
                new CommandTask(){

                    @Override
                    public void command() throws Exception {
                        SelectedTemplatesView.this.model.removeTemplate("setdefaulttemplate");
                    }
                }.execute();
            } else if (property.qualifiedName().name().equals("formPdfTemplate")) {
                new CommandTask(){

                    @Override
                    public void command() throws Exception {
                        SelectedTemplatesView.this.model.removeTemplate("setformtemplate");
                    }
                }.execute();
            } else if (property.qualifiedName().name().equals("casePdfTemplate")) {
                new CommandTask(){

                    @Override
                    public void command() throws Exception {
                        SelectedTemplatesView.this.model.removeTemplate("setcasetemplate");
                    }
                }.execute();
            }
        } else {
            SelectedTemplatesDTO selectedTemplatesValue = this.model.getSelectedTemplatesValue();
            this.defaultTemplate.setRemoveLink((LinkValue)selectedTemplatesValue.defaultPdfTemplate().get());
            this.selectedTemplatesBinder.updateWith(selectedTemplatesValue);
        }
    }

    public void notifyTransactions(Iterable<TransactionDomainEvents> transactions) {
        if (Events.matches((Specification)Events.withNames((String[])new String[]{"defaultPdfTemplateSet", "formPdfTemplateSet", "casePdfTemplateSet"}), transactions)) {
            this.model.refresh();
        }
    }
}

