/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.administration.surface;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Insets;
import java.util.Map;
import javax.swing.ActionMap;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.Task;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.structure.Module;
import org.qi4j.api.value.ValueComposite;
import se.streamsource.streamflow.api.administration.surface.EmailAccessPointDTO;
import se.streamsource.streamflow.client.ui.administration.AdministrationResources;
import se.streamsource.streamflow.client.ui.administration.surface.EmailAccessPointModel;
import se.streamsource.streamflow.client.ui.workspace.WorkspaceResources;
import se.streamsource.streamflow.client.ui.workspace.cases.general.CaseLabelsView;
import se.streamsource.streamflow.client.ui.workspace.cases.general.RemovableLabel;
import se.streamsource.streamflow.client.util.ActionBinder;
import se.streamsource.streamflow.client.util.CommandTask;
import se.streamsource.streamflow.client.util.RefreshWhenShowing;
import se.streamsource.streamflow.client.util.Refreshable;
import se.streamsource.streamflow.client.util.StreamflowButton;
import se.streamsource.streamflow.client.util.ValueBinder;
import se.streamsource.streamflow.client.util.dialog.DialogService;
import se.streamsource.streamflow.client.util.dialog.SelectLinkDialog;
import se.streamsource.streamflow.client.util.i18n;
import se.streamsource.streamflow.infrastructure.event.domain.TransactionDomainEvents;
import se.streamsource.streamflow.infrastructure.event.domain.source.TransactionListener;

public class EmailAccessPointView
extends JScrollPane
implements TransactionListener,
Refreshable {
    @Service
    DialogService dialogs;
    @Structure
    Module module;
    private EmailAccessPointModel model;
    private JTextField subject;
    private JList emailTemplateList = new JList();
    private JTextArea emailTemplateText = new JTextArea();
    private JLabel project;
    private RemovableLabel casetype = new RemovableLabel();
    private StreamflowButton casetypeButton;
    private StreamflowButton projectButton;
    private StreamflowButton labelsButton;
    private CaseLabelsView labels;

    public void init(@Service ApplicationContext context, final @Uses EmailAccessPointModel model) {
        this.setActionMap((ActionMap)context.getActionMap((Object)this));
        JPanel panel = new JPanel();
        this.setViewportView(panel);
        this.model = model;
        this.labels = (CaseLabelsView)this.module.objectBuilderFactory().newObjectBuilder(CaseLabelsView.class).use(new Object[]{model.createLabelsModel()}).newInstance();
        FormLayout layout = new FormLayout("75dlu, 5dlu, fill:p:grow", "pref, pref, pref, pref, pref, fill:p:grow, pref");
        DefaultFormBuilder formBuilder = new DefaultFormBuilder(layout, panel);
        this.projectButton = new StreamflowButton(this.getActionMap().get("project"));
        formBuilder.append((Component)this.projectButton);
        this.project = new JLabel();
        formBuilder.append((Component)this.project);
        formBuilder.nextLine();
        this.casetypeButton = new StreamflowButton(this.getActionMap().get("casetype"));
        formBuilder.append((Component)this.casetypeButton);
        formBuilder.add((Component)this.casetype, new CellConstraints(3, 2, 1, 1, CellConstraints.LEFT, CellConstraints.CENTER, new Insets(3, 0, 0, 0)));
        formBuilder.nextLine();
        this.labelsButton = new StreamflowButton(this.labels.getActionMap().get("addLabel"));
        formBuilder.append((Component)this.labelsButton);
        formBuilder.add((Component)this.labels, new CellConstraints(3, 3, 1, 1, CellConstraints.LEFT, CellConstraints.CENTER, new Insets(3, -3, 0, 0)));
        formBuilder.nextLine();
        formBuilder.addSeparator(i18n.text(AdministrationResources.emailTemplates, new Object[0]));
        formBuilder.nextLine();
        this.subject = new JTextField();
        formBuilder.append(i18n.text(AdministrationResources.subject, new Object[0]), (Component)this.subject);
        formBuilder.nextLine();
        formBuilder.append((Component)new JScrollPane(this.emailTemplateList));
        formBuilder.append((Component)new JScrollPane(this.emailTemplateText));
        formBuilder.nextLine();
        this.emailTemplateList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting() && EmailAccessPointView.this.emailTemplateList.getSelectedIndex() != -1) {
                    EmailAccessPointView.this.emailTemplateText.setText((String)((Map)model.getValue().messages().get()).get(EmailAccessPointView.this.emailTemplateList.getSelectedValue()));
                }
            }
        });
        ActionBinder actionBinder = new ActionBinder(this.getActionMap());
        actionBinder.bind("save", this.emailTemplateText);
        actionBinder.bind("changeSubject", this.subject);
        actionBinder.bind("removecasetype", this.casetype);
        new RefreshWhenShowing(this, this);
    }

    @Action
    public Task project() {
        final SelectLinkDialog dialog = (SelectLinkDialog)this.module.objectBuilderFactory().newObjectBuilder(SelectLinkDialog.class).use(new Object[]{this.model.getPossibleProjects()}).newInstance();
        this.dialogs.showOkCancelHelpDialog(this.projectButton, dialog, i18n.text(WorkspaceResources.choose_project, new Object[0]));
        return new CommandTask(){

            @Override
            public void command() throws Exception {
                if (dialog.getSelectedLink() != null) {
                    EmailAccessPointView.this.model.changeProject(dialog.getSelectedLink());
                }
            }
        };
    }

    @Action
    public Task casetype() {
        final SelectLinkDialog dialog = (SelectLinkDialog)this.module.objectBuilderFactory().newObjectBuilder(SelectLinkDialog.class).use(new Object[]{i18n.text(WorkspaceResources.choose_casetype, new Object[0]), this.model.getPossibleCaseTypes()}).newInstance();
        this.dialogs.showOkCancelHelpDialog(this.casetypeButton, dialog);
        return new CommandTask(){

            @Override
            public void command() throws Exception {
                if (dialog.getSelectedLink() != null) {
                    EmailAccessPointView.this.model.changeCaseType(dialog.getSelectedLink());
                }
            }
        };
    }

    @Action
    public Task removecasetype() {
        return new CommandTask(){

            @Override
            protected void command() throws Exception {
                EmailAccessPointView.this.model.removeCaseType();
            }
        };
    }

    @Override
    public void refresh() {
        this.model.refresh();
        ValueBinder binder = (ValueBinder)this.module.objectBuilderFactory().newObject(ValueBinder.class);
        binder.bind("project", this.project);
        binder.bind("caseType", this.casetype);
        binder.bind("subject", this.subject);
        EmailAccessPointDTO value = this.model.getValue();
        binder.update((ValueComposite)value);
        int selectedIndex = this.emailTemplateList.getSelectedIndex();
        DefaultListModel<String> emailTemplateListModel = new DefaultListModel<String>();
        for (String key : ((Map)value.messages().get()).keySet()) {
            emailTemplateListModel.addElement(key);
        }
        this.emailTemplateList.setModel(emailTemplateListModel);
        this.emailTemplateList.setSelectedIndex(selectedIndex);
    }

    @Action
    public Task changeSubject() {
        return new CommandTask(){

            @Override
            protected void command() throws Exception {
                EmailAccessPointView.this.model.changeSubject(EmailAccessPointView.this.subject.getText());
            }
        };
    }

    @Action
    public Task save() {
        final String template = this.emailTemplateText.getText();
        final String key = (String)this.emailTemplateList.getSelectedValue();
        return new CommandTask(){

            @Override
            protected void command() throws Exception {
                EmailAccessPointView.this.model.updateTemplate(key, template);
                ((Map)EmailAccessPointView.this.model.getValue().messages().get()).put(key, template);
            }
        };
    }

    public void notifyTransactions(Iterable<TransactionDomainEvents> transactions) {
        this.refresh();
    }
}

