/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.administration.surface;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import java.util.Collection;
import java.util.Observable;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.structure.Module;
import org.qi4j.api.value.ValueBuilder;
import org.qi4j.api.value.ValueComposite;
import org.restlet.data.Form;
import org.restlet.resource.ResourceException;
import se.streamsource.dci.restlet.client.CommandQueryClient;
import se.streamsource.dci.value.EntityValue;
import se.streamsource.dci.value.ResourceValue;
import se.streamsource.dci.value.link.LinkValue;
import se.streamsource.dci.value.link.LinksValue;
import se.streamsource.streamflow.api.administration.form.RequiredSignatureValue;
import se.streamsource.streamflow.api.administration.surface.AccessPointDTO;
import se.streamsource.streamflow.client.OperationException;
import se.streamsource.streamflow.client.ui.administration.surface.ReplacementSelectionFieldValuesModel;
import se.streamsource.streamflow.client.ui.workspace.WorkspaceResources;
import se.streamsource.streamflow.client.ui.workspace.cases.general.CaseLabelsModel;
import se.streamsource.streamflow.client.util.Refreshable;

public class AccessPointModel
extends Observable
implements Refreshable {
    CaseLabelsModel labelsModel;
    @Structure
    Module module;
    @Uses
    private CommandQueryClient client;
    private AccessPointDTO accessPoint;
    private ResourceValue resourceValue;

    public AccessPointModel(@Uses CommandQueryClient client, @Structure Module module) {
        this.client = client;
        this.labelsModel = (CaseLabelsModel)module.objectBuilderFactory().newObjectBuilder(CaseLabelsModel.class).use(new Object[]{client.getSubClient("labels")}).newInstance();
    }

    public AccessPointDTO getAccessPointValue() {
        return this.accessPoint;
    }

    @Override
    public void refresh() throws OperationException {
        this.resourceValue = this.client.query();
        this.accessPoint = (AccessPointDTO)((ValueComposite)this.resourceValue.index().get()).buildWith().prototype();
        this.setChanged();
        this.notifyObservers(this.resourceValue);
    }

    public Object getPossibleProjects() {
        BasicEventList list = new BasicEventList();
        LinksValue listValue = (LinksValue)this.client.query("possibleprojects", LinksValue.class);
        list.addAll((Collection)listValue.links().get());
        return list;
    }

    public void changeProject(LinkValue link) {
        this.client.postLink(link);
    }

    public EventList<LinkValue> getPossibleCaseTypes() {
        BasicEventList list = new BasicEventList();
        LinksValue listValue = (LinksValue)this.client.query("possiblecasetypes", LinksValue.class);
        list.addAll((Collection)listValue.links().get());
        return list;
    }

    public void changeCaseType(LinkValue link) {
        this.client.postLink(link);
    }

    public EventList<LinkValue> getPossibleForms() {
        try {
            BasicEventList list = new BasicEventList();
            LinksValue listValue = (LinksValue)this.client.query("possibleforms", LinksValue.class);
            list.addAll((Collection)listValue.links().get());
            return list;
        }
        catch (ResourceException e) {
            throw new OperationException(WorkspaceResources.could_not_refresh, (Throwable)e);
        }
    }

    public void changeForm(LinkValue link) {
        this.client.postLink(link);
    }

    public EventList<LinkValue> getPossibleLabels() {
        BasicEventList list = new BasicEventList();
        LinksValue listValue = (LinksValue)this.client.query("possiblelabels", LinksValue.class);
        list.addAll((Collection)listValue.links().get());
        return list;
    }

    public CaseLabelsModel getLabelsModel() {
        return this.labelsModel;
    }

    public EventList<LinkValue> getPossibleTemplates() {
        try {
            BasicEventList list = new BasicEventList();
            Form form = new Form();
            form.add("filteron", "pdf");
            LinksValue listValue = (LinksValue)this.client.query("possibleformtemplates", LinksValue.class, (Object)form);
            list.addAll((Collection)listValue.links().get());
            return list;
        }
        catch (ResourceException e) {
            throw new OperationException(WorkspaceResources.could_not_refresh, (Throwable)e);
        }
    }

    public void setTemplate(LinkValue link) {
        if (link != null) {
            this.client.postLink(link);
        } else {
            ValueBuilder builder = this.module.valueBuilderFactory().newValueBuilder(EntityValue.class);
            this.client.postCommand("setformtemplate", builder.newInstance());
        }
    }

    public void changeMailSelectionMessage(String message) {
        Form form = new Form();
        form.set("mailmessage", message);
        this.client.postCommand("changemailselectionmessage", (Object)form);
    }

    public void setSignActive1(boolean selected) {
        if (!((Boolean)((RequiredSignatureValue)this.accessPoint.primarysign().get()).active().get()).equals(selected)) {
            Form form = new Form();
            form.set("active", "" + selected);
            this.client.postCommand("updateprimarysignactive", (Object)form);
        }
    }

    public void setSignName1(String text) {
        if (!text.equals(((RequiredSignatureValue)this.accessPoint.primarysign().get()).name().get())) {
            Form form = new Form();
            form.set("name", text);
            this.client.postCommand("updateprimarysign", (Object)form);
        }
    }

    public void setSignDescription1(String text) {
        if (!text.equals(((RequiredSignatureValue)this.accessPoint.primarysign().get()).name().get())) {
            Form form = new Form();
            form.set("description", text);
            this.client.postCommand("updateprimarysign", (Object)form);
        }
    }

    public void setSignActive2(boolean selected) {
        if (!((Boolean)((RequiredSignatureValue)this.accessPoint.secondarysign().get()).active().get()).equals(selected)) {
            Form form = new Form();
            form.set("active", "" + selected);
            this.client.postCommand("updatesecondarysignactive", (Object)form);
        }
    }

    public void setSignName2(String text) {
        if (!text.equals(((RequiredSignatureValue)this.accessPoint.secondarysign().get()).name().get())) {
            Form form = new Form();
            form.set("name", text);
            this.client.postCommand("updatesecondarysign", (Object)form);
        }
    }

    public void setSignDescription2(String text) {
        if (!text.equals(((RequiredSignatureValue)this.accessPoint.secondarysign().get()).name().get())) {
            Form form = new Form();
            form.set("description", text);
            this.client.postCommand("updatesecondarysign", (Object)form);
        }
    }

    public void changeSecondForm(LinkValue selectedLink) {
        Form form = new Form();
        form.set("formid", (String)selectedLink.id().get());
        form.set("formdescription", (String)selectedLink.text().get());
        this.client.postCommand("updatesecondarysign", (Object)form);
    }

    public void setSecondMandatory(boolean selected) {
        if (!((Boolean)((RequiredSignatureValue)this.accessPoint.secondarysign().get()).mandatory().get()).equals(selected)) {
            Form form = new Form();
            form.set("mandatory", "" + selected);
            this.client.postCommand("updatesecondarysign", (Object)form);
        }
    }

    public void setQuestion(String text) {
        if (!text.equals(((RequiredSignatureValue)this.accessPoint.secondarysign().get()).question().get())) {
            Form form = new Form();
            form.set("question", text);
            this.client.postCommand("updatesecondarysign", (Object)form);
        }
    }

    public EventList<LinkValue> getPossibleSecondForms() {
        try {
            BasicEventList list = new BasicEventList();
            LinksValue listValue = (LinksValue)this.client.query("possiblesecondforms", LinksValue.class);
            list.addAll((Collection)listValue.links().get());
            return list;
        }
        catch (ResourceException e) {
            throw new OperationException(WorkspaceResources.could_not_refresh, (Throwable)e);
        }
    }

    public void changeSubject(String text) {
        Form form = new Form();
        form.set("subject", text);
        this.client.postCommand("changesubject", (Object)form.getWebRepresentation());
    }

    public void updateTemplate(String key, String template) {
        Form form = new Form();
        form.set("key", key);
        form.set("template", template);
        this.client.postCommand("changetemplate", (Object)form.getWebRepresentation());
    }

    public ReplacementSelectionFieldValuesModel getReplacementSelectionFieldValuesModel() {
        return (ReplacementSelectionFieldValuesModel)this.module.objectBuilderFactory().newObjectBuilder(ReplacementSelectionFieldValuesModel.class).use(new Object[]{this.client.getSubClient("replacementselectionfields")}).newInstance();
    }

    public void changeCookieExpirationHours(Integer hours) {
        if (!this.accessPoint.cookieExpirationHours().equals(hours)) {
            Form form = new Form();
            form.set("cookieexpirationhours", hours == null ? null : Integer.toString(hours));
            this.client.postCommand("changecookieexpirationhours", (Object)form);
        }
    }
}

