/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.administration.projectsettings;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Observable;
import java.util.Observer;
import javax.swing.ActionMap;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ApplicationContext;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.specification.Specification;
import org.qi4j.api.structure.Module;
import org.qi4j.api.util.Iterables;
import se.streamsource.dci.value.link.LinkValue;
import se.streamsource.dci.value.link.Links;
import se.streamsource.streamflow.api.administration.DueOnNotificationSettingsDTO;
import se.streamsource.streamflow.client.ui.administration.AdministrationResources;
import se.streamsource.streamflow.client.ui.administration.projectsettings.CaseDueOnNotificationModel;
import se.streamsource.streamflow.client.ui.administration.projectsettings.RecipientsView;
import se.streamsource.streamflow.client.util.ActionBinder;
import se.streamsource.streamflow.client.util.RefreshWhenShowing;
import se.streamsource.streamflow.client.util.dialog.DialogService;
import se.streamsource.streamflow.client.util.i18n;
import se.streamsource.streamflow.infrastructure.event.domain.TransactionDomainEvents;
import se.streamsource.streamflow.infrastructure.event.domain.source.TransactionListener;
import se.streamsource.streamflow.infrastructure.event.domain.source.helper.Events;

public class CaseDueOnNotificationView
extends JPanel
implements Observer,
TransactionListener {
    @Service
    DialogService dialogs;
    @Structure
    Module module;
    private CaseDueOnNotificationModel model;
    protected RecipientsView recipientsView;
    private JTextField threshold = new JTextField(2);
    private JCheckBox active = new JCheckBox("Aktiv");
    private DefaultFormBuilder builder;

    public CaseDueOnNotificationView(@Service ApplicationContext context, @Uses CaseDueOnNotificationModel model) {
        this.model = model;
        model.addObserver(this);
        this.threshold.setColumns(2);
        FormLayout layout = new FormLayout("150dlu, 2dlu, 50, 200", "pref, pref, pref");
        this.setLayout((LayoutManager)layout);
        this.setMaximumSize(new Dimension(Short.MAX_VALUE, 50));
        this.builder = new DefaultFormBuilder(layout, (JPanel)this);
        this.builder.add((Component)new JLabel(i18n.text(AdministrationResources.dueon_notification_threshold, new Object[0])), new CellConstraints(1, 1));
        this.builder.add((Component)this.threshold, new CellConstraints(3, 1));
        this.builder.add((Component)new JLabel(i18n.text(AdministrationResources.dueon_notification_active, new Object[0])), new CellConstraints(1, 2));
        this.builder.add((Component)this.active, new CellConstraints(3, 2, 2, 1));
        this.builder.add((Component)new JLabel(i18n.text(AdministrationResources.dueon_notification_additional_recipient, new Object[0])), new CellConstraints(1, 3, 1, 1, CellConstraints.LEFT, CellConstraints.TOP, new Insets(4, 0, 0, 0)));
        ApplicationActionMap am = context.getActionMap((Object)this);
        this.setActionMap((ActionMap)am);
        new ActionBinder((ActionMap)am).bind("changeThreshold", this.threshold);
        new ActionBinder((ActionMap)am).bind("activateNotifications", this.active);
        new RefreshWhenShowing(this, model);
    }

    @Override
    public void update(Observable o, Object arg) {
        DueOnNotificationSettingsDTO settings = (DueOnNotificationSettingsDTO)this.model.getIndex();
        if (settings == null) {
            this.active.setSelected(false);
            this.threshold.setText("0");
        } else {
            this.active.setSelected((Boolean)settings.active().get());
            this.threshold.setText(((Integer)settings.threshold().get()).toString());
        }
        if (this.recipientsView == null) {
            this.recipientsView = (RecipientsView)this.module.objectBuilderFactory().newObjectBuilder(RecipientsView.class).use(new Object[]{this.model.newResourceModel((LinkValue)Iterables.first((Iterable)Iterables.filter((Specification)Links.withRel((String)"recipients"), (Iterable)((Iterable)this.model.getResourceValue().resources().get()))))}).newInstance();
            this.builder.add((Component)this.recipientsView, new CellConstraints(3, 3, 2, 1));
        }
    }

    @Action
    public void changeThreshold() {
        this.model.changeThreshold(Integer.parseInt(this.threshold.getText()));
    }

    @Action
    public void activateNotifications() {
        this.model.activateNotifications(this.active.isSelected());
    }

    public void notifyTransactions(Iterable<TransactionDomainEvents> transactions) {
        if (Events.matches((Specification)Events.withNames((String[])new String[]{"changedDueOnNotifications"}), transactions)) {
            this.model.refresh();
        }
    }
}

