/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.administration.priorities;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Dimension;
import java.awt.LayoutManager;
import javax.swing.ActionMap;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.Task;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.specification.Specification;
import org.qi4j.api.structure.Module;
import org.qi4j.api.value.ValueComposite;
import se.streamsource.streamflow.client.ui.administration.AdministrationResources;
import se.streamsource.streamflow.client.ui.administration.priorities.PriorityModel;
import se.streamsource.streamflow.client.util.ActionBinder;
import se.streamsource.streamflow.client.util.BindingFormBuilder2;
import se.streamsource.streamflow.client.util.CommandTask;
import se.streamsource.streamflow.client.util.RefreshWhenShowing;
import se.streamsource.streamflow.client.util.Refreshable;
import se.streamsource.streamflow.client.util.StreamflowJXColorSelectionButton;
import se.streamsource.streamflow.client.util.ValueBinder;
import se.streamsource.streamflow.infrastructure.event.domain.TransactionDomainEvents;
import se.streamsource.streamflow.infrastructure.event.domain.source.helper.Events;

public class PriorityView
extends JPanel
implements Refreshable {
    private ValueBinder values;
    private ActionBinder actions;
    private DefaultFormBuilder formBuilder;
    private JTextField name;
    private StreamflowJXColorSelectionButton color;
    private PriorityModel model;
    private Module module;

    public PriorityView(@Service ApplicationContext context, @Uses PriorityModel model, @Structure Module module) {
        this.model = model;
        this.module = module;
        ApplicationActionMap am = context.getActionMap((Object)this);
        this.setActionMap((ActionMap)am);
        FormLayout layout = new FormLayout("70dlu, 2dlu, 200", "pref, pref");
        this.setLayout((LayoutManager)layout);
        this.formBuilder = new DefaultFormBuilder(layout, (JPanel)this);
        this.actions = new ActionBinder((ActionMap)am);
        this.values = (ValueBinder)module.objectBuilderFactory().newObject(ValueBinder.class);
        BindingFormBuilder2 binding = new BindingFormBuilder2(this.formBuilder, this.actions, this.values, context.getResourceMap(this.getClass()));
        this.name = new JTextField();
        binding.appendWithLabel(AdministrationResources.name_label, this.name, "text", "changeDescription", new Object[0]);
        this.color = new StreamflowJXColorSelectionButton();
        binding.appendWithLabel(AdministrationResources.name_show_color, this.color, "color", "changeColor", new Object[0]);
        this.color.setPreferredSize(new Dimension(190, 25));
        new RefreshWhenShowing(this, this);
    }

    @Action(block=Task.BlockingScope.COMPONENT)
    public Task changeColor() {
        return new CommandTask(){

            @Override
            protected void command() throws Exception {
                PriorityView.this.model.changeColor("" + PriorityView.this.color.getBackground().getRGB());
            }
        };
    }

    @Action(block=Task.BlockingScope.COMPONENT)
    public Task changeDescription() {
        return new CommandTask(){

            @Override
            protected void command() throws Exception {
                PriorityView.this.model.changeDescription(PriorityView.this.name.getText());
            }
        };
    }

    @Override
    public void refresh() {
        this.model.refresh();
        this.values.update((ValueComposite)this.model.getIndex());
    }

    public void notifyTransactions(Iterable<TransactionDomainEvents> transactions) {
        if (Events.matches((Specification)Events.withNames((String[])new String[]{"changedColor", "changedDescription"}), transactions)) {
            this.refresh();
        }
    }
}

