/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.administration.policy;

import ca.odell.glazedlists.swing.EventListModel;
import com.jgoodies.forms.factories.Borders;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Set;
import javax.swing.ActionMap;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.Task;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.structure.Module;
import org.qi4j.api.util.Iterables;
import se.streamsource.dci.value.link.LinkValue;
import se.streamsource.streamflow.client.StreamflowResources;
import se.streamsource.streamflow.client.ui.SelectUsersAndGroupsDialog;
import se.streamsource.streamflow.client.ui.administration.AdministrationResources;
import se.streamsource.streamflow.client.ui.administration.UsersAndGroupsModel;
import se.streamsource.streamflow.client.ui.administration.policy.AdministratorsModel;
import se.streamsource.streamflow.client.util.CommandTask;
import se.streamsource.streamflow.client.util.LinkListCellRenderer;
import se.streamsource.streamflow.client.util.RefreshWhenShowing;
import se.streamsource.streamflow.client.util.SelectionActionEnabler;
import se.streamsource.streamflow.client.util.StreamflowButton;
import se.streamsource.streamflow.client.util.dialog.ConfirmationDialog;
import se.streamsource.streamflow.client.util.dialog.DialogService;
import se.streamsource.streamflow.client.util.i18n;
import se.streamsource.streamflow.infrastructure.event.domain.TransactionDomainEvents;
import se.streamsource.streamflow.infrastructure.event.domain.source.TransactionListener;

public class AdministratorsView
extends JPanel
implements TransactionListener {
    AdministratorsModel model;
    @Structure
    Module module;
    @Service
    DialogService dialogs;
    private UsersAndGroupsModel usersAndGroupsModel;
    public JList administratorList;

    public AdministratorsView(@Service ApplicationContext context, @Uses AdministratorsModel model) {
        super(new BorderLayout());
        this.model = model;
        this.setBorder(Borders.createEmptyBorder((String)"2dlu, 2dlu, 2dlu, 2dlu"));
        this.usersAndGroupsModel = model.newUsersAndGroupsModel();
        this.setActionMap((ActionMap)context.getActionMap((Object)this));
        this.administratorList = new JList(new EventListModel(model.getList()));
        this.administratorList.setCellRenderer(new LinkListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value instanceof LinkValue) {
                    Component component = super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                    component.setEnabled(!"inherited".equals(((LinkValue)value).rel().get()));
                    return component;
                }
                return super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            }
        });
        this.administratorList.getSelectionModel().addListSelectionListener(new SelectionActionEnabler(new javax.swing.Action[]{this.getActionMap().get("remove")}){

            @Override
            public boolean isSelectedValueValid(javax.swing.Action action) {
                return !"inherited".equals(((LinkValue)AdministratorsView.this.administratorList.getSelectedValue()).rel().get());
            }
        });
        this.add((Component)new JScrollPane(this.administratorList), "Center");
        JPanel toolbar = new JPanel();
        toolbar.add(new StreamflowButton(this.getActionMap().get("add")));
        toolbar.add(new StreamflowButton(this.getActionMap().get("remove")));
        this.add((Component)toolbar, "South");
        new RefreshWhenShowing(this, model);
    }

    @Action
    public Task add() {
        SelectUsersAndGroupsDialog dialog = (SelectUsersAndGroupsDialog)this.module.objectBuilderFactory().newObjectBuilder(SelectUsersAndGroupsDialog.class).use(new Object[]{this.usersAndGroupsModel}).newInstance();
        this.dialogs.showOkCancelHelpDialog(this, dialog, i18n.text(AdministrationResources.add_user_or_group_title, new Object[0]));
        final Set<LinkValue> linkValueSet = dialog.getSelectedEntities();
        if (!linkValueSet.isEmpty()) {
            return new CommandTask(){

                @Override
                public void command() throws Exception {
                    for (LinkValue identity : linkValueSet) {
                        AdministratorsView.this.model.addAdministrator(identity);
                    }
                }
            };
        }
        return null;
    }

    @Action
    public Task remove() {
        final Iterable selected = Iterables.iterable((Object[])this.administratorList.getSelectedValues());
        ConfirmationDialog dialog = (ConfirmationDialog)this.module.objectBuilderFactory().newObject(ConfirmationDialog.class);
        dialog.setRemovalMessage(i18n.text(AdministrationResources.remove_user_or_group, new Object[0]));
        this.dialogs.showOkCancelHelpDialog(this, dialog, i18n.text(StreamflowResources.confirmation, new Object[0]));
        if (dialog.isConfirmed()) {
            return new CommandTask(){

                @Override
                public void command() throws Exception {
                    for (LinkValue linkValue : selected) {
                        AdministratorsView.this.model.remove(linkValue);
                    }
                }
            };
        }
        return null;
    }

    public void notifyTransactions(Iterable<TransactionDomainEvents> transactions) {
        this.model.notifyTransactions(transactions);
    }
}

