/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.administration.forms.definition;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.swing.EventListModel;
import com.jgoodies.forms.factories.Borders;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.Task;
import org.jdesktop.swingx.JXList;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.structure.Module;
import se.streamsource.dci.value.link.LinkValue;
import se.streamsource.streamflow.client.StreamflowResources;
import se.streamsource.streamflow.client.ui.administration.AdministrationResources;
import se.streamsource.streamflow.client.ui.administration.forms.definition.VisibilityRuleValuesModel;
import se.streamsource.streamflow.client.ui.workspace.WorkspaceResources;
import se.streamsource.streamflow.client.util.CommandTask;
import se.streamsource.streamflow.client.util.SelectionActionEnabler;
import se.streamsource.streamflow.client.util.StreamflowButton;
import se.streamsource.streamflow.client.util.dialog.ConfirmationDialog;
import se.streamsource.streamflow.client.util.dialog.DialogService;
import se.streamsource.streamflow.client.util.dialog.NameDialog;
import se.streamsource.streamflow.client.util.dialog.SelectLinksDialog;
import se.streamsource.streamflow.client.util.i18n;
import se.streamsource.streamflow.infrastructure.event.domain.TransactionDomainEvents;
import se.streamsource.streamflow.infrastructure.event.domain.source.TransactionListener;
import se.streamsource.streamflow.util.Strings;

public class VisibilityRuleValuesView
extends JPanel
implements TransactionListener {
    private JXList elementList;
    private VisibilityRuleValuesModel model;
    @Service
    DialogService dialogs;
    @Structure
    Module module;

    public VisibilityRuleValuesView(@Service ApplicationContext context, @Uses VisibilityRuleValuesModel model) {
        super(new BorderLayout());
        this.model = model;
        this.setBorder(Borders.createEmptyBorder((String)"4dlu, 4dlu, 4dlu, 4dlu"));
        JScrollPane scrollPanel = new JScrollPane();
        ApplicationActionMap am = context.getActionMap((Object)this);
        JPanel toolbar = new JPanel();
        toolbar.add(new StreamflowButton(am.get("add")));
        toolbar.add(new StreamflowButton(am.get("remove")));
        toolbar.add(new StreamflowButton(am.get("rename")));
        model.refresh();
        this.elementList = new JXList((ListModel)new EventListModel(model.getEventList()));
        this.elementList.setCellRenderer((ListCellRenderer)new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList jList, Object o, int i, boolean b, boolean b1) {
                if ("".equals(o)) {
                    Component cell = super.getListCellRendererComponent((JList<?>)jList, i18n.text(WorkspaceResources.name_label, new Object[0]), i, b, b1);
                    cell.setForeground(Color.GRAY);
                    return cell;
                }
                return super.getListCellRendererComponent((JList<?>)jList, o, i, b, b1);
            }
        });
        scrollPanel.setViewportView((Component)this.elementList);
        this.add((Component)scrollPanel, "Center");
        this.add((Component)toolbar, "South");
        this.elementList.getSelectionModel().addListSelectionListener(new SelectionActionEnabler(am.get("remove")));
        this.elementList.getSelectionModel().addListSelectionListener(new SelectionActionEnabler(am.get("rename")));
        this.elementList.setSelectionMode(0);
    }

    @Action
    public Task add() {
        EventList<LinkValue> linkValues = this.model.possiblePredefinedRuleValues();
        if (linkValues.isEmpty()) {
            final NameDialog dialog = (NameDialog)this.module.objectBuilderFactory().newObject(NameDialog.class);
            this.dialogs.showOkCancelHelpDialog(this, dialog, i18n.text(AdministrationResources.name_label, new Object[0]));
            if (!Strings.empty((String)dialog.name())) {
                if (dialog.name().contains("[") || dialog.name().contains("]")) {
                    this.dialogs.showOkDialog(this, new JLabel(i18n.text(AdministrationResources.no_such_character, new Object[0])), i18n.text(AdministrationResources.illegal_name, new Object[0]));
                    return null;
                }
                return new CommandTask(){

                    @Override
                    public void command() throws Exception {
                        VisibilityRuleValuesView.this.model.addElement(dialog.name());
                    }
                };
            }
            return null;
        }
        final SelectLinksDialog dialog = (SelectLinksDialog)this.module.objectBuilderFactory().newObjectBuilder(SelectLinksDialog.class).use(new Object[]{linkValues}).newInstance();
        this.dialogs.showOkCancelHelpDialog(this, dialog, i18n.text(AdministrationResources.name_label, new Object[0]));
        if (dialog.getSelectedLinks() != null) {
            return new CommandTask(){

                @Override
                public void command() throws Exception {
                    VisibilityRuleValuesView.this.model.addElements(dialog.getSelectedLinks());
                }
            };
        }
        return null;
    }

    @Action
    public Task remove() {
        final int index = this.elementList.getSelectedIndex();
        ConfirmationDialog dialog = (ConfirmationDialog)this.module.objectBuilderFactory().newObject(ConfirmationDialog.class);
        dialog.setRemovalMessage(this.elementList.getStringAt(index));
        this.dialogs.showOkCancelHelpDialog(this, dialog, i18n.text(StreamflowResources.confirmation, new Object[0]));
        if (index != -1 && dialog.isConfirmed()) {
            return new CommandTask(){

                @Override
                public void command() throws Exception {
                    VisibilityRuleValuesView.this.model.removeElement(index);
                }
            };
        }
        return null;
    }

    @Action
    public Task rename() {
        final NameDialog dialog = (NameDialog)this.module.objectBuilderFactory().newObject(NameDialog.class);
        this.dialogs.showOkCancelHelpDialog(this, dialog, i18n.text(AdministrationResources.rename, new Object[0]));
        if (!Strings.empty((String)dialog.name())) {
            return new CommandTask(){

                @Override
                public void command() throws Exception {
                    VisibilityRuleValuesView.this.model.changeElementName(dialog.name(), VisibilityRuleValuesView.this.elementList.getSelectedIndex());
                }
            };
        }
        return null;
    }

    public void notifyTransactions(Iterable<TransactionDomainEvents> transactions) {
        this.model.refresh();
    }
}

