/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.administration.forms.definition;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.swing.EventComboBoxModel;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ActionMap;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.Task;
import org.jdesktop.swingx.JXRadioGroup;
import org.jdesktop.swingx.renderer.DefaultListRenderer;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.specification.Specification;
import org.qi4j.api.structure.Module;
import org.qi4j.api.value.ValueComposite;
import se.streamsource.dci.value.link.LinkValue;
import se.streamsource.streamflow.api.administration.form.AttachmentFieldValue;
import se.streamsource.streamflow.api.administration.form.CheckboxesFieldValue;
import se.streamsource.streamflow.api.administration.form.ComboBoxFieldValue;
import se.streamsource.streamflow.api.administration.form.CommentFieldValue;
import se.streamsource.streamflow.api.administration.form.DateFieldValue;
import se.streamsource.streamflow.api.administration.form.FieldDefinitionAdminValue;
import se.streamsource.streamflow.api.administration.form.FieldGroupFieldValue;
import se.streamsource.streamflow.api.administration.form.FieldValue;
import se.streamsource.streamflow.api.administration.form.GeoLocationFieldValue;
import se.streamsource.streamflow.api.administration.form.ListBoxFieldValue;
import se.streamsource.streamflow.api.administration.form.NumberFieldValue;
import se.streamsource.streamflow.api.administration.form.OpenSelectionFieldValue;
import se.streamsource.streamflow.api.administration.form.OptionButtonsFieldValue;
import se.streamsource.streamflow.api.administration.form.TextAreaFieldValue;
import se.streamsource.streamflow.api.administration.form.TextFieldValue;
import se.streamsource.streamflow.api.administration.form.VisibilityRuleCondition;
import se.streamsource.streamflow.api.administration.form.VisibilityRuleDefinitionValue;
import se.streamsource.streamflow.client.ui.administration.AdministrationResources;
import se.streamsource.streamflow.client.ui.administration.forms.definition.FieldEditorAttachmentFieldValueView;
import se.streamsource.streamflow.client.ui.administration.forms.definition.FieldEditorCheckboxesFieldValueView;
import se.streamsource.streamflow.client.ui.administration.forms.definition.FieldEditorComboBoxFieldValueView;
import se.streamsource.streamflow.client.ui.administration.forms.definition.FieldEditorCommentFieldValueView;
import se.streamsource.streamflow.client.ui.administration.forms.definition.FieldEditorDateFieldValueView;
import se.streamsource.streamflow.client.ui.administration.forms.definition.FieldEditorFieldGroupValueView;
import se.streamsource.streamflow.client.ui.administration.forms.definition.FieldEditorGeoLocationFieldValueView;
import se.streamsource.streamflow.client.ui.administration.forms.definition.FieldEditorListBoxFieldValueView;
import se.streamsource.streamflow.client.ui.administration.forms.definition.FieldEditorNumberFieldValueView;
import se.streamsource.streamflow.client.ui.administration.forms.definition.FieldEditorOpenSelectionFieldValueView;
import se.streamsource.streamflow.client.ui.administration.forms.definition.FieldEditorOptionButtonsFieldValueView;
import se.streamsource.streamflow.client.ui.administration.forms.definition.FieldEditorTextAreaFieldValueView;
import se.streamsource.streamflow.client.ui.administration.forms.definition.FieldEditorTextFieldValueView;
import se.streamsource.streamflow.client.ui.administration.forms.definition.FieldValueEditModel;
import se.streamsource.streamflow.client.ui.administration.forms.definition.VisibilityRuleValuesView;
import se.streamsource.streamflow.client.util.ActionBinder;
import se.streamsource.streamflow.client.util.CommandTask;
import se.streamsource.streamflow.client.util.LinkListCellRenderer;
import se.streamsource.streamflow.client.util.RefreshComponents;
import se.streamsource.streamflow.client.util.RefreshWhenShowing;
import se.streamsource.streamflow.client.util.Refreshable;
import se.streamsource.streamflow.client.util.ValueBinder;
import se.streamsource.streamflow.client.util.i18n;
import se.streamsource.streamflow.infrastructure.event.domain.TransactionDomainEvents;
import se.streamsource.streamflow.infrastructure.event.domain.source.TransactionListener;
import se.streamsource.streamflow.infrastructure.event.domain.source.helper.Events;

public class FieldEditView
extends JPanel
implements Refreshable,
TransactionListener {
    private static final Map<Class<? extends FieldValue>, Class<? extends JComponent>> editors = new HashMap<Class<? extends FieldValue>, Class<? extends JComponent>>();
    private FieldValueEditModel model;
    private final Module module;
    private ValueBinder valueBinder;
    private ActionBinder actionBinder;
    private RefreshComponents refreshComponents;
    private ActionMap am;
    private JPanel rulePanel;
    private JPanel centerPanel;
    private JComboBox ruleFieldIdCombo = new JComboBox();
    private JComboBox ruleConditionCombo = new JComboBox();
    private JRadioButton visibleWhenTrue;
    private JRadioButton visibleWhenFalse;

    public FieldEditView(@Service ApplicationContext context, @Uses FieldValueEditModel model, @Structure Module module) {
        super(new BorderLayout());
        this.module = module;
        this.model = model;
        this.refreshComponents = new RefreshComponents();
        this.am = context.getActionMap((Object)this);
        this.valueBinder = (ValueBinder)module.objectBuilderFactory().newObject(ValueBinder.class);
        this.actionBinder = (ActionBinder)module.objectBuilderFactory().newObjectBuilder(ActionBinder.class).use(new Object[]{context.getActionMap((Object)this)}).newInstance();
        this.actionBinder.setResourceMap(context.getResourceMap(this.getClass()));
        this.centerPanel = new JPanel(new BorderLayout());
        this.add((Component)this.centerPanel, "Center");
        this.rulePanel = this.createVisibilityRulePanel();
        this.add((Component)this.rulePanel, "South");
        this.refreshComponents.visibleOn("possiblerulefields", this.rulePanel);
        new RefreshWhenShowing(this, this);
    }

    @Override
    public void refresh() {
        this.model.refresh();
        FieldDefinitionAdminValue fieldDefinitionAdminValue = (FieldDefinitionAdminValue)this.model.getIndex();
        FieldValue value = (FieldValue)fieldDefinitionAdminValue.fieldValue().get();
        Class<?> fieldValueType = value.getClass().getInterfaces()[0];
        this.centerPanel.removeAll();
        this.centerPanel.add((Component)this.module.objectBuilderFactory().newObjectBuilder(editors.get(fieldValueType)).use(new Object[]{this.model}).newInstance(), "Center");
        this.valueBinder.update((ValueComposite)((FieldDefinitionAdminValue)this.model.getIndex()).rule().get());
        if (this.model.query("possiblerulefields") != null) {
            EventList<LinkValue> eventList = this.model.possibleRuleFields();
            this.ruleFieldIdCombo.setModel(new EventComboBoxModel(eventList));
            this.ruleFieldIdCombo.setSelectedItem(this.findLinkValueWithId(eventList, (String)((VisibilityRuleDefinitionValue)((FieldDefinitionAdminValue)this.model.getIndex()).rule().get()).field().get()));
            EventList<LinkValue> eventList2 = this.model.possibleRuleConditions();
            this.ruleConditionCombo.setModel(new EventComboBoxModel(eventList2));
            this.ruleConditionCombo.setSelectedItem(this.findLinkValueWithId(eventList2, ((VisibilityRuleCondition)((VisibilityRuleDefinitionValue)((FieldDefinitionAdminValue)this.model.getIndex()).rule().get()).condition().get()).name()));
            if (((Boolean)((VisibilityRuleDefinitionValue)((FieldDefinitionAdminValue)this.model.getIndex()).rule().get()).visibleWhen().get()).booleanValue()) {
                this.visibleWhenFalse.setSelected(false);
                this.visibleWhenTrue.setSelected(true);
            } else {
                this.visibleWhenFalse.setSelected(true);
                this.visibleWhenTrue.setSelected(false);
            }
        }
        this.refreshComponents.refresh(this.model.getResourceValue());
    }

    private JPanel createVisibilityRulePanel() {
        this.rulePanel = new JPanel();
        FormLayout ruleFormLayout = new FormLayout("45dlu, 5dlu, 150dlu, 5dlu, 45dlu, 5dlu, 150dlu:grow", "pref, pref, pref, pref:grow");
        DefaultFormBuilder ruleFormBuilder = new DefaultFormBuilder(ruleFormLayout, this.rulePanel);
        ruleFormBuilder.addSeparator(i18n.text(AdministrationResources.visibility_rule, new Object[0]));
        ruleFormBuilder.setBorder(Borders.createEmptyBorder((String)"4dlu, 4dlu, 4dlu, 4dlu"));
        ruleFormBuilder.nextLine();
        ruleFormBuilder.add((Component)new JLabel(i18n.text(AdministrationResources.rule_field_id, new Object[0])));
        ruleFormBuilder.nextColumn(2);
        ruleFormBuilder.add((Component)this.valueBinder.bind("fieldId", this.actionBinder.bind("changeRuleFieldId", this.ruleFieldIdCombo)));
        this.ruleFieldIdCombo.setRenderer(new LinkListCellRenderer());
        ruleFormBuilder.nextColumn(2);
        ruleFormBuilder.add((Component)new JLabel(i18n.text(AdministrationResources.rule_values, new Object[0])));
        ruleFormBuilder.add((Component)this.module.objectBuilderFactory().newObjectBuilder(VisibilityRuleValuesView.class).use(new Object[]{this.model.newVisibilityRuleValuesModel()}).newInstance(), new CellConstraints(7, 2, 1, 3, CellConstraints.FILL, CellConstraints.FILL));
        ruleFormBuilder.nextLine();
        ruleFormBuilder.add((Component)new JLabel(i18n.text(AdministrationResources.rule_condition, new Object[0])));
        ruleFormBuilder.nextColumn(2);
        ruleFormBuilder.add((Component)this.valueBinder.bind("condition", this.actionBinder.bind("changeRuleCondition", this.ruleConditionCombo)));
        this.ruleConditionCombo.setRenderer(new DefaultListRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value instanceof LinkValue) {
                    LinkValue itemValue = (LinkValue)value;
                    String val = itemValue == null ? "" : i18n.text((Enum)VisibilityRuleCondition.valueOf((String)((String)itemValue.text().get())), new Object[0]);
                    return super.getListCellRendererComponent(list, (Object)val, index, isSelected, cellHasFocus);
                }
                return super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
            }
        });
        ruleFormBuilder.add((Component)new JLabel(i18n.text(AdministrationResources.rule_visible_when, new Object[0])), new CellConstraints(1, 4, 1, 1, CellConstraints.FILL, CellConstraints.TOP));
        javax.swing.Action visibilityWhenToTrueAction = this.am.get("changeVisibleWhenToTrue");
        javax.swing.Action visibilityWhenToFalseAction = this.am.get("changeVisibleWhenToFalse");
        JXRadioGroup buttonGroup = new JXRadioGroup();
        buttonGroup.setLayoutAxis(2);
        this.visibleWhenTrue = new JRadioButton(visibilityWhenToTrueAction);
        this.visibleWhenFalse = new JRadioButton(visibilityWhenToFalseAction);
        buttonGroup.add((Component)this.visibleWhenTrue);
        buttonGroup.add((Component)this.visibleWhenFalse);
        ruleFormBuilder.add((Component)buttonGroup, new CellConstraints(3, 4, 1, 1, CellConstraints.FILL, CellConstraints.TOP));
        return this.rulePanel;
    }

    @Action(block=Task.BlockingScope.COMPONENT)
    public Task changeRuleFieldId() {
        return new CommandTask(){

            @Override
            protected void command() throws Exception {
                FieldEditView.this.model.changeRuleFieldId((LinkValue)FieldEditView.this.ruleFieldIdCombo.getSelectedItem());
            }
        };
    }

    @Action(block=Task.BlockingScope.COMPONENT)
    public Task changeRuleCondition() {
        return new CommandTask(){

            @Override
            protected void command() throws Exception {
                FieldEditView.this.model.changeRuleCondition((LinkValue)FieldEditView.this.ruleConditionCombo.getSelectedItem());
            }
        };
    }

    @Action
    public Task changeVisibleWhenToTrue() {
        return new CommandTask(){

            @Override
            protected void command() throws Exception {
                FieldEditView.this.model.changeRuleVisibleWhen(true);
            }
        };
    }

    @Action
    public Task changeVisibleWhenToFalse() {
        return new CommandTask(){

            @Override
            protected void command() throws Exception {
                FieldEditView.this.model.changeRuleVisibleWhen(false);
            }
        };
    }

    private LinkValue findLinkValueWithId(EventList<LinkValue> list, String id) {
        for (LinkValue link : list) {
            if (!((String)link.id().get()).equals(id)) continue;
            return link;
        }
        return null;
    }

    public void notifyTransactions(Iterable<TransactionDomainEvents> transactions) {
        if (Events.matches((Specification)Events.withNames((String[])new String[]{"changedRule"}), transactions)) {
            this.refresh();
        }
    }

    static {
        editors.put(CheckboxesFieldValue.class, FieldEditorCheckboxesFieldValueView.class);
        editors.put(ComboBoxFieldValue.class, FieldEditorComboBoxFieldValueView.class);
        editors.put(CommentFieldValue.class, FieldEditorCommentFieldValueView.class);
        editors.put(DateFieldValue.class, FieldEditorDateFieldValueView.class);
        editors.put(ListBoxFieldValue.class, FieldEditorListBoxFieldValueView.class);
        editors.put(NumberFieldValue.class, FieldEditorNumberFieldValueView.class);
        editors.put(OptionButtonsFieldValue.class, FieldEditorOptionButtonsFieldValueView.class);
        editors.put(OpenSelectionFieldValue.class, FieldEditorOpenSelectionFieldValueView.class);
        editors.put(TextAreaFieldValue.class, FieldEditorTextAreaFieldValueView.class);
        editors.put(TextFieldValue.class, FieldEditorTextFieldValueView.class);
        editors.put(AttachmentFieldValue.class, FieldEditorAttachmentFieldValueView.class);
        editors.put(FieldGroupFieldValue.class, FieldEditorFieldGroupValueView.class);
        editors.put(GeoLocationFieldValue.class, FieldEditorGeoLocationFieldValueView.class);
    }
}

