/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.administration.forms;

import ca.odell.glazedlists.swing.EventListModel;
import com.jgoodies.forms.factories.Borders;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.ActionMap;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.Task;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.structure.Module;
import org.qi4j.api.util.Iterables;
import se.streamsource.dci.value.link.LinkValue;
import se.streamsource.streamflow.client.ui.administration.AdministrationResources;
import se.streamsource.streamflow.client.ui.administration.forms.SelectedFormsModel;
import se.streamsource.streamflow.client.util.CommandTask;
import se.streamsource.streamflow.client.util.LinkListCellRenderer;
import se.streamsource.streamflow.client.util.RefreshWhenShowing;
import se.streamsource.streamflow.client.util.SelectionActionEnabler;
import se.streamsource.streamflow.client.util.StreamflowButton;
import se.streamsource.streamflow.client.util.dialog.DialogService;
import se.streamsource.streamflow.client.util.dialog.SelectLinkDialog;
import se.streamsource.streamflow.client.util.i18n;
import se.streamsource.streamflow.infrastructure.event.domain.TransactionDomainEvents;
import se.streamsource.streamflow.infrastructure.event.domain.source.TransactionListener;

public class SelectedFormsView
extends JPanel
implements TransactionListener {
    @Service
    DialogService dialogs;
    @Structure
    Module module;
    public JList labelList;
    private SelectedFormsModel model;

    public SelectedFormsView(@Service ApplicationContext context, @Uses SelectedFormsModel model) {
        super(new BorderLayout());
        this.model = model;
        this.setBorder(Borders.createEmptyBorder((String)"2dlu, 2dlu, 2dlu, 2dlu"));
        ApplicationActionMap am = context.getActionMap((Object)this);
        this.setActionMap((ActionMap)am);
        this.labelList = new JList(new EventListModel(model.getList()));
        this.labelList.setCellRenderer(new LinkListCellRenderer());
        this.add((Component)new JScrollPane(this.labelList), "Center");
        JPanel toolbar = new JPanel();
        toolbar.add(new StreamflowButton(am.get("add")));
        toolbar.add(new StreamflowButton(am.get("remove")));
        this.add((Component)toolbar, "South");
        this.labelList.getSelectionModel().addListSelectionListener(new SelectionActionEnabler(am.get("remove")));
        new RefreshWhenShowing(this, model);
    }

    @Action
    public Task add() {
        final SelectLinkDialog dialog = (SelectLinkDialog)this.module.objectBuilderFactory().newObjectBuilder(SelectLinkDialog.class).use(new Object[]{this.model.getPossible()}).newInstance();
        dialog.setSelectionMode(2);
        this.dialogs.showOkCancelHelpDialog(this, dialog, i18n.text(AdministrationResources.choose_form_title, new Object[0]));
        if (dialog.getSelectedLinks() != null) {
            return new CommandTask(){

                @Override
                public void command() throws Exception {
                    SelectedFormsView.this.model.add(dialog.getSelectedLinks());
                }
            };
        }
        return null;
    }

    @Action
    public Task remove() {
        final Iterable selected = Iterables.iterable((Object[])this.labelList.getSelectedValues());
        return new CommandTask(){

            @Override
            public void command() throws Exception {
                for (LinkValue linkValue : selected) {
                    SelectedFormsView.this.model.remove(linkValue);
                }
            }
        };
    }

    public void notifyTransactions(Iterable<TransactionDomainEvents> transactions) {
        this.model.notifyTransactions(transactions);
    }
}

