/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.account;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import javax.jnlp.BasicService;
import javax.jnlp.ServiceManager;
import javax.jnlp.UnavailableServiceException;
import javax.swing.ActionMap;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.swingx.util.WindowUtils;
import org.qi4j.api.constraint.ConstraintViolationException;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.structure.Module;
import org.qi4j.api.value.ValueBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.streamsource.streamflow.client.domain.individual.AccountSettingsValue;
import se.streamsource.streamflow.client.ui.administration.AdministrationResources;
import se.streamsource.streamflow.client.util.BindingFormBuilder;
import se.streamsource.streamflow.client.util.i18n;

public class CreateAccountDialog
extends JPanel {
    final Logger logger = LoggerFactory.getLogger((String)this.getClass().getName());
    @Structure
    Module module;
    private JTextField nameField;
    private JTextField serverField;
    private JTextField usernameField;
    private JPasswordField passwordField;
    private AccountSettingsValue settings;

    public CreateAccountDialog(@Service ApplicationContext context) {
        this.setActionMap((ActionMap)context.getActionMap((Object)this));
        FormLayout layout = new FormLayout("50dlu, 5dlu, 175dlu", "pref, pref, pref, pref");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout, (JPanel)this);
        this.nameField = (JTextField)BindingFormBuilder.Fields.TEXTFIELD.newField();
        this.serverField = (JTextField)BindingFormBuilder.Fields.TEXTFIELD.newField();
        String defaultServer = "";
        try {
            BasicService bs = (BasicService)ServiceManager.lookup((String)"javax.jnlp.BasicService");
            String host = bs.getCodeBase().getHost();
            int portInt = bs.getCodeBase().getPort();
            String port = portInt != -1 ? ":" + bs.getCodeBase().getPort() : "";
            defaultServer = host + port;
        }
        catch (UnavailableServiceException e) {
            this.logger.info("Streamflow Client not started via Java Web Start - cannot determine default host!");
        }
        if (!"".equals(defaultServer)) {
            this.serverField.setText("http://" + defaultServer + "/streamflow");
        }
        this.usernameField = (JTextField)BindingFormBuilder.Fields.TEXTFIELD.newField();
        this.passwordField = (JPasswordField)BindingFormBuilder.Fields.PASSWORD.newField();
        builder.add((Component)new JLabel(i18n.text(AdministrationResources.create_account_name, new Object[0])));
        builder.nextColumn(2);
        builder.add((Component)this.nameField);
        builder.nextLine();
        builder.add((Component)new JLabel(i18n.text(AdministrationResources.create_account_server, new Object[0])));
        builder.nextColumn(2);
        builder.add((Component)this.serverField);
        builder.nextLine();
        builder.add((Component)new JLabel(i18n.text(AdministrationResources.create_account_username, new Object[0])));
        builder.nextColumn(2);
        builder.add((Component)this.usernameField);
        builder.nextLine();
        builder.add((Component)new JLabel(i18n.text(AdministrationResources.create_account_password, new Object[0])));
        builder.nextColumn(2);
        builder.add((Component)this.passwordField);
        builder.nextLine();
    }

    @Action
    public void execute() {
        try {
            ValueBuilder accountBuilder = this.module.valueBuilderFactory().newValueBuilder(AccountSettingsValue.class);
            ((AccountSettingsValue)accountBuilder.prototype()).name().set((Object)this.nameField.getText());
            ((AccountSettingsValue)accountBuilder.prototype()).server().set((Object)this.serverField.getText());
            ((AccountSettingsValue)accountBuilder.prototype()).userName().set((Object)this.usernameField.getText());
            ((AccountSettingsValue)accountBuilder.prototype()).password().set((Object)String.valueOf(this.passwordField.getPassword()));
            this.settings = (AccountSettingsValue)accountBuilder.newInstance();
        }
        catch (ConstraintViolationException cve) {
            JOptionPane.showMessageDialog(new JFrame(), cve.getMessage(), "Dialog", 0);
            return;
        }
        WindowUtils.findWindow((Component)this).dispose();
    }

    @Action
    public void close() {
        WindowUtils.findWindow((Component)this).dispose();
    }

    public AccountSettingsValue settings() {
        return this.settings;
    }
}

