/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui;

import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import org.jdesktop.swingx.renderer.ComponentProvider;
import org.jdesktop.swingx.renderer.DefaultListRenderer;
import org.jdesktop.swingx.renderer.IconValue;
import org.jdesktop.swingx.renderer.StringValue;
import org.jdesktop.swingx.renderer.WrappingProvider;
import se.streamsource.streamflow.client.Icons;
import se.streamsource.streamflow.client.ui.ContextItem;
import se.streamsource.streamflow.client.util.i18n;

public class ContextItemListRenderer
extends DefaultListRenderer {
    public ContextItemListRenderer() {
        super((ComponentProvider)new WrappingProvider(new IconValue(){

            public Icon getIcon(Object o) {
                ContextItem item = (ContextItem)o;
                return i18n.icon(Icons.valueOf(item.getRelation()), 16);
            }
        }, new StringValue(){

            public String getString(Object o) {
                ContextItem item = (ContextItem)o;
                String str = item.getName();
                if (item.getCount() > 0L) {
                    str = str + " (" + item.getCount() + ")";
                }
                return str;
            }
        }, false));
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JComponent component = (JComponent)super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        ContextItem contextItem = (ContextItem)value;
        if (contextItem.getRelation().equals("perspective")) {
            component.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 0));
        } else {
            component.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        }
        return component;
    }
}

