/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.domain.individual;

import org.qi4j.api.entity.Aggregated;
import org.qi4j.api.entity.EntityBuilder;
import org.qi4j.api.entity.association.ManyAssociation;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.This;
import org.qi4j.api.mixin.Mixins;
import org.qi4j.api.structure.Module;
import se.streamsource.streamflow.client.domain.individual.Account;
import se.streamsource.streamflow.client.domain.individual.AccountSettingsValue;
import se.streamsource.streamflow.client.domain.individual.AccountVisitor;

@Mixins(value={Mixin.class})
public interface Accounts {
    public Account newAccount(AccountSettingsValue var1);

    public void removeAccount(Account var1);

    public void visitAccounts(AccountVisitor var1);

    public static class Mixin
    implements Accounts {
        @This
        Data state;
        @Structure
        Module module;

        @Override
        public Account newAccount(AccountSettingsValue accountSettings) {
            EntityBuilder builder = this.module.unitOfWorkFactory().currentUnitOfWork().newEntityBuilder(Account.class);
            ((Account)builder.instance()).updateSettings(accountSettings);
            Account account = (Account)builder.newInstance();
            this.state.accounts().add(this.state.accounts().count(), (Object)account);
            return account;
        }

        @Override
        public void removeAccount(Account removedAccount) {
            this.state.accounts().remove((Object)removedAccount);
        }

        @Override
        public void visitAccounts(AccountVisitor visitor) {
            for (Account account : this.state.accounts()) {
                visitor.visitAccount(account);
            }
        }
    }

    public static interface Data {
        @Aggregated
        public ManyAssociation<Account> accounts();
    }
}

