/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.assembler;

import org.qi4j.bootstrap.ApplicationAssembler;
import org.qi4j.bootstrap.ApplicationAssembly;
import org.qi4j.bootstrap.ApplicationAssemblyFactory;
import org.qi4j.bootstrap.AssemblyException;
import org.qi4j.bootstrap.LayerAssembly;
import se.streamsource.streamflow.client.assembler.DomainAssembler;
import se.streamsource.streamflow.client.assembler.InfrastructureAssembler;
import se.streamsource.streamflow.client.assembler.ModelAssembler;
import se.streamsource.streamflow.client.assembler.RESTAssembler;
import se.streamsource.streamflow.client.assembler.UIAssembler;

public class StreamflowClientAssembler
implements ApplicationAssembler {
    Object[] serviceObjects;

    public StreamflowClientAssembler(Object ... serviceObjects) {
        this.serviceObjects = serviceObjects;
    }

    public ApplicationAssembly assemble(ApplicationAssemblyFactory applicationFactory) throws AssemblyException {
        ApplicationAssembly assembly = applicationFactory.newApplicationAssembly();
        assembly.setName("StreamflowClient");
        assembly.setVersion("0.1");
        LayerAssembly domainInfrastructureLayer = assembly.layer("Client domain infrastructure");
        LayerAssembly domainLayer = assembly.layer("Client domain");
        LayerAssembly modelLayer = assembly.layer("Client model");
        LayerAssembly restLayer = assembly.layer("REST Client");
        LayerAssembly uiLayer = assembly.layer("UI");
        uiLayer.uses(new LayerAssembly[]{modelLayer, domainLayer, domainInfrastructureLayer, restLayer});
        domainLayer.uses(new LayerAssembly[]{domainInfrastructureLayer, restLayer});
        modelLayer.uses(new LayerAssembly[]{domainLayer, domainInfrastructureLayer, restLayer});
        restLayer.uses(new LayerAssembly[]{domainInfrastructureLayer});
        new UIAssembler().assemble(uiLayer);
        new ModelAssembler().assemble(modelLayer);
        new DomainAssembler().assemble(domainLayer);
        new InfrastructureAssembler().assemble(domainInfrastructureLayer);
        new RESTAssembler().assembler(restLayer);
        for (Object serviceObject : this.serviceObjects) {
            assembly.setMetaInfo(serviceObject);
        }
        return assembly;
    }
}

