/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import javax.jnlp.ServiceManager;
import javax.jnlp.SingleInstanceListener;
import javax.jnlp.SingleInstanceService;
import javax.jnlp.UnavailableServiceException;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationAction;
import org.jdesktop.application.ProxyActions;
import org.jdesktop.application.SingleFrameApplication;
import org.jdesktop.application.TaskService;
import org.jdesktop.application.View;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.error.ErrorInfo;
import org.jdesktop.swingx.util.WindowUtils;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.io.Inputs;
import org.qi4j.api.io.Outputs;
import org.qi4j.api.io.Receiver;
import org.qi4j.bootstrap.ApplicationAssembler;
import org.qi4j.bootstrap.Energy4Java;
import org.qi4j.spi.property.ValueType;
import org.qi4j.spi.structure.ApplicationSPI;
import org.qi4j.spi.structure.ModuleSPI;
import org.restlet.Client;
import org.restlet.Request;
import org.restlet.Response;
import org.restlet.Restlet;
import org.restlet.data.Protocol;
import org.restlet.routing.Filter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import se.streamsource.dci.value.link.LinkValue;
import se.streamsource.streamflow.api.interaction.profile.UserProfileDTO;
import se.streamsource.streamflow.api.workspace.cases.CaseDTO;
import se.streamsource.streamflow.client.AboutDialog;
import se.streamsource.streamflow.client.MacOsUIExtension;
import se.streamsource.streamflow.client.StreamflowResources;
import se.streamsource.streamflow.client.assembler.StreamflowClientAssembler;
import se.streamsource.streamflow.client.ui.DebugWindow;
import se.streamsource.streamflow.client.ui.account.AccountResources;
import se.streamsource.streamflow.client.ui.account.AccountSelector;
import se.streamsource.streamflow.client.ui.account.AccountsDialog;
import se.streamsource.streamflow.client.ui.account.AccountsModel;
import se.streamsource.streamflow.client.ui.account.ProfileView;
import se.streamsource.streamflow.client.ui.administration.AdministrationWindow;
import se.streamsource.streamflow.client.ui.overview.OverviewWindow;
import se.streamsource.streamflow.client.ui.workspace.WorkspaceWindow;
import se.streamsource.streamflow.client.util.JavaHelp;
import se.streamsource.streamflow.client.util.dialog.DialogService;
import se.streamsource.streamflow.client.util.i18n;
import se.streamsource.streamflow.infrastructure.event.domain.DomainEvent;
import se.streamsource.streamflow.infrastructure.event.domain.TransactionDomainEvents;
import se.streamsource.streamflow.infrastructure.event.domain.source.EventStream;
import se.streamsource.streamflow.infrastructure.event.domain.source.TransactionListener;

@ProxyActions(value={"cut", "copy", "paste", "createDraft", "complete", "assign", "drop", "forward", "find", "selectTree", "selectTable", "selectDetails"})
public class StreamflowApplication
extends SingleFrameApplication
implements TransactionListener,
SingleInstanceListener {
    public static ValueType DOMAIN_EVENT_TYPE;
    final Logger logger = LoggerFactory.getLogger((String)((Object)((Object)this)).getClass().getName());
    final Logger streamflowLogger = LoggerFactory.getLogger((String)"streamflow");
    @Structure
    ModuleSPI module;
    @Service
    DialogService dialogs;
    @Service
    EventStream stream;
    @Service
    JavaHelp javaHelp;
    AccountsModel accountsModel;
    private AccountSelector accountSelector;
    WorkspaceWindow workspaceWindow;
    OverviewWindow overviewWindow;
    AdministrationWindow administrationWindow;
    DebugWindow debugWindow;
    public ApplicationSPI app;
    private String openCaseJson;

    public StreamflowApplication() {
        this.getContext().removeTaskService(this.getContext().getTaskService());
        this.getContext().addTaskService(new TaskService("default", Executors.newSingleThreadExecutor()));
        this.getContext().getResourceManager().setApplicationBundleNames(Arrays.asList("se.streamsource.streamflow.client.resources.StreamflowApplication"));
    }

    protected void initialize(String[] args) {
        File[] openFile = new File[1];
        if (args.length > 0 && args[0].equals("-open")) {
            this.openFile(new File(args[1]));
        }
        try {
            SingleInstanceService singleInstanceService = (SingleInstanceService)ServiceManager.lookup((String)SingleInstanceService.class.getName());
            singleInstanceService.addSingleInstanceListener((SingleInstanceListener)this);
        }
        catch (UnavailableServiceException unavailableServiceException) {
            // empty catch block
        }
    }

    public void newActivation(String[] args) {
        System.out.println("New args:" + Arrays.asList(args));
        if (args.length > 0) {
            this.initialize(args);
            CaseDTO caseDTO = (CaseDTO)this.module.valueBuilderFactory().newValueFromJSON(CaseDTO.class, this.openCaseJson);
            this.openCaseJson = null;
            this.workspaceWindow.getCurrentWorkspace().openCase((String)caseDTO.caseId().get());
        }
    }

    public void openFile(File file) {
        System.out.println("Opening: " + file);
        try {
            final StringBuffer buf = new StringBuffer();
            Inputs.text((File)file.getAbsoluteFile()).transferTo(Outputs.withReceiver((Receiver)new Receiver<String, RuntimeException>(){

                public void receive(String item) throws RuntimeException {
                    buf.append(item);
                }
            }));
            this.openCaseJson = buf.toString();
            System.out.println(buf);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void init(final @Uses AccountsModel accountsModel, final @Uses AccountSelector accountSelector, @Service EventStream stream) throws IllegalAccessException, UnsupportedLookAndFeelException, InstantiationException, ClassNotFoundException {
        DOMAIN_EVENT_TYPE = this.module.valueDescriptor(DomainEvent.class.getName()).valueType();
        this.stream = stream;
        try {
            ((Object)((Object)this)).getClass().getClassLoader().loadClass("com.apple.eawt.Application");
            MacOsUIExtension osUIExtension = new MacOsUIExtension(this);
            osUIExtension.attachMacUIExtension();
            osUIExtension.attachMacOpenFileExtension();
            osUIExtension.convertAccelerators();
        }
        catch (Throwable osUIExtension) {
            // empty catch block
        }
        String toolTipDismissDelay = i18n.text(StreamflowResources.tooltip_delay_dismiss, new Object[0]);
        String toolTipInitialDelay = i18n.text(StreamflowResources.tooltip_delay_initial, new Object[0]);
        String toolTipReshowDelay = i18n.text(StreamflowResources.tooltip_delay_reshow, new Object[0]);
        if (toolTipInitialDelay != null && !toolTipInitialDelay.trim().equals("")) {
            ToolTipManager.sharedInstance().setInitialDelay(Integer.parseInt(toolTipInitialDelay));
        }
        if (toolTipDismissDelay != null && !toolTipDismissDelay.trim().equals("")) {
            ToolTipManager.sharedInstance().setDismissDelay(Integer.parseInt(toolTipDismissDelay));
        }
        if (toolTipReshowDelay != null && !toolTipReshowDelay.trim().equals("")) {
            ToolTipManager.sharedInstance().setReshowDelay(Integer.parseInt(toolTipReshowDelay));
        }
        this.getContext().getActionMap().get((Object)"myProfile").setEnabled(false);
        this.accountSelector = accountSelector;
        this.workspaceWindow = (WorkspaceWindow)((Object)this.module.objectBuilderFactory().newObjectBuilder(WorkspaceWindow.class).use(new Object[]{accountSelector}).newInstance());
        this.overviewWindow = (OverviewWindow)((Object)this.module.objectBuilderFactory().newObjectBuilder(OverviewWindow.class).use(new Object[]{accountSelector}).newInstance());
        this.administrationWindow = (AdministrationWindow)((Object)this.module.objectBuilderFactory().newObjectBuilder(AdministrationWindow.class).use(new Object[]{accountSelector}).newInstance());
        this.debugWindow = (DebugWindow)((Object)this.module.objectBuilderFactory().newObjectBuilder(DebugWindow.class).newInstance());
        this.setMainFrame(this.workspaceWindow.getFrame());
        this.accountsModel = accountsModel;
        this.showWorkspaceWindow();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (accountsModel.getAccounts().size() == 1) {
                    accountSelector.setSelectedIndex(0);
                    if (StreamflowApplication.this.openCaseJson != null) {
                        CaseDTO caseDTO = (CaseDTO)StreamflowApplication.this.module.valueBuilderFactory().newValueFromJSON(CaseDTO.class, StreamflowApplication.this.openCaseJson);
                        StreamflowApplication.this.openCaseJson = null;
                        StreamflowApplication.this.workspaceWindow.getCurrentWorkspace().openCase((String)caseDTO.caseId().get());
                    }
                }
            }
        });
        accountSelector.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                StreamflowApplication.this.getContext().getActionMap().get((Object)"myProfile").setEnabled(!accountSelector.getSelectionModel().isSelectionEmpty());
            }
        });
        this.getContext().getActionMap().get((Object)"savePerspective").setEnabled(false);
        this.getContext().getActionMap().get((Object)"managePerspectives").setEnabled(false);
    }

    protected void startup() {
        try {
            Client client = new Client(Protocol.HTTP);
            client.start();
            Filter restlet = new Filter(client.getContext(), (Restlet)client){

                protected int beforeHandle(Request request, Response response) {
                    StreamflowApplication.this.workspaceWindow.getFrame().setCursor(Cursor.getPredefinedCursor(3));
                    return super.beforeHandle(request, response);
                }

                protected void afterHandle(Request request, Response response) {
                    StreamflowApplication.this.workspaceWindow.getFrame().setCursor(Cursor.getPredefinedCursor(0));
                    super.afterHandle(request, response);
                }
            };
            Energy4Java is = new Energy4Java();
            this.app = is.newApplication((ApplicationAssembler)new StreamflowClientAssembler(new Object[]{this, Application.getInstance().getContext(), restlet}));
            this.logger.info("Starting in " + this.app.mode() + " mode");
            this.app.activate();
        }
        catch (Throwable e) {
            JXErrorPane.showDialog((Component)this.getMainFrame(), (ErrorInfo)new ErrorInfo(i18n.text(StreamflowResources.startup_error, new Object[0]), e.getMessage(), null, "#error", e, Level.SEVERE, Collections.emptyMap()));
            this.shutdown();
        }
        this.streamflowLogger.info("Startup done");
    }

    @Action
    public void manageAccounts() {
        LinkValue selectedValue = (LinkValue)this.accountSelector.getSelectedValue();
        AccountsDialog dialog = (AccountsDialog)this.module.objectBuilderFactory().newObjectBuilder(AccountsDialog.class).use(new Object[]{this.accountsModel}).newInstance();
        dialog.setSelectedAccount(selectedValue);
        this.dialogs.showOkDialog(this.getMainFrame(), dialog, i18n.text(AccountResources.account_title, new Object[0]));
    }

    @Action
    public void selectAccount() {
        this.accountSelector.clearSelection();
        if (this.administrationWindow.getFrame().isVisible()) {
            this.administrationWindow.getFrame().setVisible(false);
            this.overviewWindow.getFrame().setVisible(false);
        }
    }

    @Action
    public void myProfile() {
        ProfileView profile = (ProfileView)this.module.objectBuilderFactory().newObjectBuilder(ProfileView.class).use(new Object[]{this.accountSelector.getSelectedAccount().getProfileModel()}).newInstance();
        this.dialogs.showOkDialog(this.getMainFrame(), profile, i18n.text(AccountResources.profile_title, new Object[0]));
    }

    @Action
    public void savePerspective(ActionEvent e) {
        ((ApplicationAction)this.getContext().getActionMap().get((Object)"savePerspective").getValue("proxy")).actionPerformed(e);
    }

    @Action
    public void managePerspectives(ActionEvent e) {
        ((ApplicationAction)this.getContext().getActionMap().get((Object)"managePerspectives").getValue("proxy")).actionPerformed(e);
    }

    @Action
    public void closeMessageDetails(ActionEvent e) {
        ((ApplicationAction)this.getContext().getActionMap().get((Object)"closeMessageDetails").getValue("proxy")).actionPerformed(e);
    }

    @Action
    public void createMessage(ActionEvent e) {
        ((ApplicationAction)this.getContext().getActionMap().get((Object)"createMessage").getValue("proxy")).actionPerformed(e);
    }

    @Action
    public void cancelNewMessage(ActionEvent e) {
        ((ApplicationAction)this.getContext().getActionMap().get((Object)"cancelNewMessage").getValue("proxy")).actionPerformed(e);
    }

    public EventStream getSource() {
        return this.stream;
    }

    public void notifyTransactions(Iterable<TransactionDomainEvents> transactions) {
        for (Window window : Frame.getWindows()) {
            this.dispatchTransactions(window, transactions);
        }
    }

    private void dispatchTransactions(Component component, Iterable<TransactionDomainEvents> transactionEventsIterable) {
        if (!component.isShowing()) {
            return;
        }
        if (component instanceof TransactionListener) {
            ((TransactionListener)component).notifyTransactions(transactionEventsIterable);
        }
        if (component instanceof Container) {
            Container container = (Container)component;
            for (Component childComponent : container.getComponents()) {
                this.dispatchTransactions(childComponent, transactionEventsIterable);
            }
        }
    }

    @Action
    public void showWorkspaceWindow() {
        if (!this.workspaceWindow.getFrame().isVisible()) {
            this.show((View)this.workspaceWindow);
        }
        this.workspaceWindow.getFrame().toFront();
    }

    @Action
    public void showOverviewWindow() throws Exception {
        if (!this.overviewWindow.getFrame().isVisible()) {
            this.show((View)this.overviewWindow);
        }
        this.overviewWindow.getFrame().toFront();
    }

    @Action
    public void showAdministrationWindow() throws Exception {
        if (!this.administrationWindow.getFrame().isVisible()) {
            this.show((View)this.administrationWindow);
        }
        this.administrationWindow.getFrame().toFront();
    }

    @Action
    public void showDebugWindow() throws Exception {
        if (!this.debugWindow.getFrame().isVisible()) {
            this.show((View)this.debugWindow);
        }
        this.debugWindow.getFrame().toFront();
    }

    @Action
    public void close(ActionEvent e) {
        WindowUtils.findWindow((Component)((Component)e.getSource())).dispose();
    }

    @Action
    public void cancel(ActionEvent e) {
        WindowUtils.findWindow((Component)((Component)e.getSource())).dispose();
    }

    @Action
    public void showAbout() {
        this.dialogs.showOkDialog(this.getMainFrame(), new AboutDialog(this.getContext()));
    }

    @Action
    public void showHelp(ActionEvent event) {
    }

    public void exit(EventObject eventObject) {
        super.exit(eventObject);
    }

    protected void shutdown() {
        try {
            SingleInstanceService singleInstanceService = (SingleInstanceService)ServiceManager.lookup((String)SingleInstanceService.class.getName());
            singleInstanceService.removeSingleInstanceListener((SingleInstanceListener)this);
        }
        catch (UnavailableServiceException singleInstanceService) {
            // empty catch block
        }
        try {
            if (this.app != null) {
                this.app.passivate();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void show(JComponent jComponent) {
        super.show(jComponent);
    }

    public String currentUserId() {
        return (String)this.accountSelector.getSelectedAccount().settings().userName().get();
    }

    public long markReadTimeout() {
        return (Long)((UserProfileDTO)this.accountSelector.getSelectedAccount().getProfileModel().getIndex()).markReadTimeout().get() * 1000L;
    }

    public void callRefresh() {
        if (this.workspaceWindow.getCurrentWorkspace().isVisible() && this.workspaceWindow.getCurrentWorkspace().isShowing()) {
            this.workspaceWindow.getCurrentWorkspace().refresh();
        }
    }
}

