/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client;

import com.apple.eawt.AboutHandler;
import com.apple.eawt.AppEvent;
import com.apple.eawt.Application;
import com.apple.eawt.OpenFilesHandler;
import com.apple.eawt.QuitHandler;
import com.apple.eawt.QuitResponse;
import java.io.File;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.KeyStroke;
import org.jdesktop.application.ApplicationActionMap;
import se.streamsource.streamflow.client.Icons;
import se.streamsource.streamflow.client.StreamflowApplication;
import se.streamsource.streamflow.client.util.i18n;

public class MacOsUIExtension {
    private StreamflowApplication application;

    public MacOsUIExtension(StreamflowApplication application) {
        this.application = application;
    }

    public void attachMacUIExtension() {
        Application macApp = Application.getApplication();
        macApp.setDockIconImage(i18n.icon(Icons.sf_icon, 128).getImage());
        macApp.setAboutHandler(new AboutHandler(){

            public void handleAbout(AppEvent.AboutEvent aboutEvent) {
                MacOsUIExtension.this.application.showAbout();
            }
        });
        macApp.setQuitHandler(new QuitHandler(){

            public void handleQuitRequestWith(AppEvent.QuitEvent quitEvent, QuitResponse quitResponse) {
                MacOsUIExtension.this.application.shutdown();
                quitResponse.performQuit();
            }
        });
    }

    public void attachMacOpenFileExtension() {
        if (System.getProperty("os.name").startsWith("Mac")) {
            Application macApplication = Application.getApplication();
            macApplication.setOpenFileHandler(new OpenFilesHandler(){

                public void openFiles(AppEvent.OpenFilesEvent openFilesEvent) {
                    MacOsUIExtension.this.application.openFile((File)openFilesEvent.getFiles().get(0));
                }
            });
        }
    }

    public void convertAccelerators() {
        Object[] keys;
        ApplicationActionMap actions = this.application.getContext().getActionMap();
        for (Object key : keys = actions.allKeys()) {
            String toolTip;
            Action action = actions.get(key);
            KeyStroke keyStroke = (KeyStroke)action.getValue("AcceleratorKey");
            Object ack = action.getValue("ActionCommandKey");
            if (keyStroke != null && keyStroke.toString().contains("ctrl")) {
                keyStroke = KeyStroke.getKeyStroke(keyStroke.toString().replace("ctrl", "meta"));
                action.putValue("AcceleratorKey", keyStroke);
            }
            if ((toolTip = (String)action.getValue("ShortDescription")) == null || !toolTip.contains("ctrl")) continue;
            toolTip = toolTip.replace("ctrl", "meta");
            action.putValue("ShortDescription", toolTip);
        }
    }

    public static void convertAccelerators(ActionMap actions) {
        Object[] keys;
        for (Object key : keys = actions.allKeys()) {
            String toolTip;
            Action action = actions.get(key);
            KeyStroke keyStroke = (KeyStroke)action.getValue("AcceleratorKey");
            Object ack = action.getValue("ActionCommandKey");
            if (keyStroke != null && keyStroke.toString().contains("ctrl")) {
                keyStroke = KeyStroke.getKeyStroke(keyStroke.toString().replace("ctrl", "meta"));
                action.putValue("AcceleratorKey", keyStroke);
            }
            if ((toolTip = (String)action.getValue("ShortDescription")) == null || !toolTip.contains("ctrl")) continue;
            toolTip = toolTip.replace("ctrl", "meta");
            action.putValue("ShortDescription", toolTip);
        }
    }
}

