/**
 *
 * Copyright
 * 2009-2015 Jayway Products AB
 * 2016-2017 Föreningen Sambruk
 *
 * Licensed under AGPL, Version 3.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.gnu.org/licenses/agpl.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package se.streamsource.streamflow.client.util;

import ca.odell.glazedlists.SeparatorList;
import se.streamsource.streamflow.client.ui.ContextItem;

import javax.swing.*;
import java.awt.*;

/**
 * JAVADOC
 */
public class SeparatorContextItemListCellRenderer
   extends DefaultListCellRenderer
{
   private ListCellRenderer next;

   public SeparatorContextItemListCellRenderer( ListCellRenderer next )
   {
      this.next = next;
   }

   public Component getListCellRendererComponent( JList list, Object value, int index, boolean isSelected, boolean cellHasFocus )
   {
      if (value instanceof SeparatorList.Separator)
      {
         SeparatorList.Separator separator = (SeparatorList.Separator) value;
         Component component = super.getListCellRendererComponent( list, ((ContextItem)separator.first()).getGroup(), index, isSelected, cellHasFocus );
         setFont( getFont().deriveFont( Font.BOLD ));
         return component;
      } else
         return next.getListCellRendererComponent( list, value, index, isSelected, cellHasFocus );
   }
}
