/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.util.popup;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.Action;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.qi4j.api.util.Iterables;
import se.streamsource.streamflow.client.util.StreamflowToggleButton;
import se.streamsource.streamflow.client.util.popup.PopupHandler;
import se.streamsource.streamflow.client.util.popup.RefreshHandler;

public class StandardPopupHandler
implements PopupHandler {
    private StreamflowToggleButton button;
    private JPanel optionsPanel;
    private JDialog popup;
    private final JPanel parentPanel;
    private PopupHandler.Position position;
    private boolean refreshOnClose;
    private RefreshHandler refreshHandler;

    public StandardPopupHandler(JPanel parent, Action action, RefreshHandler refreshHandler) {
        this(parent, action, PopupHandler.Position.left, true, refreshHandler);
    }

    public StandardPopupHandler(JPanel parent, Action action, PopupHandler.Position position, boolean refreshOnClose, RefreshHandler refreshHandler) {
        this.parentPanel = parent;
        this.position = position;
        this.refreshOnClose = refreshOnClose;
        this.refreshHandler = refreshHandler;
        this.button = new StreamflowToggleButton(action);
        this.button.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                int state = itemEvent.getStateChange();
                if (state == 1) {
                    StandardPopupHandler.this.cleanToggleButtonSelection();
                    StandardPopupHandler.this.optionsPanel = new JPanel();
                    JToggleButton button = (JToggleButton)itemEvent.getSource();
                    StandardPopupHandler.this.showPopup(button);
                } else if (state == 2) {
                    StandardPopupHandler.this.kill();
                }
            }
        });
    }

    @Override
    public StreamflowToggleButton getButton() {
        return this.button;
    }

    @Override
    public void setPanelContent(JPanel filterPanel) {
        this.optionsPanel.add(filterPanel);
    }

    private void showPopup(final Component button) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (StandardPopupHandler.this.popup != null) {
                    StandardPopupHandler.this.popup.dispose();
                    StandardPopupHandler.this.popup = null;
                }
                final JFrame frame = (JFrame)SwingUtilities.getAncestorOfClass(JFrame.class, StandardPopupHandler.this.parentPanel);
                StandardPopupHandler.this.popup = new JDialog(frame);
                StandardPopupHandler.this.popup.getRootPane().registerKeyboardAction(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        System.out.println("Enter");
                        StandardPopupHandler.this.kill();
                        StandardPopupHandler.this.cleanToggleButtonSelection();
                    }
                }, KeyStroke.getKeyStroke(10, 0), 2);
                StandardPopupHandler.this.popup.setUndecorated(true);
                StandardPopupHandler.this.popup.setModal(false);
                StandardPopupHandler.this.popup.setLayout(new BorderLayout());
                StandardPopupHandler.this.popup.add((Component)StandardPopupHandler.this.optionsPanel, "Center");
                Point location = button.getLocationOnScreen();
                int diff = 0;
                if (StandardPopupHandler.this.position == PopupHandler.Position.right) {
                    diff = (int)StandardPopupHandler.this.optionsPanel.getPreferredSize().getWidth() - button.getWidth();
                }
                StandardPopupHandler.this.popup.setBounds((int)location.getX() - diff, (int)location.getY() + button.getHeight(), StandardPopupHandler.this.optionsPanel.getWidth(), StandardPopupHandler.this.optionsPanel.getHeight());
                StandardPopupHandler.this.popup.pack();
                StandardPopupHandler.this.popup.setVisible(true);
                frame.addComponentListener(new ComponentAdapter(){

                    @Override
                    public void componentMoved(ComponentEvent e) {
                        if (StandardPopupHandler.this.popup != null) {
                            System.out.println("Moved");
                            StandardPopupHandler.this.kill();
                            ((JToggleButton)button).setSelected(false);
                            frame.removeComponentListener(this);
                        }
                    }
                });
            }
        });
    }

    @Override
    public void kill() {
        if (this.popup != null) {
            this.popup.setVisible(false);
            this.popup.dispose();
            this.popup = null;
        }
        if (this.refreshOnClose) {
            this.refreshHandler.refresh();
        }
    }

    private void cleanToggleButtonSelection() {
        for (Component component : Iterables.flatten((Iterable[])new Iterable[]{Iterables.iterable((Object[])this.parentPanel.getComponents()), Iterables.iterable((Object[])this.parentPanel.getComponents())})) {
            if (!(component instanceof JToggleButton) || !((JToggleButton)component).isSelected() || component == this.button) continue;
            ((JToggleButton)component).setSelected(false);
        }
    }
}

