/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.util.dialog;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.swing.EventListModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.ActionMap;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.swingx.util.WindowUtils;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Structure;
import org.qi4j.api.injection.scope.Uses;
import org.qi4j.api.structure.Module;
import se.streamsource.dci.value.link.LinkValue;
import se.streamsource.dci.value.link.LinksBuilder;
import se.streamsource.dci.value.link.LinksValue;
import se.streamsource.streamflow.client.util.LinkListCellRenderer;

public class SelectLinksDialog
extends JPanel {
    private LinksValue selectedLinks;
    private JList list;
    @Structure
    Module module;

    public SelectLinksDialog(@Service ApplicationContext context, @Uses EventList<LinkValue> model) {
        super(new BorderLayout());
        this.setActionMap((ActionMap)context.getActionMap((Object)this));
        this.getActionMap().put("close", this.getActionMap().get("cancel"));
        this.list = new JList(new EventListModel(model));
        this.list.setCellRenderer(new LinkListCellRenderer());
        JScrollPane scrollPane = new JScrollPane(this.list);
        this.add((Component)scrollPane, "Center");
        this.setPreferredSize(new Dimension(200, 300));
    }

    @Action
    public void execute() {
        LinksBuilder linksBuilder = new LinksBuilder(this.module.valueBuilderFactory());
        for (Object value : this.list.getSelectedValues()) {
            LinkValue linkValue = (LinkValue)value;
            linksBuilder.addLink(linkValue);
        }
        this.selectedLinks = linksBuilder.newLinks();
        WindowUtils.findWindow((Component)this).dispose();
    }

    @Action
    public void cancel() {
        WindowUtils.findWindow((Component)this).dispose();
    }

    public LinksValue getSelectedLinks() {
        return this.selectedLinks;
    }
}

