/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.util.dialog;

import com.jgoodies.forms.builder.ButtonBarBuilder2;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.swingx.JXDialog;
import org.jdesktop.swingx.util.WindowUtils;
import org.qi4j.api.injection.scope.Service;
import se.streamsource.streamflow.client.util.StreamflowButton;

public class DialogService {
    @Service
    ApplicationContext context;

    public void showOkCancelHelpDialog(Component owner, JComponent main) {
        JXDialog dialog = this.createDialog(owner, main, Orientation.left);
        dialog.setVisible(true);
    }

    public void showOkCancelHelpDialog(Component owner, JComponent main, String title) {
        JXDialog dialog = this.createDialog(owner, main, Orientation.left);
        dialog.setTitle(title);
        dialog.setVisible(true);
    }

    public void showOkCancelHelpDialog(Component owner, JComponent main, String title, Orientation orientation) {
        JXDialog dialog = this.createDialog(owner, main, orientation);
        dialog.setTitle(title);
        dialog.setVisible(true);
    }

    private JXDialog createDialog(Component owner, JComponent main, Orientation orientation) {
        Window window = WindowUtils.findWindow((Component)owner);
        JXDialog dialog = window instanceof Frame ? new JXDialog((Frame)window, main) : new JXDialog((Dialog)window, main);
        dialog.setModal(true);
        dialog.pack();
        if (owner instanceof StreamflowButton) {
            Point location = new Point(owner.getLocationOnScreen());
            switch (Orientation.valueOf(orientation.name())) {
                case left: {
                    location.translate(0, owner.getHeight());
                    break;
                }
                case right: {
                    location.translate(owner.getWidth() - dialog.getWidth(), owner.getHeight());
                }
            }
            dialog.setLocation(location);
        } else {
            dialog.setLocationRelativeTo((Component)SwingUtilities.getAncestorOfClass(Frame.class, owner));
        }
        return dialog;
    }

    public void showOkDialog(Component owner, JComponent main) {
        JXDialog dialog = this.createOkDialog(owner, main);
        dialog.setVisible(true);
    }

    private JXDialog createOkDialog(Component owner, JComponent main) {
        Window window = WindowUtils.findWindow((Component)owner);
        JXDialog dialog = window instanceof Frame ? new JXDialog((Frame)window, main) : new JXDialog((Dialog)window, main);
        final JXDialog finalDialog = dialog;
        javax.swing.Action ok = main.getActionMap().get("execute");
        if (ok == null) {
            ok = this.context.getActionMap().get((Object)"cancel");
        }
        dialog.getContentPane().setLayout(new BorderLayout());
        StreamflowButton okButton = new StreamflowButton(ok);
        dialog.getContentPane().add("South", this.createOKBar(okButton));
        dialog.getContentPane().add("Center", main);
        dialog.setMinimumSize(new Dimension(300, 100));
        dialog.pack();
        dialog.setLocationRelativeTo(owner);
        dialog.setModal(true);
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                finalDialog.setVisible(false);
                WindowUtils.findWindow((Component)finalDialog).dispose();
            }
        });
        return dialog;
    }

    private JXDialog createButtonLessDialog(Component owner, JComponent main) {
        Window window = WindowUtils.findWindow((Component)owner);
        JXDialog dialog = window instanceof Frame ? new JXDialog((Frame)window, main) : new JXDialog((Dialog)window, main);
        JXDialog finalDialog = dialog;
        dialog.getContentPane().setLayout(new BorderLayout());
        dialog.getContentPane().add("Center", main);
        dialog.setMinimumSize(new Dimension(300, 100));
        dialog.pack();
        dialog.setLocationRelativeTo(owner);
        dialog.setModal(true);
        return dialog;
    }

    private JPanel createHelpOKCancelApplyBar(StreamflowButton help, StreamflowButton ok, StreamflowButton cancel, StreamflowButton apply) {
        ButtonBarBuilder2 builder = new ButtonBarBuilder2();
        builder.addButton((JComponent)help);
        builder.addUnrelatedGap();
        builder.addGlue();
        builder.addButton((JComponent[])new StreamflowButton[]{ok, cancel, apply});
        return builder.getPanel();
    }

    private JPanel createOKBar(StreamflowButton ok) {
        ButtonBarBuilder2 builder = new ButtonBarBuilder2();
        builder.addUnrelatedGap();
        builder.addGlue();
        builder.addButton((JComponent[])new StreamflowButton[]{ok});
        return builder.getPanel();
    }

    private JPanel createButtonBar(StreamflowButton ok, StreamflowButton[] extras) {
        ButtonBarBuilder2 builder = new ButtonBarBuilder2();
        builder.addButton((JComponent[])extras);
        builder.addUnrelatedGap();
        builder.addGlue();
        builder.addButton((JComponent[])new StreamflowButton[]{ok});
        return builder.getPanel();
    }

    private JPanel createHelpOKCancelBar(StreamflowButton help, StreamflowButton ok, StreamflowButton cancel) {
        ButtonBarBuilder2 builder = new ButtonBarBuilder2();
        builder.addButton((JComponent)help);
        builder.addUnrelatedGap();
        builder.addGlue();
        builder.addButton((JComponent[])new StreamflowButton[]{ok, cancel});
        return builder.getPanel();
    }

    public void showOkDialog(Component component, JComponent main, String title) {
        JXDialog dialog = this.createOkDialog(component, main);
        dialog.setTitle(title);
        dialog.setVisible(true);
    }

    public void showButtonLessDialog(Component component, JComponent main, String title) {
        JXDialog dialog = this.createButtonLessDialog(component, main);
        dialog.setTitle(title);
        dialog.setVisible(true);
    }

    public void showMessageDialog(Component component, String message, String title) {
        MessageLabel messageLabel = new MessageLabel(message);
        messageLabel.setActionMap((ActionMap)this.context.getActionMap((Object)messageLabel));
        JXDialog dialog = this.createOkDialog(component, messageLabel);
        dialog.setTitle(title);
        dialog.setVisible(true);
    }

    public static class MessageLabel
    extends JLabel {
        private MessageLabel(String text) {
            super(text);
            this.setBorder(BorderFactory.createEmptyBorder(5, 15, 5, 15));
        }

        @Action
        public void execute() {
        }
    }

    public static enum Orientation {
        right,
        left;

    }
}

