/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.util;

import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.qi4j.api.specification.Specification;
import org.qi4j.api.specification.Specifications;
import org.qi4j.api.util.Iterables;
import se.streamsource.dci.value.ResourceValue;
import se.streamsource.dci.value.link.LinkValue;
import se.streamsource.dci.value.link.Links;
import se.streamsource.streamflow.client.util.Components;

public class RefreshComponents
implements Observer {
    Map<Specification<LinkValue>, Component> visibles = new HashMap<Specification<LinkValue>, Component>();
    Map<Specification<LinkValue>, Component> enableds = new HashMap<Specification<LinkValue>, Component>();

    public RefreshComponents visibleOn(String commandOrQuery, Component ... components) {
        for (Component component : components) {
            this.visibles.put((Specification<LinkValue>)Links.withRel((String)commandOrQuery), component);
        }
        return this;
    }

    public RefreshComponents enabledOn(String commandOrQuery, Component ... components) {
        for (Component component : components) {
            this.enableds.put((Specification<LinkValue>)Links.withRel((String)commandOrQuery), component);
        }
        return this;
    }

    @Override
    public void update(Observable o, Object arg) {
        if (arg instanceof ResourceValue) {
            this.refresh((ResourceValue)arg);
        }
    }

    public void refresh(ResourceValue resourceValue) {
        Component value;
        for (Map.Entry<Specification<LinkValue>, Component> en : this.visibles.entrySet()) {
            value = en.getValue();
            for (Component component : Components.components((Specification<Component>)Specifications.TRUE(), value)) {
                component.setVisible(resourceValue != null && Iterables.matchesAny(en.getKey(), (Iterable)Iterables.flatten((Iterable[])new Iterable[]{(Iterable)resourceValue.queries().get(), (Iterable)resourceValue.commands().get()})));
            }
        }
        for (Map.Entry<Specification<LinkValue>, Component> en : this.enableds.entrySet()) {
            value = en.getValue();
            for (Component component : Components.components((Specification<Component>)Specifications.TRUE(), value)) {
                boolean enabled = resourceValue != null && Iterables.matchesAny(en.getKey(), (Iterable)Iterables.flatten((Iterable[])new Iterable[]{(Iterable)resourceValue.queries().get(), (Iterable)resourceValue.commands().get()}));
                component.setEnabled(enabled);
            }
        }
    }
}

