/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.util;

import ca.odell.glazedlists.SeparatorList;
import ca.odell.glazedlists.swing.EventListModel;
import com.jgoodies.forms.factories.Borders;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.qi4j.api.specification.Specification;
import se.streamsource.dci.value.link.LinkValue;
import se.streamsource.dci.value.link.TitledLinkValue;
import se.streamsource.streamflow.client.ui.OptionsAction;
import se.streamsource.streamflow.client.util.LinkListCellRenderer;
import se.streamsource.streamflow.client.util.SelectionActionEnabler;
import se.streamsource.streamflow.client.util.SeparatorListCellRenderer;
import se.streamsource.streamflow.client.util.StreamflowButton;
import se.streamsource.streamflow.client.util.TabbedResourceView;
import se.streamsource.streamflow.infrastructure.event.domain.TransactionDomainEvents;
import se.streamsource.streamflow.infrastructure.event.domain.source.TransactionListener;
import se.streamsource.streamflow.infrastructure.event.domain.source.helper.Events;

public abstract class ListDetailView
extends JSplitPane
implements TransactionListener {
    protected JList list;

    public ListDetailView() {
        this.setBorder(Borders.createEmptyBorder((String)"2dlu, 2dlu, 2dlu, 2dlu"));
        this.setRightComponent(new JPanel());
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setDividerLocation(250);
        this.setOneTouchExpandable(true);
    }

    protected void initMaster(EventListModel<LinkValue> listModel, Action createAction, Action[] selectionActions, DetailFactory factory, ListCellRenderer renderer) {
        this.initMaster(listModel, createAction, new SelectionActionEnabler(selectionActions), false, factory, renderer);
    }

    protected void initMaster(EventListModel<LinkValue> listModel, Action createAction, Action[] selectionActions, DetailFactory factory) {
        this.initMaster(listModel, createAction, selectionActions, false, factory);
    }

    protected void initMaster(EventListModel<LinkValue> listModel, Action createAction, SelectionActionEnabler selectionActionEnabler, DetailFactory factory) {
        this.initMaster(listModel, createAction, selectionActionEnabler, false, factory);
    }

    protected void initMaster(EventListModel<LinkValue> listModel, Action createAction, Action[] selectionActions, boolean actionsWithoutOption, DetailFactory factory) {
        this.initMaster(listModel, createAction, new SelectionActionEnabler(selectionActions), actionsWithoutOption, factory, new LinkListCellRenderer());
    }

    protected void initMaster(EventListModel<LinkValue> listModel, Action createAction, SelectionActionEnabler selectionActionEnabler, boolean actionsWithoutOption, DetailFactory factory) {
        this.initMaster(listModel, createAction, selectionActionEnabler, actionsWithoutOption, factory, new LinkListCellRenderer());
    }

    protected void initMaster(EventListModel<LinkValue> listModel, Action createAction, SelectionActionEnabler selectionActionEnabler, DetailFactory factory, ListCellRenderer renderer) {
        this.initMaster(listModel, createAction, selectionActionEnabler, false, factory, renderer);
    }

    protected void initMaster(EventListModel<TitledLinkValue> listModel, DetailFactory factory) {
        this.initMaster(listModel, null, new SelectionActionEnabler(new Action[0]), false, factory, new SeparatorListCellRenderer(new LinkListCellRenderer()));
    }

    protected void initMaster(EventListModel<? extends LinkValue> listModel, Action createAction, SelectionActionEnabler selectionActionEnabler, boolean actionsWithoutOption, final DetailFactory factory, ListCellRenderer renderer) {
        this.list = new JList<LinkValue>((ListModel<? extends LinkValue>)listModel);
        this.list.setSelectionMode(0);
        this.list.setCellRenderer(renderer);
        JScrollPane scrollPane = new JScrollPane(this.list);
        JPanel master = new JPanel(new BorderLayout());
        master.add((Component)scrollPane, "Center");
        JPanel toolbar = new JPanel();
        if (createAction != null) {
            toolbar.add(new StreamflowButton(createAction));
        }
        this.list.getSelectionModel().addListSelectionListener(selectionActionEnabler);
        if (actionsWithoutOption) {
            for (Action selectionAction : selectionActionEnabler.getActions()) {
                toolbar.add(new StreamflowButton(selectionAction));
            }
        } else if (selectionActionEnabler.getActions().length != 0) {
            JPopupMenu options = new JPopupMenu();
            for (Action selectionAction : selectionActionEnabler.getActions()) {
                options.add(selectionAction);
            }
            toolbar.add(new StreamflowButton(new OptionsAction(options)));
        }
        master.add((Component)toolbar, "South");
        this.setLeftComponent(master);
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting() && !(ListDetailView.this.list.getSelectedValue() instanceof SeparatorList.Separator)) {
                    LinkValue detailLink = (LinkValue)ListDetailView.this.list.getSelectedValue();
                    if (detailLink != null) {
                        ListDetailView parentListDetailView;
                        Component detailView;
                        int selectedIndex = -1;
                        if (ListDetailView.this.getRightComponent() != null && ListDetailView.this.getRightComponent() instanceof TabbedResourceView) {
                            TabbedResourceView tabbedResourceView = (TabbedResourceView)ListDetailView.this.getRightComponent();
                        }
                        if ((detailView = factory.createDetail(detailLink)) instanceof TabbedResourceView) {
                            // empty if block
                        }
                        ListDetailView.this.setRightComponent(detailView);
                        if ((detailView instanceof ListDetailView || detailView instanceof TabbedResourceView) && (parentListDetailView = (ListDetailView)SwingUtilities.getAncestorOfClass(ListDetailView.class, ListDetailView.this)) != null) {
                            parentListDetailView.setDividerLocation(0);
                        }
                    } else {
                        ListDetailView.this.setRightComponent(new JPanel());
                    }
                }
            }
        });
    }

    protected LinkValue getSelectedValue() {
        return (LinkValue)this.list.getSelectedValue();
    }

    public void notifyTransactions(Iterable<TransactionDomainEvents> transactions) {
        if (Events.matches((Specification)Events.withUsecases((String[])new String[]{"delete", "move"}), transactions) && !Events.matches((Specification)Events.withNames((String[])new String[]{"removedSelectedForm", "removedParticipant"}), transactions)) {
            this.list.clearSelection();
        }
    }

    public static interface DetailFactory {
        public Component createDetail(LinkValue var1);
    }
}

