/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.util;

import java.io.IOException;
import java.io.StringReader;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import se.streamsource.streamflow.client.util.HtmlParserGetter;

public class HtmlErrorMessageExtractor
extends HTMLEditorKit.ParserCallback {
    boolean body = false;
    boolean grabHeading = false;
    String heading = "";

    public static String parse(String msg) {
        HTMLEditorKit.Parser parser = new HtmlParserGetter().getParser();
        HtmlErrorMessageExtractor extractor = new HtmlErrorMessageExtractor();
        try {
            parser.parse(new StringReader(msg), extractor, true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return extractor.getHeading();
    }

    @Override
    public void handleText(char[] data, int pos) {
        if (this.body && this.grabHeading) {
            this.heading = new String(data);
        }
    }

    @Override
    public void handleStartTag(HTML.Tag t, MutableAttributeSet a, int pos) {
        if (t == HTML.Tag.BODY) {
            this.body = true;
        }
        if (this.body && t == HTML.Tag.H3) {
            this.grabHeading = true;
        }
    }

    @Override
    public void handleEndTag(HTML.Tag t, int pos) {
        if (t == HTML.Tag.BODY) {
            this.body = false;
        }
        if (this.body && t == HTML.Tag.H3) {
            this.grabHeading = false;
        }
    }

    public String getHeading() {
        return this.heading;
    }
}

