/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.util;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.jdesktop.application.Application;
import org.jdesktop.application.SingleFrameApplication;
import org.jdesktop.application.Task;
import org.qi4j.api.util.Iterables;
import org.restlet.data.Status;
import org.restlet.resource.ResourceException;
import se.streamsource.streamflow.api.ErrorResources;
import se.streamsource.streamflow.client.OperationException;
import se.streamsource.streamflow.client.StreamflowApplication;
import se.streamsource.streamflow.client.util.i18n;
import se.streamsource.streamflow.infrastructure.event.domain.TransactionDomainEvents;
import se.streamsource.streamflow.infrastructure.event.domain.source.EventStream;
import se.streamsource.streamflow.infrastructure.event.domain.source.TransactionListener;

public abstract class CommandTask
extends Task<Iterable<TransactionDomainEvents>, Object>
implements TransactionListener {
    protected Object source = null;
    private List<TransactionDomainEvents> transactionDomains = new ArrayList<TransactionDomainEvents>();

    public CommandTask() {
        super(Application.getInstance());
        try {
            this.source = EventQueue.getCurrentEvent().getSource();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    protected abstract void command() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Iterable<TransactionDomainEvents> doInBackground() throws Exception {
        StreamflowApplication application = (StreamflowApplication)this.getApplication();
        EventStream stream = application.getSource();
        stream.registerListener((TransactionListener)this);
        try {
            this.command();
            List<TransactionDomainEvents> list = this.transactionDomains;
            return list;
        }
        catch (Throwable t) {
            this.failed(t);
            List<TransactionDomainEvents> list = this.transactionDomains;
            return list;
        }
        finally {
            stream.unregisterListener((TransactionListener)this);
        }
    }

    public void notifyTransactions(Iterable<TransactionDomainEvents> transactions) {
        Iterables.addAll(this.transactionDomains, transactions);
    }

    protected void succeeded(final Iterable<TransactionDomainEvents> transactionEventsIterable) {
        final Application application = Application.getInstance();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ((TransactionListener)application).notifyTransactions(transactionEventsIterable);
            }
        });
    }

    protected void failed(Throwable throwable) {
        if (throwable instanceof ResourceException) {
            ResourceException re = (ResourceException)throwable;
            if (re.getStatus().equals((Object)Status.CLIENT_ERROR_UNPROCESSABLE_ENTITY) || re.getStatus().equals((Object)Status.SERVER_ERROR_INTERNAL) || re.getStatus().equals((Object)Status.REDIRECTION_NOT_MODIFIED)) {
                String exceptionMessage = re.getStatus().getDescription();
                if (ErrorResources.valueOf((String)exceptionMessage) != null) {
                    exceptionMessage = i18n.text((Enum)ErrorResources.valueOf((String)exceptionMessage), new Object[0]);
                }
                JFrame frame = this.source instanceof Component ? (Frame)SwingUtilities.getAncestorOfClass(Frame.class, (Component)this.source) : ((SingleFrameApplication)Application.getInstance()).getMainFrame();
                JOptionPane.showMessageDialog(frame, new JLabel(exceptionMessage), "", 0);
            } else if (re.getStatus().equals((Object)Status.CLIENT_ERROR_CONFLICT)) {
                throw new OperationException((Enum)ErrorResources.error, throwable);
            }
        } else {
            if (throwable instanceof OperationException) {
                throw (OperationException)throwable;
            }
            throw new OperationException((Enum)ErrorResources.error, throwable);
        }
    }
}

