/*
 * Decompiled with CFR 0.152.
 */
package se.streamsource.streamflow.client.ui.workspace.table;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.swingx.JXMonthView;
import org.jdesktop.swingx.JXTextField;
import org.qi4j.api.injection.scope.Service;
import org.qi4j.api.injection.scope.Uses;
import se.streamsource.streamflow.client.Icons;
import se.streamsource.streamflow.client.ui.workspace.WorkspaceResources;
import se.streamsource.streamflow.client.ui.workspace.table.Period;
import se.streamsource.streamflow.client.ui.workspace.table.PerspectivePeriodModel;
import se.streamsource.streamflow.client.util.dialog.DialogService;
import se.streamsource.streamflow.client.util.i18n;

public class PerspectivePeriodView
extends JPanel {
    @Service
    DialogService dialogs;
    boolean isCreationDate;
    PerspectivePeriodModel model;

    public void initView(final @Uses PerspectivePeriodModel model) {
        this.setLayout(new BorderLayout());
        this.model = model;
        final JXTextField dateField = new JXTextField();
        dateField.setBorder((Border)BorderFactory.createTitledBorder(i18n.text(WorkspaceResources.search_period, new Object[0])));
        dateField.setEditable(false);
        dateField.setText(model.getSearchValue(i18n.text(WorkspaceResources.date_format, new Object[0]), " " + i18n.text(WorkspaceResources.date_separator, new Object[0]) + " "));
        final JXMonthView monthView = new JXMonthView();
        monthView.setTraversable(true);
        if (model.getDate() != null) {
            monthView.setSelectionDate(model.getDate());
            monthView.ensureDateVisible(model.getDate());
        }
        final JList<Period> list = new JList<Period>(Period.values());
        list.setSelectedValue((Object)model.getPeriod(), true);
        list.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                this.setFont(list.getFont());
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
                if (value.equals((Object)model.getPeriod())) {
                    this.setIcon(i18n.icon(Icons.check, 12));
                    this.setBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0));
                } else {
                    this.setIcon(null);
                    this.setBorder(BorderFactory.createEmptyBorder(4, 16, 0, 0));
                }
                this.setText(i18n.text((Period)((Object)value), new Object[0]));
                return this;
            }
        });
        list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                if (!event.getValueIsAdjusting()) {
                    model.setPeriod((Period)((Object)list.getSelectedValue()));
                    if (model.getPeriod().equals((Object)Period.none)) {
                        monthView.clearSelection();
                        model.setDate(null);
                    } else {
                        model.setPeriod((Period)((Object)list.getSelectedValue()));
                    }
                    dateField.setText(model.getSearchValue(i18n.text(WorkspaceResources.date_format, new Object[0]), " " + i18n.text(WorkspaceResources.date_separator, new Object[0]) + " "));
                }
            }
        });
        this.add(list, "West");
        JPanel datePicker = new JPanel(new BorderLayout());
        datePicker.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        monthView.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                model.setDate(monthView.getSelectionDate());
                dateField.setText(model.getSearchValue(i18n.text(WorkspaceResources.date_format, new Object[0]), " " + i18n.text(WorkspaceResources.date_separator, new Object[0]) + " "));
            }
        });
        this.add((Component)dateField, "North");
        datePicker.add((Component)monthView, "Center");
        this.add((Component)datePicker, "East");
    }
}

